/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.action.controller.UploadedResourceController;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.ChangeClusterTagArgument;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.debug.DebugInfoArgument;
import org.gridgain.control.agent.dto.action.debug.DebugInfoItem;
import org.gridgain.control.agent.dto.action.log.CollectLogResponse;
import org.gridgain.control.agent.dto.topology.TopologySnapshot;
import org.gridgain.control.agent.processor.TopologyProcessor;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentObjectMapperFactory;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Test;
import org.springframework.boot.test.json.BasicJsonTester;
import org.springframework.boot.test.json.JsonContentAssert;

public class ClusterActionsControllerTest
extends AbstractActionControllerTest {
    private final BasicJsonTester json = new BasicJsonTester(this.getClass());

    @Override
    @After
    public void teardown() {
        super.teardown();
        UploadedResourceController.RESOURCES.clear();
    }

    @Test
    public void activateCluster() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.activate").setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && this.cluster.state() == ClusterState.ACTIVE;
        });
    }

    @Test
    public void deactivateCluster() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.deactivate").setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && this.cluster.state() == ClusterState.INACTIVE;
        });
    }

    @Test
    public void changeTag() {
        String newTag = "Test cluster";
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.changeTag").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new ChangeClusterTagArgument().setTag(newTag));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && this.cluster.tag().equals(newTag);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportLogs(String action, Object arg) throws Exception {
        File logFolder = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"log", (boolean)false);
        Path file1 = Paths.get(logFolder.getAbsolutePath(), "ggcc-agent-1900-01-01-0.log");
        Path file2 = Paths.get(logFolder.getAbsolutePath(), "ggcc-agent-1900-01-01-1.log");
        try {
            Files.write(file1, Arrays.asList("The first line", "The second line"), new OpenOption[0]);
            Files.write(file2, Arrays.asList("The first line"), new OpenOption[0]);
            Files.setLastModifiedTime(file1, FileTime.fromMillis(TimeUnit.HOURS.toMillis(3L)));
            Files.setLastModifiedTime(file2, FileTime.fromMillis(TimeUnit.HOURS.toMillis(23L)));
            Request req = new Request().setId(UUID.randomUUID()).setAction(action).setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument(arg);
            this.executeAction((AbstractRequest)req, res -> {
                JobResponse r = (JobResponse)F.first((List)res);
                if (r == null) {
                    return false;
                }
                org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
                CollectLogResponse actRes = this.result(r, new TypeReference<CollectLogResponse>(){});
                List<UploadedResourceController.FileContent> files = UploadedResourceController.RESOURCES.get(UUID.fromString(actRes.getResourceId()));
                org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)files.size());
                return true;
            });
        }
        finally {
            U.delete((Path)file1);
            U.delete((Path)file2);
        }
    }

    @Test
    public void shouldExportLogs() throws Exception {
        this.exportLogs("ClusterActions.exportLogs", 0L);
        this.exportLogs("ClusterActions.exportDebugInfo", new DebugInfoArgument().setDebugInfoItems(Collections.singleton(DebugInfoItem.LOG)).setFromTs(0L));
    }

    private void shouldSendErrorIfMissingLogs(String action, Object arg) {
        Request req = new Request().setId(UUID.randomUUID()).setAction(action).setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument(arg);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            org.junit.jupiter.api.Assertions.assertEquals((int)-32603, (int)r.getError().getCode());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"No activities logged in the selected date range", (Object)r.getError().getMessage());
            return true;
        });
    }

    @Test
    public void shouldSendErrorIfMissingLogs() {
        this.shouldSendErrorIfMissingLogs("ClusterActions.exportLogs", -1L);
        this.shouldSendErrorIfMissingLogs("ClusterActions.exportDebugInfo", new DebugInfoArgument().setDebugInfoItems(Collections.singleton(DebugInfoItem.LOG)).setFromTs(-1L));
    }

    @Test
    public void shouldIgnoreErrorIfMissingLogs() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.exportDebugInfo").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DebugInfoArgument().setDebugInfoItems(F.asSet((Object[])new DebugInfoItem[]{DebugInfoItem.LOG, DebugInfoItem.THREAD_DUMP})).setFromTs(0L));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            CollectLogResponse actRes = this.result(r, new TypeReference<CollectLogResponse>(){});
            List<UploadedResourceController.FileContent> files = UploadedResourceController.RESOURCES.get(UUID.fromString(actRes.getResourceId()));
            Assertions.assertThat(files.stream().map(UploadedResourceController.FileContent::getPath)).containsExactlyInAnyOrder((Object[])IgnitionEx.allGrids().stream().map(ignite -> "/thread-dump/thread-dump-" + ignite.cluster().localNode().consistentId() + ".txt").toArray(String[]::new));
            return true;
        });
    }

    @Test
    public void shouldExportThreadDumps() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.exportDebugInfo").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DebugInfoArgument().setDebugInfoItems(Collections.singleton(DebugInfoItem.THREAD_DUMP)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            CollectLogResponse actRes = this.result(r, new TypeReference<CollectLogResponse>(){});
            Assertions.assertThat(UploadedResourceController.RESOURCES.get(UUID.fromString(actRes.getResourceId()))).extracting("path").containsExactlyInAnyOrder((Object[])IgnitionEx.allGrids().stream().map(ignite -> "/thread-dump/thread-dump-" + ignite.cluster().localNode().consistentId() + ".txt").toArray(String[]::new));
            return true;
        });
    }

    @Test
    public void shouldExportConfiguration() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.exportDebugInfo").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DebugInfoArgument().setDebugInfoItems(Collections.singleton(DebugInfoItem.IGNITE_CONFIGURATION)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            CollectLogResponse actRes = this.result(r, new TypeReference<CollectLogResponse>(){});
            Assertions.assertThat(UploadedResourceController.RESOURCES.get(UUID.fromString(actRes.getResourceId()))).extracting(new String[]{"path", "content"}).containsExactlyInAnyOrder((Object[])IgnitionEx.allGrids().stream().map(ignite -> Assertions.tuple((Object[])new Object[]{"/ignite-configuration/cfg-" + ignite.cluster().localNode().consistentId() + ".json", AgentObjectMapperFactory.jsonMapperWithSecretHiding().writerWithDefaultPrettyPrinter().writeValueAsString((Object)ignite.configuration())})).toArray(Tuple[]::new));
            return true;
        });
    }

    @Test
    public void shouldExportJVMInfo() throws JsonProcessingException {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.exportDebugInfo").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DebugInfoArgument().setDebugInfoItems(Collections.singleton(DebugInfoItem.JVM_INFO)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            CollectLogResponse actRes = this.result(r, new TypeReference<CollectLogResponse>(){});
            Assertions.assertThat(UploadedResourceController.RESOURCES.get(UUID.fromString(actRes.getResourceId()))).allMatch(f -> {
                ((AbstractStringAssert)Assertions.assertThat((String)f.getPath()).startsWith((CharSequence)"/jvm-info/jvm-info-")).endsWith((CharSequence)".json");
                ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.from((CharSequence)f.getContent()))).hasJsonPath((CharSequence)"$.OS", new Object[0]).hasJsonPath((CharSequence)"$.['VM information']", new Object[0]).hasJsonPath((CharSequence)"$.['VM arguments']", new Object[0]).hasJsonPath((CharSequence)"$.['System properties']", new Object[0]).hasJsonPath((CharSequence)"$.['Class path']", new Object[0]);
                return true;
            });
            return true;
        });
    }

    private void exportTopology(@Nullable Set<UUID> nids) throws Exception {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.exportDebugInfo").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DebugInfoArgument().setDebugInfoItems(Collections.singleton(DebugInfoItem.CLUSTER_TOPOLOGY)).setNodes(nids));
        TopologySnapshot snap = TopologyProcessor.buildClusterTopology((long)this.cluster.topologyVersion(), (Object)this.cluster.localNode().consistentId(), (Collection)this.cluster.nodes(), (Collection)this.cluster.currentBaselineTopology(), (boolean)false);
        String expected = AgentObjectMapperFactory.jsonMapperWithSecretHiding().writerWithDefaultPrettyPrinter().writeValueAsString((Object)snap);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            CollectLogResponse actRes = this.result(r, new TypeReference<CollectLogResponse>(){});
            Assertions.assertThat(UploadedResourceController.RESOURCES.get(UUID.fromString(actRes.getResourceId()))).extracting(new String[]{"path", "content"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"/topology/topology.json", expected})});
            return true;
        });
    }

    @Test
    public void shouldExportTopology() throws Exception {
        this.exportTopology(null);
        this.exportTopology(this.nonCrdNodeIds);
    }

    @Test
    public void shouldExportSingleNodeItems() throws Exception {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.exportDebugInfo").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DebugInfoArgument().setDebugInfoItems(F.asSet((Object[])new DebugInfoItem[]{DebugInfoItem.CLUSTER_TOPOLOGY, DebugInfoItem.IGNITE_CONFIGURATION})).setNodes(this.nonCrdNodeIds));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            CollectLogResponse actRes = this.result(r, new TypeReference<CollectLogResponse>(){});
            Assertions.assertThat(UploadedResourceController.RESOURCES.get(UUID.fromString(actRes.getResourceId()))).extracting("path").containsExactlyInAnyOrder((Object[])Stream.concat(Stream.of("/topology/topology.json"), this.nonCrdNodeConsistentIds.stream().map(id -> "/ignite-configuration/cfg-" + id + ".json")).toArray(String[]::new));
            return true;
        });
    }

    @Override
    protected int clusterSize() {
        return 2;
    }

    @Override
    protected void changeAgentConfiguration(IgniteEx ignite, boolean isAssertNeeded, String uri, String trustStore, String trustStorePwd, String keyStore, String keyStorePwd) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("--uri", String.join((CharSequence)",", "http://localhost:3000", uri)));
        if (!F.isEmpty((String)trustStore)) {
            args.addAll(Arrays.asList("--management-truststore", trustStore));
        }
        if (!F.isEmpty((String)trustStorePwd)) {
            args.addAll(Arrays.asList("--management-truststore-password", trustStorePwd));
        }
        if (!F.isEmpty((String)keyStore)) {
            args.addAll(Arrays.asList("--management-keystore", keyStore));
        }
        if (!F.isEmpty((String)keyStorePwd)) {
            args.addAll(Arrays.asList("--management-keystore-password", keyStorePwd));
        }
        this.management(ignite, args);
        if (isAssertNeeded) {
            TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildActionRequestTopic((UUID)ignite.context().cluster().get().id())));
        }
    }
}

