/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithAuthenticationTest;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.passcode.AuthenticationAclBasicProvider;
import org.gridgain.grid.security.passcode.AuthenticationAclProvider;
import org.gridgain.grid.security.passcode.PasscodeAuthenticator;

public abstract class AbstractActionControllerWithGridGainSecurityTest
extends AbstractActionControllerWithAuthenticationTest {
    public static final String FULL_ACCESS_CREDS = "{ defaultAllow: true }";
    protected static final String ADMIN_ACCOUNT = "admin";
    protected static final String NO_ACCESS_ACCOUNT = "no_access";
    protected static final String NODE_ACCOUNT = "server";
    protected static final String DEFAULT_USER_PASSWORD = "123456";

    protected Map<SecurityCredentials, String> prepareCustomCredentials() {
        return Collections.emptyMap();
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        IgniteConfiguration configuration = super.getConfiguration(instanceName);
        try {
            HashMap<SecurityCredentials, String> acls = new HashMap<SecurityCredentials, String>();
            acls.put(new SecurityCredentials(ADMIN_ACCOUNT, DEFAULT_USER_PASSWORD), this.getAdminPerms());
            acls.put(new SecurityCredentials(NO_ACCESS_ACCOUNT, DEFAULT_USER_PASSWORD), this.getNoAccessPerms());
            acls.put(new SecurityCredentials(NODE_ACCOUNT, DEFAULT_USER_PASSWORD), this.getServerPerms());
            acls.putAll(this.prepareCustomCredentials());
            PasscodeAuthenticator authenticator = new PasscodeAuthenticator();
            authenticator.setAclProvider((AuthenticationAclProvider)new AuthenticationAclBasicProvider(acls));
            configuration.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setAuthenticator((Authenticator)authenticator).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials(NODE_ACCOUNT, DEFAULT_USER_PASSWORD)))});
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        return configuration;
    }

    private String getAdminPerms() {
        return "{  {    cache: '*',    permissions: [      CACHE_READ,      CACHE_PUT,      CACHE_REMOVE,    ]  },  {    system: [      ADMIN_OPS,      CACHE_CREATE,      KILL_QUERY,      GET_QUERY_VIEWS,    ]  },  defaultAllow: false}";
    }

    private String getNoAccessPerms() {
        return "{ defaultAllow: false }";
    }

    private String getServerPerms() {
        return FULL_ACCESS_CREDS;
    }
}

