/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;

public abstract class AbstractActionControllerWithAuthenticationTest
extends AbstractActionControllerTest {
    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        IgniteConfiguration configuration = super.getConfiguration(instanceName);
        configuration.setAuthenticationEnabled(true);
        return configuration;
    }

    protected UUID authenticate(AuthenticateCredentials creds) {
        AtomicReference sesId = new AtomicReference();
        Request authReq = new Request().setId(UUID.randomUUID()).setAction("SecurityActions.authenticate").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)creds);
        this.executeAction((AbstractRequest)authReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED && r.getResult() != null) {
                sesId.set(UUID.fromString((String)r.getResult()));
                return true;
            }
            if (r != null && r.getStatus() == Status.FAILED) {
                sesId.set(null);
                return true;
            }
            return false;
        });
        return (UUID)sesId.get();
    }
}

