/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent;

import java.net.URI;
import java.util.UUID;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.processors.cluster.ClusterProcessor;
import org.apache.ignite.logger.NullLogger;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.configuration.ControlCenterAgentConfiguration;
import org.gridgain.control.agent.configuration.DistributedWebSocketConfiguration;
import org.gridgain.control.agent.transport.ws.StompRouter;
import org.gridgain.control.agent.transport.ws.WebSocketConnectionFactory;
import org.gridgain.control.agent.utils.AgentUtils;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class AgentPerformanceTest
extends AgentCommonAbstractTest {
    @Ignore(value="Run on demand")
    @Test
    public void testLotsOfWSConnections() throws Exception {
        URI connUri = AgentUtils.toWsUri((String)"http://localhost:3000");
        int connAmount = 300;
        DistributedWebSocketConfiguration wsCfg = (DistributedWebSocketConfiguration)Mockito.mock(DistributedWebSocketConfiguration.class);
        Mockito.when((Object)wsCfg.inboundMessageSize()).thenReturn((Object)0xA00000);
        Mockito.when((Object)wsCfg.webSocketMaxBufferSize()).thenReturn((Object)0xA00000);
        ControlCenterAgentConfiguration ccaCfg = (ControlCenterAgentConfiguration)Mockito.mock(ControlCenterAgentConfiguration.class);
        Mockito.when((Object)ccaCfg.getTrustStoreType()).thenReturn(null);
        Mockito.when((Object)ccaCfg.getTrustStore()).thenReturn(null);
        Mockito.when((Object)ccaCfg.getTrustStorePassword()).thenReturn(null);
        Mockito.when((Object)ccaCfg.getKeyStoreType()).thenReturn(null);
        Mockito.when((Object)ccaCfg.getKeyStore()).thenReturn(null);
        Mockito.when((Object)ccaCfg.getKeyStorePassword()).thenReturn(null);
        Mockito.when((Object)ccaCfg.getCipherSuites()).thenReturn(null);
        for (int i = 0; i < connAmount; ++i) {
            IgniteClusterImpl clusterImpl = (IgniteClusterImpl)Mockito.mock(IgniteClusterImpl.class);
            Mockito.when((Object)clusterImpl.id()).thenReturn((Object)UUID.randomUUID());
            ClusterProcessor clusterProc = (ClusterProcessor)Mockito.mock(ClusterProcessor.class);
            Mockito.when((Object)clusterProc.get()).thenReturn((Object)clusterImpl);
            GridKernalContext ctx = (GridKernalContext)Mockito.mock(GridKernalContext.class);
            Mockito.when((Object)ctx.log((Class)Mockito.any(Class.class))).thenReturn((Object)new NullLogger());
            Mockito.when((Object)ctx.cluster()).thenReturn((Object)clusterProc);
            WebSocketConnectionFactory wsConnFactory = new WebSocketConnectionFactory(ctx, wsCfg);
            wsConnFactory.connect(connUri, ccaCfg, UUID.randomUUID(), new StompRouter(), throwable -> System.out.println(throwable.getMessage()));
            System.out.println("Connections: " + (i + 1));
        }
        Thread.sleep(60000L);
    }
}

