/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security.rolebased;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.gridgain.control.agent.AbstractSelfTest;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.database.utility.SnapshotUtility;
import org.gridgain.database.utility.commands.Command;
import org.gridgain.database.utility.commands.Commands;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.rolebased.RoleBasedAuthenticator;
import org.gridgain.grid.security.rolebased.UserCredential;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SnapshotUtilityRoledBasedAuthenticationTest
extends AbstractSelfTest {
    private static final String USERNAME = "user";
    private static final String PASSWORD = "user";
    private static final String USERNAME2 = "user2";
    private static final String PASSWORD2 = "user2";
    private static final String USERNAME3 = "user3";
    private static final String PASSWORD3 = "user3";
    private static final String ADMIN_USERNAME = "admin";
    private static final String ADMIN_PASSWORD = "admin";
    private static final String STATIC_USER = "default";
    private static final String STATIC_ROLE = "default";
    private static final String STATIC_PASSWORD = "default";
    private static final String USER_ROLE = "users";
    private static final String USER2_ROLE = "users2";
    private static final String USER3_ROLE = "users3";
    private static final String ADMIN_ROLE = "admins";

    @Before
    public void setup() throws IgniteCheckedException {
        this.cleanPersistenceDir();
        this.deleteDirectory("snapshot");
        this.stopAllGrids();
        IgniteEx ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
        this.createRolesAndUsers(ignite);
    }

    @After
    public void teardown() {
        ListeningTestAppender.close();
        this.stopAllGrids();
    }

    public void createRolesAndUsers(IgniteEx ignite) {
        TestUtils.createRole(ignite, ADMIN_ROLE, "{defaultAllow:true}");
        TestUtils.createRole(ignite, USER_ROLE, "{defaultAllow:false,{system:[ADMIN_CACHE, ADMIN_OPS, ADMIN_VIEW]},{task:'*',permissions:[TASK_EXECUTE]},{cache:'*',permissions:[CACHE_READ, CACHE_PUT, CACHE_REMOVE]}}");
        TestUtils.createRole(ignite, USER2_ROLE, "{defaultAllow:false,{system:[ADMIN_OPS]}}");
        TestUtils.createRole(ignite, USER3_ROLE, "{defaultAllow:false,{system:[]}}");
        TestUtils.createUser(ignite, "admin", "admin", ADMIN_ROLE);
        TestUtils.createUser(ignite, "user", "user", USER_ROLE);
        TestUtils.createUser(ignite, "user2", "user2", USER2_ROLE);
        TestUtils.createUser(ignite, "user3", "user3", USER3_ROLE);
    }

    @Test
    public void testWithoutAuthentication() {
        System.setIn(new InputStream(){
            private int i = 0;

            @Override
            public int read() {
                int c = this.i < "user".length() + 2 ? SnapshotUtilityRoledBasedAuthenticationTest.charAt("user", this.i) : (this.i < "user".length() + 5 ? SnapshotUtilityRoledBasedAuthenticationTest.charAt("1", this.i - "user".length() - 2) : (this.i < "user".length() + 8 ? SnapshotUtilityRoledBasedAuthenticationTest.charAt("2", this.i - "user".length() - 5) : SnapshotUtilityRoledBasedAuthenticationTest.charAt("3", this.i - "user".length() - 8)));
                ++this.i;
                return c;
            }
        });
        Command cmd = Commands.LIST.command();
        Assert.assertEquals((long)cmd.errorCode(220), (long)cmd.execute(new String[]{"list"}));
        Assert.assertEquals((long)0L, (long)cmd.execute(new String[]{"list", "-USER=user", "-PASSWORD=user"}));
        Assert.assertEquals((long)cmd.errorCode(220), (long)cmd.execute(new String[]{"list", "-USER=user", "-PASSWORD=wrong"}));
    }

    @Test
    public void testReadPasswordOfConsole() {
        System.setIn(new InputStream(){
            private int i = 0;

            @Override
            public int read() {
                int c = SnapshotUtilityRoledBasedAuthenticationTest.charAt("user", this.i);
                ++this.i;
                return c;
            }
        });
        Command cmd = Commands.LIST.command();
        Assert.assertEquals((long)cmd.errorCode(220), (long)cmd.execute(new String[]{"list", "-USER=user"}));
    }

    @Test
    public void testReadUserAndPasswordOfConsole() {
        System.setIn(new InputStream(){
            private int i = 0;

            @Override
            public int read() {
                int c = this.i < "user".length() + 2 ? SnapshotUtilityRoledBasedAuthenticationTest.charAt("user", this.i) : SnapshotUtilityRoledBasedAuthenticationTest.charAt("user", this.i - "user".length() - 2);
                ++this.i;
                return c;
            }
        });
        Command cmd = Commands.LIST.command();
        Assert.assertEquals((long)cmd.errorCode(220), (long)cmd.execute(new String[]{"list"}));
    }

    @Test
    public void testCheckCmdWithAdminOpsOnly() {
        this.execCheckCmdForCheckAdminOps(0, "user2", "user2");
    }

    @Test
    public void testCheckCmdWithoutAdminOps() {
        this.execCheckCmdForCheckAdminOps(5, "user3", "user3");
    }

    @Test
    public void testExecutePitrEnabledTaskWithoutPermissionIssues() {
        AtomicInteger resContains = new AtomicInteger();
        ListeningTestAppender testApp = ListeningTestAppender.create();
        testApp.registerListener(s -> {
            if (s.contains("Result of checking snapshot schedule for PITR:")) {
                resContains.incrementAndGet();
            }
        });
        Assert.assertEquals((long)0L, (long)this.exec("user", "user", Commands.SNAPSHOT, "-type=full"));
        Assert.assertEquals((long)1L, (long)resContains.get());
    }

    @Test
    public void testInfoCmdWithoutAdminView() {
        Assert.assertEquals((long)5L, (long)this.exec("user3", "user3", Commands.LIST, new String[0]));
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return super.getConfiguration(instanceName).setCacheConfiguration(new CacheConfiguration[]{TestUtils.nebulaUserCacheConfiguration(), TestUtils.nebulaRoleCacheConfiguration()}).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setAuthenticator((Authenticator)new RoleBasedAuthenticator().setStaticRoles(F.asMap((Object)"default", (Object)"{defaultAllow:true}")).setStaticUsers(F.asMap((Object)"default", (Object)new UserCredential("default", "default")))).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("default", "default"))).setSnapshotConfiguration(new SnapshotConfiguration())});
    }

    private static int charAt(String s, int idx) {
        int c = idx < s.length() ? s.charAt(idx) : (idx == s.length() ? 10 : -1);
        return c;
    }

    private void execCheckCmdForCheckAdminOps(int expStatusCode, String user, String pwd) {
        IgniteEx crd = this.startGrids(1);
        SnapshotFuture<Void> fullSnapFut = TestUtils.createFullSnapshot(crd.cluster().ignite(), null, null);
        fullSnapFut.get(20L, TimeUnit.SECONDS);
        SnapshotFuture<Void> incSnapFut = TestUtils.createSnapshot(crd.cluster().ignite(), null, null);
        incSnapFut.get(20L, TimeUnit.SECONDS);
        List<SnapshotOperationInfo> infos = Arrays.asList(fullSnapFut.snapshotOperation(), incSnapFut.snapshotOperation());
        ConnectorConfiguration connCfg0 = crd.configuration().getConnectorConfiguration();
        for (SnapshotOperationInfo snapInfo : infos) {
            Assert.assertEquals((long)expStatusCode, (long)this.exec(user, pwd, Commands.CHECK, this.port(connCfg0), this.id(snapInfo)));
        }
    }

    protected String id(SnapshotOperationInfo snapshotOperationInfo) {
        Objects.requireNonNull(snapshotOperationInfo);
        return "-id=" + snapshotOperationInfo.snapshotId();
    }

    private String port(ConnectorConfiguration connCfg) {
        Assert.assertNotNull((Object)connCfg);
        return "-PORT=" + connCfg.getPort();
    }

    protected int exec(String user, String pwd, Commands cmd, String ... args) {
        Assert.assertNotNull((Object)cmd);
        ArrayList<String> arguments = new ArrayList<String>(Collections.singletonList(cmd.name()));
        if (Objects.nonNull(args)) {
            arguments.addAll(Arrays.asList(args));
        }
        arguments.add("-USER=" + user);
        arguments.add("-PASSWORD=" + pwd);
        return new SnapshotUtility().execute(arguments.toArray(new String[0]));
    }

    public static class ListeningTestAppender
    extends AbstractAppender {
        public static final String NAME = "LISTENING_TEST_APPENDER";
        private final Collection<Consumer<String>> lsnrs = new CopyOnWriteArraySet<Consumer<String>>();

        private ListeningTestAppender() {
            super(NAME, null, null);
        }

        public void registerListener(Consumer<String> lsnr) {
            this.lsnrs.add(lsnr);
        }

        public void unregisterListener(Consumer<String> lsnr) {
            this.lsnrs.remove(lsnr);
        }

        public void clearListeners() {
            this.lsnrs.clear();
        }

        public void append(LogEvent evt) {
            this.applyListeners(evt.getMessage() != null ? evt.getMessage().getFormattedMessage() : null);
            Throwable t = evt.getThrown();
            if (t != null) {
                this.applyListeners(X.getFullStackTrace((Throwable)t));
            }
        }

        private void applyListeners(String msg) {
            if (msg == null) {
                return;
            }
            for (Consumer<String> lsnr : this.lsnrs) {
                lsnr.accept(msg);
            }
        }

        public static ListeningTestAppender create() {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration cfg = ctx.getConfiguration();
            ListeningTestAppender tApp = new ListeningTestAppender();
            tApp.start();
            cfg.addAppender((Appender)tApp);
            cfg.getRootLogger().addAppender((Appender)tApp, Level.TRACE, null);
            ctx.updateLoggers(cfg);
            return tApp;
        }

        public static void close() {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            ((AbstractConfiguration)ctx.getConfiguration()).removeAppender(NAME);
        }
    }
}

