/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.assertj.core.api.Assertions;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.action.query.CursorHolder;
import org.gridgain.control.agent.dto.query.LoadStatus;
import org.gridgain.control.agent.dto.query.LoadStatusKey;
import org.gridgain.control.agent.dto.query.Region;
import org.gridgain.control.agent.dto.query.TargetCacheStatusEntry;
import org.gridgain.control.agent.utils.AgentObjectMapperFactory;
import org.gridgain.control.agent.utils.QueryUtils;
import org.junit.Test;

public class QueryUtilsTest
extends AgentCommonAbstractTest {
    private static ObjectMapper mapper = AgentObjectMapperFactory.jsonMapper();

    @Test
    public void shouldSerializeScanQueryToJson() throws Exception {
        try (IgniteEx ignite = this.startGrid();){
            ignite.cluster().state(ClusterState.ACTIVE);
            IgniteCache cache = this.createCache((Ignite)ignite, "TestCache");
            IgniteCache binaryCache = cache.withKeepBinary();
            LocalDate ld = LocalDate.of(2022, 1, 1);
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            TargetCacheStatusEntry status = new TargetCacheStatusEntry().setId(UUID.randomUUID()).setRequestId("id").setRegion(Region.R1).setTotalMessagesPublished(10L);
            binaryCache.put((Object)new LoadStatusKey().setTargetCache("TestCache").setAsOfDate(ld), (Object)new LoadStatus().setLastUpdateTime(ts).setEntriesByTaskName(QueryUtilsTest.map("key", status)).setStatuses(Collections.singletonList(status)));
            CursorHolder cursorHolder = new CursorHolder(binaryCache.query((Query)new ScanQuery()), true);
            Assertions.assertThat((List)QueryUtils.fetchScanQueryResult((Iterator)cursorHolder, (int)100).getRows()).containsExactlyInAnyOrder((Object[])new Object[][]{{"o.a.i.i.binary.BinaryObjectImpl", "{\"asOfDt\":\"2022-01-01\",\"targetCache\":\"TestCache\"}", "o.a.i.i.binary.BinaryObjectImpl", "{\"entriesByTaskName\":{\"key\":{\"id\":\"" + status.getId() + "\",\"region\":\"R1\",\"totalMessagesPublished\":10,\"reqId\":\"id\"}},\"statuses\":[{\"id\":\"" + status.getId() + "\",\"region\":\"R1\",\"totalMessagesPublished\":10,\"reqId\":\"id\"}],\"lastUpdateTime\":" + mapper.writeValueAsString((Object)ts) + "}"}});
            cache.clear();
            cache.put((Object)new LoadStatusKey().setTargetCache("TestCache").setAsOfDate(ld), (Object)new LoadStatus().setLastUpdateTime(ts).setEntriesByTaskName(QueryUtilsTest.map("key", status)).setStatuses(Collections.singletonList(status)));
            cursorHolder = new CursorHolder(cache.query((Query)new ScanQuery()), true);
            Assertions.assertThat((List)QueryUtils.fetchScanQueryResult((Iterator)cursorHolder, (int)100).getRows()).containsExactlyInAnyOrder((Object[])new Object[][]{{LoadStatusKey.class.getName(), "{\"targetCache\":\"TestCache\",\"asOfDate\":\"2022-01-01\"}", LoadStatus.class.getName(), "{\"entriesByTaskName\":{\"key\":{\"id\":\"" + status.getId() + "\",\"region\":\"R1\",\"totalMessagesPublished\":10,\"requestId\":\"id\"}},\"lastUpdateTime\":" + mapper.writeValueAsString((Object)ts) + "}"}});
        }
    }

    @Test
    public void shouldSerializeSqlFieldsQueryToJson() throws Exception {
        try (IgniteEx ignite = this.startGrid();){
            ignite.cluster().state(ClusterState.ACTIVE);
            IgniteCache cache = this.createCache((Ignite)ignite, "TestCache");
            IgniteCache binaryCache = cache.withKeepBinary();
            LocalDate ld = LocalDate.of(2022, 1, 1);
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            TargetCacheStatusEntry status = new TargetCacheStatusEntry().setId(UUID.randomUUID()).setRequestId("id").setRegion(Region.R1).setTotalMessagesPublished(10L);
            cache.put((Object)new LoadStatusKey().setTargetCache("TestCache").setAsOfDate(ld), (Object)new LoadStatus().setLastUpdateTime(ts).setEntriesByTaskName(QueryUtilsTest.map("key", status)).setStatuses(QueryUtilsTest.map("key", status).values()));
            CursorHolder cursorHolder = new CursorHolder((QueryCursor)binaryCache.query(new SqlFieldsQuery("SELECT * FROM LOADSTATUS")), false);
            Assertions.assertThat((List)QueryUtils.fetchSqlQueryResult((CursorHolder)cursorHolder, (int)100).getRows()).containsExactlyInAnyOrder((Object[])new Object[][]{{"TestCache", U.unquote((String)mapper.writeValueAsString((Object)ld)), "{\"key\":{\"id\":\"" + status.getId() + "\",\"region\":\"R1\",\"totalMessagesPublished\":10,\"reqId\":\"id\"}}", "{\"this$0\":\"<Failed to deserialize field>\"}", U.unquote((String)mapper.writeValueAsString((Object)ts))}});
            cache.put((Object)new LoadStatusKey().setTargetCache("TestCache").setAsOfDate(ld), (Object)new LoadStatus().setLastUpdateTime(ts).setEntriesByTaskName(QueryUtilsTest.map("key", status)).setStatuses(Collections.singletonList(status)));
            cursorHolder = new CursorHolder((QueryCursor)binaryCache.query(new SqlFieldsQuery("SELECT * FROM LOADSTATUS")), false);
            Assertions.assertThat((List)QueryUtils.fetchSqlQueryResult((CursorHolder)cursorHolder, (int)100).getRows()).containsExactlyInAnyOrder((Object[])new Object[][]{{"TestCache", U.unquote((String)mapper.writeValueAsString((Object)ld)), "{\"key\":{\"id\":\"" + status.getId() + "\",\"region\":\"R1\",\"totalMessagesPublished\":10,\"reqId\":\"id\"}}", "[{\"id\":\"" + status.getId() + "\",\"region\":\"R1\",\"totalMessagesPublished\":10,\"reqId\":\"id\"}]", U.unquote((String)mapper.writeValueAsString((Object)ts))}});
        }
    }

    @Override
    protected <K, V> CacheConfiguration<K, V> cacheConfiguration(String cacheName) {
        return super.cacheConfiguration(cacheName).setSqlSchema("PUBLIC").setIndexedTypes(new Class[]{LoadStatusKey.class, LoadStatus.class});
    }

    private static <K, V> Map<K, V> map(K k, V v) {
        HashMap<K, V> map = new HashMap<K, V>(U.newHashMap((int)1));
        map.put(k, v);
        return map;
    }
}

