/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.utils;

import java.time.temporal.ValueRange;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class LogListener
implements Consumer<String> {
    private String name;

    public abstract boolean check();

    public boolean check(long millis) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (startTime + millis >= System.currentTimeMillis()) {
            if (this.check()) {
                return true;
            }
            Thread.sleep(100L);
        }
        return this.check();
    }

    private LogListener setName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        return this.name;
    }

    public abstract void reset();

    public static Builder builder() {
        return new Builder();
    }

    public static Builder matches(String substr) {
        return new Builder().andMatches(substr);
    }

    public static Builder matches(Pattern regexp) {
        return new Builder().andMatches(regexp);
    }

    public static Builder matches(Predicate<String> pred) {
        return new Builder().andMatches(pred);
    }

    private static class CompositeMessageListener
    extends LogListener {
        private final List<LogMessageListener> lsnrs = new ArrayList<LogMessageListener>();

        private CompositeMessageListener() {
        }

        @Override
        public boolean check() {
            for (LogMessageListener lsnr : this.lsnrs) {
                if (lsnr.check()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void reset() {
            for (LogMessageListener lsnr : this.lsnrs) {
                lsnr.reset();
            }
        }

        @Override
        public void accept(String msg) {
            for (LogMessageListener lsnr : this.lsnrs) {
                lsnr.accept(msg);
            }
        }

        private void add(LogMessageListener lsnr) {
            this.lsnrs.add(lsnr);
        }
    }

    private static class LogMessageListener
    extends LogListener {
        private final Function<String, Integer> func;
        private final AtomicReference<Throwable> err = new AtomicReference();
        private final AtomicInteger matches = new AtomicInteger();
        private final ValueRange exp;

        private LogMessageListener(@NotNull Function<String, Integer> func, @NotNull ValueRange exp) {
            this.func = func;
            this.exp = exp;
        }

        @Override
        public void accept(String msg) {
            block4: {
                if (this.err.get() != null) {
                    return;
                }
                try {
                    int cnt = this.func.apply(msg);
                    if (cnt > 0) {
                        this.matches.addAndGet(cnt);
                    }
                }
                catch (Throwable t) {
                    this.err.compareAndSet(null, t);
                    if (!(t instanceof VirtualMachineError)) break block4;
                    throw t;
                }
            }
        }

        @Override
        public boolean check() {
            this.errCheck();
            int matchesCnt = this.matches.get();
            return this.exp.isValidIntValue(matchesCnt);
        }

        @Override
        public void reset() {
            this.matches.set(0);
        }

        private void errCheck() {
            Throwable t = this.err.get();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            assert (t == null) : t;
        }
    }

    public static class Builder {
        private final CompositeMessageListener lsnr = new CompositeMessageListener();
        private Node prev;

        public Builder andMatches(String substr) {
            this.addLast(new Node(msg -> {
                if (substr.isEmpty()) {
                    return msg.isEmpty() ? 1 : 0;
                }
                int cnt = 0;
                int idx = 0;
                while ((idx = msg.indexOf(substr, idx)) != -1) {
                    ++cnt;
                    ++idx;
                }
                return cnt;
            }));
            return this;
        }

        public Builder andMatches(Pattern regexp) {
            this.addLast(new Node(msg -> {
                int cnt = 0;
                Matcher matcher = regexp.matcher((CharSequence)msg);
                while (matcher.find()) {
                    ++cnt;
                }
                return cnt;
            }));
            return this;
        }

        public Builder andMatches(Predicate<String> pred) {
            this.addLast(new Node(msg -> pred.test((String)msg) ? 1 : 0));
            return this;
        }

        public Builder times(int n) {
            if (this.prev != null) {
                this.prev.cnt = n;
            }
            return this;
        }

        public Builder atLeast(int n) {
            if (this.prev != null) {
                this.prev.min = n;
                this.prev.cnt = null;
            }
            return this;
        }

        public Builder atMost(int n) {
            if (this.prev != null) {
                this.prev.max = n;
                this.prev.cnt = null;
            }
            return this;
        }

        public LogListener build() {
            return this.build(null);
        }

        public LogListener build(String lsnrName) {
            this.addLast(null);
            CompositeMessageListener lsnr = this.lsnr.lsnrs.size() == 1 ? (LogListener)this.lsnr.lsnrs.get(0) : this.lsnr;
            return ((LogListener)lsnr).setName(lsnrName);
        }

        private void addLast(Node node) {
            if (this.prev != null) {
                this.lsnr.add(this.prev.listener());
            }
            this.prev = node;
        }

        private Builder() {
        }

        static final class Node {
            final Function<String, Integer> func;
            Integer min;
            Integer max;
            Integer cnt;

            Node(Function<String, Integer> func) {
                this.func = func;
            }

            LogMessageListener listener() {
                ValueRange range = this.cnt != null ? ValueRange.of(this.cnt.intValue(), this.cnt.intValue()) : (this.min == null && this.max == null ? ValueRange.of(1L, Integer.MAX_VALUE) : ValueRange.of(this.min == null ? 0L : (long)this.min.intValue(), this.max == null ? Integer.MAX_VALUE : (long)this.max.intValue()));
                return new LogMessageListener(this.func, range);
            }
        }
    }
}

