/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.dr.RemoteConnection;
import org.gridgain.control.agent.dto.dr.SenderNodeRemoteConnections;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.memory.DrSenderInMemoryStore;
import org.gridgain.grid.internal.GridPluginUtils;
import org.junit.Assert;
import org.junit.Test;

public class DrSenderConnectionsExporterTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldDrNodeConnectionsOnStartUp() {
        IgniteConfiguration node1Cfg = this.getConfiguration("default");
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)node1Cfg).setDataCenterId((byte)15);
        IgniteEx ignite = this.startGrid(node1Cfg);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        DrSenderConfiguration sndCfg = new DrSenderConfiguration().setConnectionConfiguration(new DrSenderConnectionConfiguration[]{new DrSenderConnectionConfiguration().setDataCenterId((byte)5).setReceiverAddresses(new String[]{"127.0.0.1", "127.0.0.2"}).setStore((DrSenderStore)new DrSenderInMemoryStore()), new DrSenderConnectionConfiguration().setDataCenterId((byte)7).setReceiverAddresses(new String[]{"127.0.0.3"}).setStore((DrSenderStore)new DrSenderInMemoryStore())});
        IgniteConfiguration node2Cfg = this.getConfiguration(this.instanceName(0));
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)node2Cfg).setDataCenterId((byte)15).setDrSenderConfiguration(sndCfg);
        IgniteEx ignite2 = this.startGrid(node2Cfg);
        TestUtils.assertWithPoll(() -> {
            String dest = StompDestinationsUtils.buildDrSenderConnectionsDest((UUID)cluster.id());
            List<SenderNodeRemoteConnections> payload = this.inInterceptor.getListPayload(dest, SenderNodeRemoteConnections.class);
            Assert.assertEquals((long)1L, (long)payload.size());
            SenderNodeRemoteConnections sndNodeRemoteCons = (SenderNodeRemoteConnections)payload.stream().findFirst().get();
            Assert.assertNotNull(payload);
            Assert.assertEquals((Object)ignite2.localNode().consistentId().toString(), (Object)sndNodeRemoteCons.getSenderHubNodeId());
            List connections = sndNodeRemoteCons.getConnections();
            Assert.assertEquals((long)2L, (long)connections.size());
            Assert.assertFalse((boolean)((RemoteConnection)connections.get(0)).getConnected());
            Assert.assertFalse((boolean)((RemoteConnection)connections.get(1)).getConnected());
            Assert.assertEquals((long)5L, (long)((RemoteConnection)connections.get(0)).getRemoteDcId());
            Assert.assertEquals((long)7L, (long)((RemoteConnection)connections.get(1)).getRemoteDcId());
            Assert.assertEquals((Object)"127.0.0.1", ((RemoteConnection)connections.get(0)).getReceiverAddress().get(0));
            Assert.assertEquals((Object)"127.0.0.2", ((RemoteConnection)connections.get(0)).getReceiverAddress().get(1));
            Assert.assertEquals((Object)"127.0.0.3", ((RemoteConnection)connections.get(1)).getReceiverAddress().get(0));
        });
    }
}

