/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.PluginConfiguration;
import org.awaitility.core.ConditionTimeoutException;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.snapshot.GridGainSnapshotInfo;
import org.gridgain.control.agent.dto.snapshot.GridGainSnapshotScheduleInfo;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.SnapshotsUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotScheduleInfoProcessorTest
extends AgentCommonAbstractTest {
    private boolean snapshotsEnabled;

    @Override
    public void cleanup() {
        super.cleanup();
        this.deleteDirectory("snapshot");
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        IgniteConfiguration cfg = super.getConfiguration(instanceName);
        if (this.snapshotsEnabled) {
            cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
        }
        return cfg;
    }

    @Test
    public void shouldNotSendSnapshotScheduleOnConnect() {
        IgniteEx ignite = this.startGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        TestUtils.assertThrows(() -> TestUtils.assertWithPoll(() -> !F.isEmpty(this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)cluster.id()), GridGainSnapshotInfo.class))), ConditionTimeoutException.class);
    }

    @Test
    public void shouldSendSnapshotScheduleListOnConnect() {
        this.snapshotsEnabled = true;
        IgniteEx ignite = this.startGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        this.createCache((Ignite)ignite, "cache1");
        this.createCache((Ignite)ignite, "cache2");
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        SnapshotScheduleProcessor snap = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        snap.start(new SnapshotScheduleV2("1", "test-schedule", SnapshotOperationType.CREATE, "* * * * *", "0 * * * *", Collections.singleton("cache1"), 1L, "/destination", true, null, new SnapshotCreateParameters(CompressionOption.SNAPPY, 2), null, -1, -1, null, 0));
        snap.start(new SnapshotScheduleV2("2", "test-schedule-delete", SnapshotOperationType.DELETE, null, null, Collections.singleton("cache2"), -1L, "/destination/delete", true, null, null, null, 1, -1, "test-schedule", 2));
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 2) {
                return false;
            }
            GridGainSnapshotScheduleInfo info1 = scheduleInfos.get(0);
            Assert.assertEquals((Object)"1", (Object)info1.getId());
            Assert.assertEquals((Object)"test-schedule", (Object)info1.getName());
            Assert.assertTrue((boolean)info1.isEnabled());
            Assert.assertEquals((Object)"CREATE", (Object)info1.getType());
            Assert.assertEquals(Collections.singleton("cache1"), (Object)info1.getCacheNames());
            Assert.assertEquals((Object)"* * * * *", (Object)info1.getFrequency());
            Assert.assertEquals((Object)"0 * * * *", (Object)info1.getIncrementalFrequency());
            Assert.assertNull((Object)info1.getExecAfter());
            Assert.assertEquals((long)1L, (long)info1.getTtl());
            Assert.assertNull((Object)info1.getForLatest());
            Assert.assertNull((Object)info1.getForOldest());
            Assert.assertEquals((long)0L, (long)info1.getKeepCount().intValue());
            Assert.assertEquals((Object)"/destination", (Object)info1.getDestination());
            Assert.assertEquals((Object)"SNAPPY", (Object)info1.getCompressionOption());
            Assert.assertEquals((long)2L, (long)info1.getCompressionLevel().intValue());
            GridGainSnapshotScheduleInfo info2 = scheduleInfos.get(1);
            Assert.assertEquals((Object)"2", (Object)info2.getId());
            Assert.assertEquals((Object)"test-schedule-delete", (Object)info2.getName());
            Assert.assertTrue((boolean)info2.isEnabled());
            Assert.assertEquals((Object)"DELETE", (Object)info2.getType());
            Assert.assertEquals(Collections.singleton("cache2"), (Object)info2.getCacheNames());
            Assert.assertNull((Object)info2.getFrequency());
            Assert.assertNull((Object)info2.getIncrementalFrequency());
            Assert.assertEquals((Object)"test-schedule", (Object)info2.getExecAfter());
            Assert.assertNull((Object)info2.getTtl());
            Assert.assertNull((Object)info2.getForLatest());
            Assert.assertEquals((long)1L, (long)info2.getForOldest().intValue());
            Assert.assertEquals((long)2L, (long)info2.getKeepCount().intValue());
            Assert.assertEquals((Object)"/destination/delete", (Object)info2.getDestination());
            Assert.assertEquals((Object)"NONE", (Object)info2.getCompressionOption());
            Assert.assertNull((Object)info2.getCompressionLevel());
            return true;
        });
    }
}

