/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.dto.metric;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.gridgain.control.agent.dto.metric.VarIntReader;
import org.gridgain.control.agent.dto.metric.VarIntWriter;
import org.junit.Assert;
import org.junit.Test;

public class VarIntTest {
    private static final int INITIAL_CAP = 16;
    private static final ThreadLocalRandom RND = ThreadLocalRandom.current();

    @Test
    public void testPutBoolean() {
        this.testPutVarIntWriter(1, writer -> writer.putBoolean(RND.nextBoolean()));
    }

    @Test
    public void testPutDouble() {
        this.testPutVarIntWriter(8, writer -> writer.putDouble(RND.nextDouble()));
    }

    @Test
    public void testPutVarInt() {
        int maxBytes = 5;
        for (int i = 0; i < maxBytes; ++i) {
            int lo = i == 0 ? 0 : 1 << 7 * i;
            int hi = i == maxBytes - 1 ? Integer.MAX_VALUE : 1 << 7 * (i + 1);
            this.testPutVarIntWriter(i + 1, writer -> writer.putVarInt(RND.nextInt(lo, hi)));
        }
    }

    @Test
    public void testPutVarLong() {
        int maxBytes = 10;
        for (int i = 0; i < maxBytes; ++i) {
            long lo = i == 0 ? 0L : 1L << 7 * i;
            long hi = 1L << 7 * (i + 1);
            if (hi < 0L) {
                hi = Long.MAX_VALUE;
            }
            long hi0 = hi;
            this.testPutVarIntWriter(i + 1, writer -> writer.putVarLong(RND.nextLong(lo, hi0)));
        }
    }

    @Test
    public void testVarIntReadWriteRandomValues() {
        int valCnt = 1000;
        ArrayList<Comparable<Boolean>> vals = new ArrayList<Comparable<Boolean>>(valCnt);
        VarIntWriter writer = new VarIntWriter(16);
        block6: for (int i = 0; i < valCnt; ++i) {
            int type = RND.nextInt(4);
            switch (type) {
                case 0: {
                    boolean booleanVal = RND.nextBoolean();
                    vals.add(Boolean.valueOf(booleanVal));
                    writer.putBoolean(booleanVal);
                    continue block6;
                }
                case 1: {
                    double doubleVal = RND.nextDouble();
                    vals.add(Double.valueOf(doubleVal));
                    writer.putDouble(doubleVal);
                    continue block6;
                }
                case 2: {
                    int intVal = RND.nextInt();
                    vals.add(Integer.valueOf(intVal));
                    writer.putVarInt(intVal);
                    continue block6;
                }
                case 3: {
                    long longVal = RND.nextLong();
                    vals.add(Long.valueOf(longVal));
                    writer.putVarLong(longVal);
                    continue block6;
                }
            }
        }
        byte[] arr = new byte[writer.position()];
        writer.toBytes(arr, 0);
        VarIntReader reader = new VarIntReader(arr);
        for (int i = 0; i < valCnt; ++i) {
            Object o = vals.get(i);
            if (o instanceof Boolean) {
                Assert.assertEquals(o, (Object)reader.getBoolean());
                continue;
            }
            if (o instanceof Double) {
                Assert.assertEquals(o, (Object)reader.getDouble());
                continue;
            }
            if (o instanceof Integer) {
                Assert.assertEquals(o, (Object)reader.getVarInt());
                continue;
            }
            if (o instanceof Long) {
                Assert.assertEquals(o, (Object)reader.getVarLong());
                continue;
            }
            Assert.fail();
        }
    }

    private void testPutVarIntWriter(int expSize, Consumer<VarIntWriter> consumer) {
        VarIntWriter writer = new VarIntWriter(16);
        Assert.assertEquals((long)0L, (long)writer.position());
        for (int i = 0; i < 16 / expSize + 1; ++i) {
            consumer.accept(writer);
            Assert.assertEquals((long)((i + 1) * expSize), (long)writer.position());
        }
        Assert.assertEquals((long)((16 / expSize + 1) * expSize), (long)writer.position());
    }
}

