/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.configuration;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.configuration.DistributedSpanExporterConfiguration;
import org.gridgain.control.agent.configuration.DistributedWebSocketConfiguration;
import org.gridgain.control.agent.utils.RegistryNoopDependencyResolver;
import org.junit.Test;

public class DistributedAgentConfigurationTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldPropagateNewValue() throws IgniteCheckedException {
        IgniteEx ignite1 = this.startGrid(0);
        RegistryNoopDependencyResolver di = new RegistryNoopDependencyResolver();
        this.startGrid(1, di);
        DistributedWebSocketConfiguration wsCfg = di.getDependency(DistributedWebSocketConfiguration.class);
        DistributedSpanExporterConfiguration spanExporterCfg = di.getDependency(DistributedSpanExporterConfiguration.class);
        AssertionsForInterfaceTypes.assertThat((int)wsCfg.webSocketMaxBufferSize()).isEqualTo(0xA00000);
        AssertionsForInterfaceTypes.assertThat((int)spanExporterCfg.spanBatchSize()).isEqualTo(2000);
        AssertionsForInterfaceTypes.assertThat((int)wsCfg.webSocketHandshakeTimeout()).isEqualTo(30000);
        this.setDistributedProperty(ignite1, "spanBatchSize", "1234");
        this.setDistributedProperty(ignite1, "wsMaxBufferSize", "3432");
        this.setDistributedProperty(ignite1, "wsHandshakeTimeout", "10");
        AssertionsForInterfaceTypes.assertThat((int)wsCfg.webSocketMaxBufferSize()).isEqualTo(3432);
        AssertionsForInterfaceTypes.assertThat((int)spanExporterCfg.spanBatchSize()).isEqualTo(1234);
        AssertionsForInterfaceTypes.assertThat((int)wsCfg.webSocketHandshakeTimeout()).isEqualTo(10);
    }
}

