/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.commandline;

import java.util.Arrays;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ManagementCommandsInvalidTest
extends AgentCommonAbstractTest {
    @BeforeClass
    public static void init() {
        ManagementCommandsInvalidTest.hideNodeFeatures();
    }

    @AfterClass
    public static void tearDown() {
        ManagementCommandsInvalidTest.restoreNodeFeatures();
    }

    protected static void hideNodeFeatures() {
        System.setProperty("IGNITE_DISTRIBUTED_META_STORAGE_FEATURE", "false");
        System.setProperty("IGNITE_CLUSTER_ID_AND_TAG_FEATURE", "false");
        System.setProperty("IGNITE_BASELINE_AUTO_ADJUST_FEATURE", "false");
    }

    protected static void restoreNodeFeatures() {
        System.clearProperty("IGNITE_DISTRIBUTED_META_STORAGE_FEATURE");
        System.clearProperty("IGNITE_CLUSTER_ID_AND_TAG_FEATURE");
        System.clearProperty("IGNITE_BASELINE_AUTO_ADJUST_FEATURE");
    }

    private void testCommandFailureInIncompatibleGrid(String ... args) {
        this.startGrid();
        this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(Arrays.asList(args));
            Assert.assertEquals((long)4L, (long)res);
            Assert.assertTrue((boolean)hnd.containsAt(9, "Control Center agent requires DISTRIBUTED_METASTORAGE and CLUSTER_ID_AND_TAG features for work"));
        });
    }

    @Test
    public void shouldThrowErrorOnStatusCommand() {
        this.testCommandFailureInIncompatibleGrid("--status");
    }

    @Test
    public void shouldThrowErrorOnOnCommand() {
        this.testCommandFailureInIncompatibleGrid("--on");
    }

    @Test
    public void shouldThrowErrorOnOffCommand() {
        this.testCommandFailureInIncompatibleGrid("--off");
    }

    @Test
    public void shouldThrowErrorOnUriCommand() {
        this.testCommandFailureInIncompatibleGrid("--uri", "http://localhost");
    }

    @Test
    public void shouldThrowErrorOnTokenCommand() {
        this.testCommandFailureInIncompatibleGrid("--token");
    }

    @Test
    public void shouldStartAgentWhenGridBecomeCompatible() {
        this.startGrid(0);
        try {
            ManagementCommandsInvalidTest.restoreNodeFeatures();
            IgniteEx ignite = this.startGrid(1);
            this.stopGrid(0);
            this.changeAgentConfiguration(ignite);
            this.checkThreads(false);
            this.createCmdHandler().forEach((cmd, hnd) -> {
                int res = cmd.execute(Arrays.asList("--port", "11212", "--status"));
                Assert.assertEquals((long)0L, (long)res);
                Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--status] started"));
                Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --port 11212 --status "));
                Assert.assertTrue((boolean)hnd.startsWithAt(8, "Management: enabled"));
            });
        }
        finally {
            ManagementCommandsInvalidTest.hideNodeFeatures();
            this.stopGrid(1);
        }
    }
}

