/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.action.controller.UploadedLogController;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.ChangeClusterTagArgument;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.log.CollectLogResponse;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.web.multipart.MultipartFile;

public class ClusterActionsControllerTest
extends AbstractActionControllerTest {
    @Test
    public void activateCluster() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.activate").setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && this.cluster.state() == ClusterState.ACTIVE;
        });
    }

    @Test
    public void deactivateCluster() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.deactivate").setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && this.cluster.state() == ClusterState.INACTIVE;
        });
    }

    @Test
    public void changeTag() {
        String newTag = "Test cluster";
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.changeTag").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new ChangeClusterTagArgument().setTag(newTag));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && this.cluster.tag().equals(newTag);
        });
    }

    @Test
    public void exportLogs() throws Exception {
        File logFolder = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"log", (boolean)false);
        Path file1 = Paths.get(logFolder.getAbsolutePath(), "ggcc-agent-1900-01-01-0.log");
        Path file2 = Paths.get(logFolder.getAbsolutePath(), "ggcc-agent-1900-01-01-1.log");
        Files.write(file1, Arrays.asList("The first line", "The second line"), new OpenOption[0]);
        Files.write(file2, Arrays.asList("The first line"), new OpenOption[0]);
        Files.setLastModifiedTime(file1, FileTime.fromMillis(TimeUnit.HOURS.toMillis(3L)));
        Files.setLastModifiedTime(file2, FileTime.fromMillis(TimeUnit.HOURS.toMillis(23L)));
        UploadedLogController.RESOURCES.clear();
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.exportLogs").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)0L);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            CollectLogResponse actRes = this.result(r, new TypeReference<CollectLogResponse>(){});
            List<MultipartFile> files = UploadedLogController.RESOURCES.get(UUID.fromString(actRes.getResourceId()));
            Assertions.assertEquals((int)4, (int)files.size());
            return true;
        });
    }

    @Test
    public void shouldSendErrorIfMissingLogs() throws Exception {
        UploadedLogController.RESOURCES.clear();
        Request req = new Request().setId(UUID.randomUUID()).setAction("ClusterActions.exportLogs").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)-1L);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assertions.assertEquals((int)-32603, (int)r.getError().getCode());
            Assertions.assertEquals((Object)"No activities logged in the selected date range", (Object)r.getError().getMessage());
            return true;
        });
    }

    @Override
    protected int clusterSize() {
        return 2;
    }

    @Override
    protected void changeAgentConfiguration(IgniteEx ignite, boolean isAssertNeeded, String uri, String trustStore, String trustStorePwd, String keyStore, String keyStorePwd) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("--uri", String.join((CharSequence)",", "http://localhost:3000", uri)));
        if (!F.isEmpty((String)trustStore)) {
            args.addAll(Arrays.asList("--management-truststore", trustStore));
        }
        if (!F.isEmpty((String)trustStorePwd)) {
            args.addAll(Arrays.asList("--management-truststore-password", trustStorePwd));
        }
        if (!F.isEmpty((String)keyStore)) {
            args.addAll(Arrays.asList("--management-keystore", keyStore));
        }
        if (!F.isEmpty((String)keyStorePwd)) {
            args.addAll(Arrays.asList("--management-keystore-password", keyStorePwd));
        }
        this.management(ignite, args);
        if (isAssertNeeded) {
            TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildActionRequestTopic((UUID)ignite.context().cluster().get().id())));
        }
    }
}

