/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.test;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.UserFactory;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ProcessShellCommandFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;

public class TestServers {
    public static FtpServer startFtpServer(Path home, T2<String, String> userPass) throws FtpException {
        FtpServerFactory srvFactory = new FtpServerFactory();
        FtpServer srv = srvFactory.createServer();
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(2222);
        srvFactory.addListener("default", factory.createListener());
        UserFactory userFactory = new UserFactory();
        userFactory.setHomeDirectory(home.toAbsolutePath().toString());
        userFactory.setName((String)userPass.getKey());
        userFactory.setPassword((String)userPass.getValue());
        ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
        WritePermission writePerm = new WritePermission();
        authorities.add(writePerm);
        userFactory.setAuthorities(authorities);
        User user = userFactory.createUser();
        srvFactory.getUserManager().save(user);
        srv.start();
        return srv;
    }

    public static SshServer startSftpServer(Path home, T2<String, String> userPass) throws IOException {
        SshServer srv = SshServer.setUpDefaultServer();
        srv.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        srv.setPasswordAuthenticator((username, password, session) -> F.eq((Object)username, (Object)userPass.getKey()) && F.eq((Object)password, (Object)userPass.getValue()));
        srv.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        srv.setCommandFactory((CommandFactory)new ProcessShellCommandFactory());
        srv.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(home));
        srv.start();
        return srv;
    }
}

