/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.logger.NullLogger;

public class TestLogger
extends NullLogger {
    private final boolean infoEnabled;
    private final boolean debugEnabled;
    protected final List<String> buf;
    protected IgniteLogger log;

    public TestLogger() {
        this(Collections.synchronizedList(new ArrayList(512)), true, false);
    }

    public TestLogger(List<String> buf, boolean infoEnabled, boolean debugEnabled) {
        this.infoEnabled = infoEnabled;
        this.debugEnabled = debugEnabled;
        this.buf = buf;
    }

    public IgniteLogger wrap(IgniteLogger log) {
        this.log = log;
        return this;
    }

    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void trace(String msg) {
        if (this.log != null) {
            this.log.trace(msg);
        }
        this.buf.add(msg);
    }

    public void debug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
        this.buf.add(msg);
    }

    public void info(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        }
        this.buf.add(msg);
    }

    public void warning(String msg, Throwable t) {
        if (this.log != null) {
            this.log.warning(msg, t);
        }
        this.buf.add(msg);
    }

    public void error(String msg) {
        if (this.log != null) {
            this.log.error(msg);
        }
        this.buf.add(msg);
    }

    public void error(String msg, Throwable t) {
        if (this.log != null) {
            this.log.error(msg, t);
        }
        this.buf.add(msg);
    }

    public String toString() {
        return this.buf.toString();
    }

    public boolean contains(String s) {
        return new ArrayList<String>(this.buf).stream().anyMatch(line -> line.contains(s));
    }

    public void clear() {
        this.buf.clear();
    }
}

