/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.feature;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.gridgain.control.agent.dto.feature.AbstractFeatureRequest;
import org.gridgain.control.agent.dto.feature.AgentDynamicFeatures;
import org.gridgain.control.agent.dto.feature.BatchBoundedAgentFeatureRequest;
import org.gridgain.control.agent.dto.feature.DisablingAgentFeatureRequest;
import org.gridgain.control.agent.dto.feature.TemporarilyDisablingAgentFeatureRequest;
import org.gridgain.control.agent.dto.feature.ThrottlingAgentFeatureRequest;
import org.gridgain.control.agent.processor.feature.AgentDynamicFeatureProcessor;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public class AgentDynamicFeatureProcessorTest {
    private final Clock clock = (Clock)Mockito.mock(Clock.class);
    private AgentDynamicFeatureProcessor agentFeatureProcessor;

    @Before
    public void setUp() {
        Mockito.reset((Object[])new Clock[]{this.clock});
        Mockito.when((Object)this.clock.millis()).thenReturn((Object)System.currentTimeMillis());
        this.agentFeatureProcessor = new AgentDynamicFeatureProcessor(this.clock);
    }

    @Test
    public void featureShouldBeAvalible() {
        Assertions.assertTrue((boolean)this.agentFeatureProcessor.isAvailable(AgentDynamicFeatures.TRACING));
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
    }

    @Test
    public void featureShouldBeDisabledTemporarily() {
        TemporarilyDisablingAgentFeatureRequest req = new TemporarilyDisablingAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), TimeUnit.SECONDS.toMillis(5L));
        this.agentFeatureProcessor.onRequest((AbstractFeatureRequest)req);
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isAvailable(AgentDynamicFeatures.TRACING));
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
    }

    @Test
    public void featureShouldBeDisabledPermanently() {
        DisablingAgentFeatureRequest req = new DisablingAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), false);
        this.agentFeatureProcessor.onRequest((AbstractFeatureRequest)req);
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isAvailable(AgentDynamicFeatures.TRACING));
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
    }

    @Test
    public void featureShouldBeAvalibleAfterTime() {
        TemporarilyDisablingAgentFeatureRequest req = new TemporarilyDisablingAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), TimeUnit.SECONDS.toMillis(5L));
        this.agentFeatureProcessor.onRequest((AbstractFeatureRequest)req);
        long curTime = this.clock.millis();
        Mockito.when((Object)this.clock.millis()).thenReturn((Object)(curTime + TimeUnit.SECONDS.toMillis(6L)));
        Assertions.assertTrue((boolean)this.agentFeatureProcessor.isAvailable(AgentDynamicFeatures.TRACING));
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
    }

    @Test
    public void featureShouldBeThrottled() {
        ThrottlingAgentFeatureRequest req = new ThrottlingAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), TimeUnit.SECONDS.toMillis(5L), 3);
        this.agentFeatureProcessor.onRequest((AbstractFeatureRequest)req);
        Assertions.assertTrue((boolean)this.agentFeatureProcessor.isAvailable(AgentDynamicFeatures.TRACING));
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
        Assertions.assertTrue((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
        Assertions.assertTrue((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
        Assertions.assertTrue((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
        long curTime = this.clock.millis();
        Mockito.when((Object)this.clock.millis()).thenReturn((Object)(curTime + TimeUnit.SECONDS.toMillis(6L)));
        Assertions.assertTrue((boolean)this.agentFeatureProcessor.isAvailable(AgentDynamicFeatures.TRACING));
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
    }

    @Test
    public void featureShouldAvalibleAfterThrottledTime() {
        ThrottlingAgentFeatureRequest req = new ThrottlingAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), TimeUnit.SECONDS.toMillis(5L), 3);
        this.agentFeatureProcessor.onRequest((AbstractFeatureRequest)req);
        long curTime = this.clock.millis();
        Mockito.when((Object)this.clock.millis()).thenReturn((Object)(curTime + TimeUnit.SECONDS.toMillis(6L)));
        Assertions.assertTrue((boolean)this.agentFeatureProcessor.isAvailable(AgentDynamicFeatures.TRACING));
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
        Assertions.assertFalse((boolean)this.agentFeatureProcessor.isThrottled(AgentDynamicFeatures.TRACING));
    }

    @Test
    public void featureShouldReturnMaxIntSizeWhenTimeIsExpaired() {
        BatchBoundedAgentFeatureRequest req = new BatchBoundedAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), TimeUnit.SECONDS.toMillis(5L), 3);
        this.agentFeatureProcessor.onRequest((AbstractFeatureRequest)req);
        Assertions.assertEquals((int)this.agentFeatureProcessor.getBatchSize(AgentDynamicFeatures.TRACING), (int)3);
        long curTime = this.clock.millis();
        Mockito.when((Object)this.clock.millis()).thenReturn((Object)(curTime + TimeUnit.SECONDS.toMillis(6L)));
        Assertions.assertEquals((int)this.agentFeatureProcessor.getBatchSize(AgentDynamicFeatures.TRACING), (int)Integer.MAX_VALUE);
    }
}

