/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export.metric;

import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.metric.BooleanMetric;
import org.apache.ignite.spi.metric.DoubleMetric;
import org.apache.ignite.spi.metric.HistogramMetric;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.Metric;
import org.gridgain.control.agent.configuration.DistributedMetricExporterConfiguration;
import org.gridgain.control.agent.dto.feature.AgentDynamicFeatures;
import org.gridgain.control.agent.dto.metric.MetricRequest;
import org.gridgain.control.agent.dto.metric.MetricResponse;
import org.gridgain.control.agent.dto.metric.MetricSchema;
import org.gridgain.control.agent.dto.metric.MetricValueConsumer;
import org.gridgain.control.agent.processor.MetricRegistryProcessor;
import org.gridgain.control.agent.processor.export.metric.LocalMetricExportTask;
import org.gridgain.control.agent.processor.export.metric.LocalNodeMetricsExporterProcessor;
import org.gridgain.control.agent.processor.export.metric.MetricMapper;
import org.gridgain.control.agent.processor.feature.AgentDynamicFeatureProcessor;
import org.gridgain.control.agent.test.MetricTreeFixture;
import org.gridgain.control.agent.test.TestGridKernalContext;
import org.gridgain.control.agent.utils.ThreadPoolFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class MetricsExporterTest {
    private static LocalNodeMetricsExporterProcessor exporter;
    private final MetricMapper metricMapper = new MetricMapper();
    private TestGridKernalContext ctx;
    private AgentDynamicFeatureProcessor agentDynamicFeatureProcessor;
    private ExecutorService executorSrvc;
    private static MockedStatic<ThreadPoolFactory> threadPoolMock;

    @Before
    public void setup() throws Exception {
        this.agentDynamicFeatureProcessor = (AgentDynamicFeatureProcessor)Mockito.spy((Object)new AgentDynamicFeatureProcessor(Clock.systemDefaultZone()));
        this.ctx = new TestGridKernalContext();
        this.executorSrvc = (ExecutorService)Mockito.spy((Object)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MICROSECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("test-pool"), new ThreadPoolExecutor.DiscardPolicy()));
        threadPoolMock.when(() -> ThreadPoolFactory.newSingleThreadDiscardOthersThreadExecutor((String)((String)ArgumentMatchers.any()))).thenReturn((Object)this.executorSrvc);
        DistributedMetricExporterConfiguration cfg = new DistributedMetricExporterConfiguration((GridKernalContext)new TestGridKernalContext());
        Clock clock = Clock.systemDefaultZone();
        LocalNodeMetricsExporterProcessor exporter = new LocalNodeMetricsExporterProcessor((GridKernalContext)new TestGridKernalContext(), this.agentDynamicFeatureProcessor, this.metricMapper, new MetricRegistryProcessor((GridKernalContext)new TestGridKernalContext(), this.ctx.metric(), clock, cfg), clock);
        exporter.start();
        MetricsExporterTest.exporter = (LocalNodeMetricsExporterProcessor)Mockito.spy((Object)exporter);
        this.ctx.io().addMessageListener(GridTopic.TOPIC_METRICS, (arg_0, arg_1, arg_2) -> ((LocalNodeMetricsExporterProcessor)MetricsExporterTest.exporter).metricRequestListener(arg_0, arg_1, arg_2));
    }

    @Test
    public void testResponse() {
        String userTag = "testUserTag";
        this.doTestResponse(userTag);
    }

    @Test
    public void testResponseWithoutUserTag() {
        String userTag = null;
        this.doTestResponse(userTag);
    }

    @Test
    public void testDeserializeResponseFromByteArray() {
        UUID clusterId = UUID.randomUUID();
        String consistentId = "testConsistentId";
        List<MetricRegistry> metrics = MetricTreeFixture.generateMetrics();
        MetricResponse msg = this.metricMapper.metricMessage(clusterId, "tag", System.currentTimeMillis(), consistentId, metrics, false);
        MetricResponse newRes = new MetricResponse(msg.body());
        final HashMap<String, Byte> map = new HashMap<String, Byte>();
        for (MetricRegistry reg : MetricTreeFixture.generateMetrics()) {
            for (Metric m : reg) {
                byte type = -1;
                if (m instanceof BooleanMetric) {
                    type = 0;
                } else if (m instanceof IntMetric) {
                    type = 1;
                } else if (m instanceof LongMetric) {
                    type = 2;
                } else if (m instanceof DoubleMetric) {
                    type = 3;
                } else if (m instanceof LongAdderMetric) {
                    type = 2;
                }
                if (m instanceof HitRateMetric) {
                    map.put(m.name() + ".60000", (byte)2);
                    continue;
                }
                if (m instanceof HistogramMetric) {
                    map.put(m.name() + ".60000", (byte)2);
                    map.put(m.name() + ".inf", (byte)2);
                    continue;
                }
                if (type == -1) {
                    throw new IllegalArgumentException("Unknown metric type.");
                }
                map.put(m.name(), type);
            }
        }
        newRes.processData(newRes.schema(), new MetricValueConsumer(){

            public void onBoolean(String name, boolean val) {
                Assert.assertEquals((long)0L, (long)((Byte)map.remove(name)).byteValue());
            }

            public void onInt(String name, int val) {
                Assert.assertEquals((long)1L, (long)((Byte)map.remove(name)).byteValue());
            }

            public void onLong(String name, long val) {
                Assert.assertEquals((long)2L, (long)((Byte)map.remove(name)).byteValue());
            }

            public void onDouble(String name, double val) {
                Assert.assertEquals((long)3L, (long)((Byte)map.remove(name)).byteValue());
            }
        });
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void shouldNotExportWhenIsNotAvailable() throws IgniteCheckedException {
        ((AgentDynamicFeatureProcessor)Mockito.doReturn((Object)false).when((Object)this.agentDynamicFeatureProcessor)).isAvailable((AgentDynamicFeatures)ArgumentMatchers.eq((Object)AgentDynamicFeatures.METRICS));
        this.ctx.io().sendToGridTopic(UUID.randomUUID(), GridTopic.TOPIC_METRICS, (Message)new MetricRequest(), (byte)0);
        ((ExecutorService)Mockito.verify((Object)this.executorSrvc, (VerificationMode)Mockito.never())).submit((Runnable)ArgumentMatchers.any(LocalMetricExportTask.class));
    }

    private void doTestResponse(String userTag) {
        UUID clusterId = UUID.randomUUID();
        String consistentId = "testConsistentId";
        List<MetricRegistry> metrics = MetricTreeFixture.generateMetrics();
        MetricResponse msg = this.metricMapper.metricMessage(clusterId, userTag, System.currentTimeMillis(), consistentId, metrics, false);
        Assert.assertEquals((Object)clusterId, (Object)msg.clusterId());
        Assert.assertEquals((Object)userTag, (Object)msg.userTag());
        Assert.assertEquals((Object)consistentId, (Object)msg.consistentId());
        MetricSchema schema = msg.schema();
        final HashMap<String, Byte> map = new HashMap<String, Byte>();
        for (MetricRegistry reg : metrics) {
            for (Metric m : reg) {
                byte type = -1;
                if (m instanceof BooleanMetric) {
                    type = 0;
                } else if (m instanceof IntMetric) {
                    type = 1;
                } else if (m instanceof LongMetric) {
                    type = 2;
                } else if (m instanceof DoubleMetric) {
                    type = 3;
                } else if (m instanceof LongAdderMetric) {
                    type = 2;
                }
                if (m instanceof HitRateMetric) {
                    map.put(m.name() + ".60000", (byte)2);
                    continue;
                }
                if (m instanceof HistogramMetric) {
                    map.put(m.name() + ".60000", (byte)2);
                    map.put(m.name() + ".inf", (byte)2);
                    continue;
                }
                if (type == -1) {
                    throw new IllegalArgumentException("Unknown metric type.");
                }
                map.put(m.name(), type);
            }
        }
        msg.processData(schema, new MetricValueConsumer(){

            public void onBoolean(String name, boolean val) {
                Assert.assertEquals((long)0L, (long)((Byte)map.remove(name)).byteValue());
            }

            public void onInt(String name, int val) {
                Assert.assertEquals((long)1L, (long)((Byte)map.remove(name)).byteValue());
            }

            public void onLong(String name, long val) {
                Assert.assertEquals((long)2L, (long)((Byte)map.remove(name)).byteValue());
            }

            public void onDouble(String name, double val) {
                Assert.assertEquals((long)3L, (long)((Byte)map.remove(name)).byteValue());
            }
        });
        Assert.assertTrue((boolean)map.isEmpty());
    }

    static {
        threadPoolMock = Mockito.mockStatic(ThreadPoolFactory.class);
    }
}

