/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.action;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithAuthenticationTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.TaskResponse;
import org.junit.Assert;
import org.junit.Test;

public class DistributedActionProcessorWithAuthenticationTest
extends AbstractActionControllerWithAuthenticationTest {
    @Override
    protected int clusterSize() {
        return 3;
    }

    @Test
    public void shouldExecuteActionOnCoordinatorNode() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("ignite", "ignite")));
        UUID crdId = this.cluster.localNode().id();
        String consistentId = String.valueOf(this.cluster.localNode().consistentId());
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdAction").setNodeIds(Collections.singleton(crdId)).setSessionId(sesId);
        this.executeAction((AbstractRequest)req, jobRes -> {
            List<TaskResponse> taskRes = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskRes.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskRes.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                return jobRes.size() == completedTask.get().getJobCount();
            }
            return false;
        });
        JobResponse res = (JobResponse)F.first(this.jobResults(req.getId()));
        Assert.assertEquals((Object)consistentId, (Object)res.getNodeConsistentId());
        Assert.assertEquals((Object)crdId, (Object)UUID.fromString((String)res.getResult()));
    }

    @Test
    public void shouldExecuteActionOnNonCoordinatorNodes() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("ignite", "ignite")));
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdAction").setNodeIds(this.nonCrdNodeIds).setSessionId(sesId);
        this.executeAction((AbstractRequest)req, jobRes -> {
            List<TaskResponse> taskRes = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskRes.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskRes.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                Set results = jobRes.stream().map(r -> UUID.fromString(r.getResult().toString())).collect(Collectors.toSet());
                return jobRes.size() == completedTask.get().getJobCount() && results.equals(this.nonCrdNodeIds);
            }
            return false;
        });
        List<JobResponse> responses = this.jobResults(req.getId());
        boolean responsesHasCorrectConsistentIds = this.nonCrdNodeConsistentIds.containsAll(responses.stream().map(JobResponse::getNodeConsistentId).collect(Collectors.toSet()));
        Assert.assertTrue((boolean)responsesHasCorrectConsistentIds);
    }

    @Test
    public void shouldExecuteActionOnAllNodes() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("ignite", "ignite")));
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdAction").setSessionId(sesId);
        this.executeAction((AbstractRequest)req, jobRes -> {
            List<TaskResponse> taskRes = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskRes.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskRes.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                Set results = jobRes.stream().map(r -> UUID.fromString(r.getResult().toString())).collect(Collectors.toSet());
                return results.equals(this.allNodeIds) && completedTask.get().getJobCount() == this.allNodeIds.size();
            }
            return false;
        });
        List<JobResponse> responses = this.jobResults(req.getId());
        boolean responsesHasCorrectConsistentIds = this.allNodeConsistentIds.containsAll(responses.stream().map(JobResponse::getNodeConsistentId).collect(Collectors.toSet()));
        Assert.assertTrue((boolean)responsesHasCorrectConsistentIds);
    }

    @Test
    public void shouldExecuteActionOnAllNodesWithNodeStop() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("ignite", "ignite")));
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdActionWithSleep").setArgument((Object)5000).setSessionId(sesId);
        this.executeActionAndStopNode((AbstractRequest)req, 1000L, 1, res -> {
            List<TaskResponse> taskRes = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskRes.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> failedTask = taskRes.stream().filter(r -> r.getStatus() == Status.FAILED).findFirst();
            if (runningTask.isPresent() && failedTask.isPresent()) {
                long failedJobCnt = res.stream().filter(r -> r.getStatus() == Status.FAILED).count();
                return res.size() == failedTask.get().getJobCount() && failedJobCnt == 1L;
            }
            return false;
        });
    }

    @Test
    public void shouldSendErrorResponseOnExecutingSecuredActionWithoutAuthentication() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.numberAction").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)10);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            return taskRes.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }

    @Test
    public void shouldSendErrorResponseOnExecutingSecuredActionWithInvalidSessionId() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.numberAction").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)10).setSessionId(UUID.randomUUID());
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            return taskRes.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }
}

