/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.PluginConfiguration;
import org.awaitility.core.ConditionTimeoutException;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.snapshot.GridGainSnapshotInfo;
import org.gridgain.control.agent.dto.snapshot.GridGainSnapshotOperationInfo;
import org.gridgain.control.agent.dto.snapshot.GridgainSnapshotProgressMixIn;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.SnapshotsUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotProgress;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotOperationProcessorTest
extends AgentCommonAbstractTest {
    private boolean snapshotsEnabled;

    @Override
    public void cleanup() {
        super.cleanup();
        this.inInterceptor.addMixIn(SnapshotProgress.class, GridgainSnapshotProgressMixIn.class);
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        IgniteConfiguration cfg = super.getConfiguration(instanceName);
        if (this.snapshotsEnabled) {
            cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
        }
        return cfg;
    }

    @Test
    public void shouldNotSendSnapshotOperationInfo() {
        IgniteEx ignite = this.startGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        Assert.assertThrows(ConditionTimeoutException.class, () -> TestUtils.assertWithPoll(() -> this.inInterceptor.getPayload(SnapshotsUtils.buildSnapshotOperationDest((UUID)cluster.id()), GridGainSnapshotOperationInfo.class) != null));
    }

    @Test
    public void shouldNotSendSnapshotOperationInfoForNotAttachedCluster() {
        this.snapshotsEnabled = true;
        IgniteEx ignite = this.startGrids(2);
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        this.changeAgentConfiguration(ignite);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        cache.put((Object)1, (Object)2);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        GridSnapshot snapProc = gg.snapshot();
        SnapshotFuture snapshot = snapProc.createFullSnapshot(null, "test-snapshot");
        snapshot.get();
        snapProc.restoreSnapshot(snapshot.snapshotOperation().snapshotId(), null, "restore").get();
        snapProc.deleteSnapshot(snapshot.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null).get();
        String dest = SnapshotsUtils.buildSnapshotOperationDest((UUID)cluster.id());
        Assert.assertThrows(ConditionTimeoutException.class, () -> TestUtils.assertWithPoll(500L, 1000L, 10000L, () -> !F.isEmpty(this.inInterceptor.getAllPayloads(dest, GridGainSnapshotOperationInfo.class))));
    }

    @Test
    public void shouldSendSnapshotOperationInfo() {
        this.snapshotsEnabled = true;
        IgniteEx ignite = this.startGrids(2);
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        Object consistentId = cluster.forServers().forYoungest().node().consistentId();
        HashMap data = U.newHashMap((int)1024);
        for (int i = 0; i < 1024; ++i) {
            data.put(i, i);
        }
        for (int j = 0; j < 4; ++j) {
            IgniteCache cache = ignite.getOrCreateCache(this.cacheConfiguration("cache-" + j).setNodeFilter((IgnitePredicate & Serializable)n -> n.consistentId().equals(consistentId)));
            cache.putAll((Map)data);
        }
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        GridSnapshot snapProc = gg.snapshot();
        String msg = "test-snapshot";
        HashSet cacheNames = new HashSet(ignite.cacheNames());
        SnapshotFuture snapshot = snapProc.createFullSnapshot(null, msg);
        snapshot.get();
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotOperationInfo> op = this.inInterceptor.getAllPayloads(SnapshotsUtils.buildSnapshotOperationDest((UUID)cluster.id()), GridGainSnapshotOperationInfo.class);
            if (op.size() < 2) {
                return false;
            }
            GridGainSnapshotOperationInfo opStart = op.get(0);
            GridGainSnapshotInfo snapStart = opStart.getSnapshotInfo();
            Assert.assertEquals((Object)SnapshotOperationType.CREATE, (Object)opStart.getType());
            Assert.assertNotNull((Object)opStart.getProgress());
            Assert.assertNull((Object)opStart.getError());
            Assert.assertNull((Object)opStart.getStackTrace());
            Assert.assertEquals((Object)msg, (Object)snapStart.getMessage());
            Assert.assertEquals((Object)cacheNames, (Object)snapStart.getCacheNames());
            Assert.assertTrue((String)"Started at is not set", (opStart.getStartedAt() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Ts is not set", (opStart.getTs() > 0L ? 1 : 0) != 0);
            GridGainSnapshotOperationInfo opFinish = op.get(op.size() - 1);
            GridGainSnapshotInfo snapFinish = opFinish.getSnapshotInfo();
            Assert.assertEquals((Object)opFinish.getOperationId(), (Object)opFinish.getOperationId());
            Assert.assertEquals((Object)SnapshotOperationType.CREATE, (Object)opFinish.getType());
            Assert.assertNull((Object)opFinish.getProgress());
            Assert.assertNull((Object)opFinish.getError());
            Assert.assertNull((Object)opStart.getStackTrace());
            Assert.assertEquals((Object)msg, (Object)snapFinish.getMessage());
            Assert.assertEquals((Object)cacheNames, (Object)snapFinish.getCacheNames());
            Assert.assertTrue((String)"Started at is not set", (opStart.getStartedAt() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Ts is not set", (opStart.getTs() > 0L ? 1 : 0) != 0);
            return true;
        });
        this.inInterceptor.clearMessages();
        SnapshotFuture restore = snapProc.restoreSnapshot(snapshot.snapshotOperation().snapshotId(), null, "restore");
        restore.get();
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotOperationInfo> op = this.inInterceptor.getAllPayloads(SnapshotsUtils.buildSnapshotOperationDest((UUID)cluster.id()), GridGainSnapshotOperationInfo.class);
            if (op.size() < 2) {
                return false;
            }
            GridGainSnapshotOperationInfo opStart = op.get(0);
            GridGainSnapshotInfo snapStart = opStart.getSnapshotInfo();
            Assert.assertEquals((Object)SnapshotOperationType.RESTORE, (Object)opStart.getType());
            Assert.assertNotNull((Object)opStart.getProgress());
            Assert.assertNull((Object)opStart.getError());
            Assert.assertNull((Object)opStart.getStackTrace());
            Assert.assertEquals((Object)msg, (Object)snapStart.getMessage());
            Assert.assertEquals((Object)cacheNames, (Object)snapStart.getCacheNames());
            Assert.assertTrue((String)"Started at is not set", (opStart.getStartedAt() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Ts is not set", (opStart.getTs() > 0L ? 1 : 0) != 0);
            GridGainSnapshotOperationInfo opFinish = op.get(op.size() - 1);
            GridGainSnapshotInfo snapFinish = opFinish.getSnapshotInfo();
            Assert.assertEquals((Object)opFinish.getOperationId(), (Object)opFinish.getOperationId());
            Assert.assertEquals((Object)SnapshotOperationType.RESTORE, (Object)opFinish.getType());
            Assert.assertNull((Object)opFinish.getProgress());
            Assert.assertNull((Object)opFinish.getError());
            Assert.assertNull((Object)opStart.getStackTrace());
            Assert.assertEquals((Object)msg, (Object)snapFinish.getMessage());
            Assert.assertEquals((Object)cacheNames, (Object)snapFinish.getCacheNames());
            Assert.assertTrue((String)"Started at is not set", (opStart.getStartedAt() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Ts is not set", (opStart.getTs() > 0L ? 1 : 0) != 0);
            return true;
        });
        this.inInterceptor.clearMessages();
        SnapshotFuture del = snapProc.deleteSnapshot(snapshot.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, "delete");
        del.get();
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotOperationInfo> op = this.inInterceptor.getAllPayloads(SnapshotsUtils.buildSnapshotOperationDest((UUID)cluster.id()), GridGainSnapshotOperationInfo.class);
            if (op.size() < 2) {
                return false;
            }
            GridGainSnapshotOperationInfo opStart = op.get(0);
            GridGainSnapshotInfo snapStart = opStart.getSnapshotInfo();
            Assert.assertEquals((Object)SnapshotOperationType.DELETE, (Object)opStart.getType());
            Assert.assertNotNull((Object)opStart.getProgress());
            Assert.assertNull((Object)opStart.getError());
            Assert.assertEquals((Object)cacheNames, (Object)snapStart.getCacheNames());
            GridGainSnapshotOperationInfo opFinish = op.get(op.size() - 1);
            GridGainSnapshotInfo snapFinish = opFinish.getSnapshotInfo();
            Assert.assertEquals((Object)opFinish.getOperationId(), (Object)opFinish.getOperationId());
            Assert.assertEquals((Object)SnapshotOperationType.DELETE, (Object)opFinish.getType());
            Assert.assertNull((Object)opFinish.getProgress());
            Assert.assertNull((Object)opFinish.getError());
            Assert.assertNull((Object)opStart.getStackTrace());
            Assert.assertNull((Object)snapFinish.getMessage());
            Assert.assertEquals((Object)cacheNames, (Object)snapFinish.getCacheNames());
            Assert.assertTrue((String)"Started at is not set", (opStart.getStartedAt() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Ts is not set", (opStart.getTs() > 0L ? 1 : 0) != 0);
            return true;
        });
    }
}

