/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.gridgain.control.agent.config.TestChannelInterceptor;
import org.gridgain.control.agent.config.TestHandshakeInterceptor;
import org.gridgain.control.agent.config.TestWebsocketDecoratedFactory;
import org.gridgain.control.agent.utils.AgentObjectMapperFactory;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;

@TestConfiguration
@EnableWebSocketMessageBroker
public class WebSocketConfig
extends AbstractWebSocketMessageBrokerConfigurer {
    public static final String AGENTS_PATH = "/agents";
    private final ObjectMapper mapper = AgentObjectMapperFactory.binaryMapper();

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{AGENTS_PATH}).addInterceptors(new HandshakeInterceptor[]{this.testHandshakeInterceptor()}).setAllowedOrigins(new String[]{"*"});
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setMessageSizeLimit(0xA00000);
        registration.setSendBufferSizeLimit(0xA00000);
        registration.addDecoratorFactory((WebSocketHandlerDecoratorFactory)this.testWebsocketDecoratedFactory());
    }

    public void configureMessageBroker(MessageBrokerRegistry cfg) {
        cfg.setApplicationDestinationPrefixes(new String[]{"/app", "/topic"}).enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.getHeartbeatScheduler()).setHeartbeatValue(new long[]{10000L, 10000L});
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(1);
        registration.interceptors(new ChannelInterceptor[]{this.testInboundInterceptor()});
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(1);
        registration.interceptors(new ChannelInterceptor[]{this.testOutboundInterceptor()});
    }

    @Bean
    public ServletServerContainerFactoryBean createWebSocketContainer() {
        ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
        container.setMaxTextMessageBufferSize(Integer.valueOf(0xA00000));
        container.setMaxBinaryMessageBufferSize(Integer.valueOf(0xA00000));
        container.setMaxSessionIdleTimeout(Long.valueOf(15000L));
        return container;
    }

    public boolean configureMessageConverters(List<MessageConverter> msgConverters) {
        MappingJackson2MessageConverter smileJsonConverter = new MappingJackson2MessageConverter(new MimeType[]{MimeTypeUtils.APPLICATION_OCTET_STREAM});
        smileJsonConverter.setObjectMapper(this.mapper);
        msgConverters.add((MessageConverter)smileJsonConverter);
        return false;
    }

    @Bean
    public TestWebsocketDecoratedFactory testWebsocketDecoratedFactory() {
        return new TestWebsocketDecoratedFactory();
    }

    @Bean
    public TestChannelInterceptor testInboundInterceptor() {
        return new TestChannelInterceptor(this.mapper);
    }

    @Bean
    public TestChannelInterceptor testOutboundInterceptor() {
        return new TestChannelInterceptor(this.mapper);
    }

    @Bean
    public TestHandshakeInterceptor testHandshakeInterceptor() {
        return new TestHandshakeInterceptor();
    }

    protected TaskScheduler getHeartbeatScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(1);
        scheduler.setThreadNamePrefix("stomp-heartbeat-thread-");
        scheduler.initialize();
        return scheduler;
    }
}

