/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationManager;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.TracingConfigurationArgument;
import org.gridgain.control.agent.dto.tracing.TracingConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TracingActionsControllerTest
extends AbstractActionControllerTest {
    private static final Set<Scope> INCLUDED_SCOPES = Collections.singleton(Scope.COMMUNICATION);
    private static final Set<Scope> EMPTY_SCOPES = Collections.emptySet();

    @Test
    public void shouldChangeConfiguration() {
        ArrayList<TracingConfiguration> cfgs = new ArrayList<TracingConfiguration>();
        cfgs.add(new TracingConfiguration().setScope(Scope.TX).setSamplingRate(0.1).setIncludedScopes(INCLUDED_SCOPES));
        cfgs.add(new TracingConfiguration().setScope(Scope.DISCOVERY).setSamplingRate(0.2));
        cfgs.add(new TracingConfiguration().setScope(Scope.EXCHANGE).setSamplingRate(0.3));
        cfgs.add(new TracingConfiguration().setScope(Scope.COMMUNICATION).setSamplingRate(0.4));
        Request req = new Request().setId(UUID.randomUUID()).setAction("TracingActions.changeConfiguration").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new TracingConfigurationArgument().setConfigurations(cfgs));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        this.checkTracingConfiguration(Scope.TX, 0.1, INCLUDED_SCOPES);
        this.checkTracingConfiguration(Scope.DISCOVERY, 0.2, EMPTY_SCOPES);
        this.checkTracingConfiguration(Scope.EXCHANGE, 0.3, EMPTY_SCOPES);
        this.checkTracingConfiguration(Scope.COMMUNICATION, 0.4, EMPTY_SCOPES);
        cfgs.clear();
        cfgs.add(new TracingConfiguration().setScope(Scope.TX).setSamplingRate(0.5));
        cfgs.add(new TracingConfiguration().setScope(Scope.DISCOVERY).setSamplingRate(0.6));
        req = new Request().setId(UUID.randomUUID()).setAction("TracingActions.changeConfiguration").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new TracingConfigurationArgument().setConfigurations(cfgs));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        this.checkTracingConfiguration(Scope.TX, 0.5, EMPTY_SCOPES);
        this.checkTracingConfiguration(Scope.DISCOVERY, 0.6, EMPTY_SCOPES);
        this.checkTracingConfiguration(Scope.EXCHANGE, 0.3, EMPTY_SCOPES);
        this.checkTracingConfiguration(Scope.COMMUNICATION, 0.4, EMPTY_SCOPES);
    }

    private void checkTracingConfiguration(Scope scope, double samplingRate, Set<Scope> scopes) {
        TracingConfigurationManager cfgMgr = this.cluster.ignite().tracingConfiguration();
        TracingConfigurationCoordinates coords = new TracingConfigurationCoordinates.Builder(scope).build();
        TracingConfigurationParameters params = cfgMgr.get(coords);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((double)samplingRate, (double)params.samplingRate(), (double)0.001);
        Assert.assertEquals(scopes, (Object)params.includedScopes());
    }
}

