/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import org.apache.ignite.IgniteAuthenticationException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.AbstractOidcMockTest;
import org.gridgain.control.agent.action.Session;
import org.gridgain.control.agent.action.SessionRegistry;
import org.gridgain.control.agent.action.controller.SecurityActionsController;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SecurityActionsControllerOidcMockTest
extends AbstractOidcMockTest {
    private SecurityActionsController controller;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.controller = new SecurityActionsController(this.ctx);
    }

    @Test
    public void shouldAuthenticateWithOidc() throws IgniteCheckedException {
        AuthenticateCredentials creds = new AuthenticateCredentials().setCredentials(new SecurityCredentials(null, null, (Object)U.map((Object)"tokenType", (Object)"Bearer", (Object)"accessToken", (Object)"correct_token")));
        String sesId = this.controller.authenticate(creds);
        Assert.assertNull((Object)sesId);
        ((SessionRegistry)Mockito.verify((Object)this.sesRegistry, (VerificationMode)Mockito.never())).saveSession((Session)ArgumentMatchers.any());
        ArgumentCaptor captor = ArgumentCaptor.forClass(AuthenticationContext.class);
        ((IgniteSecurity)Mockito.verify((Object)this.security, (VerificationMode)Mockito.times((int)1))).authenticate((AuthenticationContext)captor.capture());
        Assert.assertEquals((Object)((AuthenticationContext)captor.getValue()).credentials(), (Object)creds.getCredentials());
    }

    @Test(expected=IgniteAuthenticationException.class)
    public void shouldThrowInvalidCredentials() throws IgniteCheckedException {
        AuthenticateCredentials creds = new AuthenticateCredentials().setCredentials(new SecurityCredentials(null, null, (Object)U.map((Object)"tokenType", (Object)"Bearer", (Object)"accessToken", (Object)"invalid")));
        this.controller.authenticate(creds);
    }

    @Test(expected=IgniteAuthenticationException.class)
    public void shouldThrowSessionSpiNotSet() throws IgniteCheckedException {
        AuthenticateCredentials creds = new AuthenticateCredentials();
        this.controller.authenticate(creds);
    }
}

