/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minidev.json.JSONArray;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.query.QueryArgument;
import org.gridgain.control.agent.dto.action.query.QueryField;
import org.gridgain.control.agent.dto.action.query.QueryResult;
import org.gridgain.control.agent.utils.AgentObjectMapperFactory;
import org.junit.Test;

public class QueryActionsControllerWithParametersTest
extends AbstractActionControllerTest {
    private final DateFormat baseTimestampFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S");

    @Override
    protected void bootstrapCluster() {
        String insertAllTypesQry_1 = this.getInsertAllTypesQuery(1, false, 3, 10, 50, new BigDecimal(900), 2.0, 35.0f, "12:34:57", "2019-05-05", "2019-05-05 12:34:57", "char_1", 'a', UUID.fromString("a-a-a-a-a"));
        String insertAllTypesQry_2 = this.getInsertAllTypesQuery(2, true, 30, 100, 500, new BigDecimal(9000), 20.0, 350.0f, "13:40:25", "2019-11-15", "2019-11-15 13:40:25", "char_2", 'b', UUID.fromString("b-b-b-b-b"));
        Request initReq = new Request().setAction("QueryActions.executeSqlQuery").setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId("qry").setQueryText(this.getAllTypeCreateQueryTable() + insertAllTypesQry_1 + insertAllTypesQry_2).setPageSize(10));
        this.executeAction((AbstractRequest)initReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
    }

    @Test
    public void shouldExecuteQueryWithInParameter() {
        Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT * FROM mc_agent_all_types_table WHERE id IN (?, ?)").setPageSize(10).setParameters(new Object[]{"1", "2"}));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray rows = (JSONArray)ctx.read("$[0].rows[*]", new Predicate[0]);
                return rows.size() == 2;
            }
            return false;
        });
    }

    @Test
    public void shouldExecuteQueryWithSimpleSingleParameters() {
        Stream.of(this.tupleOf("ID", "1"), this.tupleOf("VALUE_BOOL", "true"), this.tupleOf("VALUE_TINY_INT", "3"), this.tupleOf("VALUE_SMALL_INT", "100"), this.tupleOf("VALUE_BIG_INT", "50"), this.tupleOf("VALUE_DECIMAL", "9000"), this.tupleOf("VALUE_DOUBLE", "2.0"), this.tupleOf("VALUE_REAL", "350.0"), this.tupleOf("VALUE_TIME", "12:34:57"), this.tupleOf("VALUE_DATE", "2019-11-15"), this.tupleOf("VALUE_TIMESTAMP", "2019-05-05 12:34:57.0"), this.tupleOf("VALUE_VARCHAR", "char_2"), this.tupleOf("VALUE_CHAR", "b"), this.tupleOf("VALUE_UUID", UUID.fromString("a-a-a-a-a").toString())).forEach(t -> {
            String fieldName = (String)t.getKey();
            Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText(String.format("SELECT * FROM mc_agent_all_types_table WHERE %s = ?", fieldName)).setPageSize(10).setParameters(new Object[]{t.getValue()}));
            this.executeAction((AbstractRequest)req, res -> {
                JobResponse r = (JobResponse)F.first((List)res);
                if (r != null && r.getStatus() == Status.COMPLETED) {
                    QueryResult qr = (QueryResult)F.first(this.result(r, new TypeReference<List<QueryResult>>(){}));
                    int fieldIdx = this.findFieldIndex(qr.getColumns(), fieldName);
                    Object expVal = t.getValue();
                    if (F.first((List)qr.getRows()) == null) {
                        throw new RuntimeException(String.format("Invalid value for parameter [parameter=%s, value=%s]", qr, fieldName, expVal));
                    }
                    String actVal = ((Object[])F.first((List)qr.getRows()))[fieldIdx].toString();
                    if ("VALUE_TIMESTAMP".equals(fieldName)) {
                        try {
                            actVal = this.baseTimestampFormat.format(AgentObjectMapperFactory.QUERY_RESULT_TIMESTAMP_FORMAT.parse(actVal));
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (qr.getRows().size() == 1 && expVal.equals(actVal)) {
                        return true;
                    }
                    throw new RuntimeException(String.format("Received bad result [field=%s, actVal=%s, expVal=%s]", fieldName, actVal, expVal));
                }
                return false;
            });
        });
    }

    private int findFieldIndex(List<QueryField> cols, String fieldName) {
        return IntStream.range(0, cols.size()).filter(i -> fieldName.equals(((QueryField)cols.get(i)).getFieldName())).findFirst().orElse(-1);
    }

    private IgniteBiTuple<String, Object> tupleOf(String field, Object val) {
        return new IgniteBiTuple((Object)field, val);
    }

    private String getAllTypeCreateQueryTable() {
        return "CREATE TABLE mc_agent_all_types_table ( id INT,  value_bool BOOLEAN, value_tiny_int TINYINT, value_small_int SMALLINT, value_big_int BIGINT, value_decimal DECIMAL, value_double DOUBLE, value_real REAL, value_time TIME, value_date DATE, value_timestamp TIMESTAMP, value_varchar VARCHAR, value_char CHAR, value_uuid UUID, PRIMARY KEY (id));";
    }

    private String getInsertAllTypesQuery(int id, boolean boolVal, int tinyIntVal, int smallIntVal, int bigIntVal, BigDecimal decimalVal, double doubleVal, float realVal, String timeVal, String dateVal, String tsVal, String varcharVal, char cVal, UUID uuidVal) {
        return "INSERT INTO mc_agent_all_types_table VALUES(" + id + ", " + boolVal + ", " + tinyIntVal + ", " + smallIntVal + ", " + bigIntVal + ", " + decimalVal + ", " + doubleVal + ", " + realVal + ", " + String.format("'%s'", timeVal) + ", " + String.format("'%s'", dateVal) + ", " + String.format("'%s'", tsVal) + ", " + String.format("'%s'", varcharVal) + ", " + String.format("'%s'", Character.valueOf(cVal)) + ", " + String.format("'%s'", uuidVal) + ");";
    }

    private DocumentContext parse(Object obj) {
        try {
            return JsonPath.parse((String)this.mapper.writeValueAsString(obj));
        }
        catch (JsonProcessingException e) {
            throw new IgniteException((Throwable)e);
        }
    }
}

