/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.action.controller.ResourceController;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.BinaryTypeArgument;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.UpdateBinaryTypeArgument;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class BinaryTypeActionsControllerWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    private static final String META_ACCESS_USERNAME = "metaAccess";
    private final UUID rsrcId = UUID.fromString("3ae02bd5-f7ab-4600-b875-7898f0395c74");
    @Autowired
    ResourceController rsrcController;

    @Override
    protected Map<SecurityCredentials, String> prepareCustomCredentials() {
        HashMap<SecurityCredentials, String> creds = new HashMap<SecurityCredentials, String>(2);
        creds.put(new SecurityCredentials(META_ACCESS_USERNAME, "123456"), "{    defaultAllow: false,    {        cache:'*',        permissions:[CACHE_PUT, CACHE_READ, CACHE_REMOVE, CACHE_CREATE]    },     {        task:'org.gridgain.control.agent.commandline.*',        permissions:[TASK_EXECUTE]    },     {        task:'org.gridgain.control.agent.test.*',        permissions:[TASK_EXECUTE]    },     {        system:[JOIN_AS_SERVER, EVENTS_ENABLE, ADMIN_OPS, ADMIN_METADATA_OPS]    }}");
        creds.put(new SecurityCredentials("server", "123456"), "{    defaultAllow: false,    {        cache:'*',        permissions:[CACHE_PUT, CACHE_READ, CACHE_REMOVE, CACHE_CREATE]    },     {        task:'org.gridgain.control.agent.commandline.*',        permissions:[TASK_EXECUTE]    },     {        task:'org.gridgain.control.agent.test.*',        permissions:[TASK_EXECUTE]    },     {        system:[JOIN_AS_SERVER, EVENTS_ENABLE, ADMIN_OPS]    }}");
        return creds;
    }

    @Override
    public void teardown() {
        this.rsrcController.clear();
        super.teardown();
    }

    @Test
    public void update() throws IgniteCheckedException {
        this.createBinaryCache();
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        Integer typeId = ctx.cacheObjects().metadata().stream().map(BinaryType::typeId).findAny().get();
        this.putTypeToResource(typeId, this.rsrcId);
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(META_ACCESS_USERNAME, "123456")));
        Request req = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("BinaryTypeActions.update").setArgument((Object)new UpdateBinaryTypeArgument().setCoordinate(this.rsrcController.coordinate(this.rsrcId))).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            return true;
        });
    }

    @Test
    public void update_AuthorizeError() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("server", "123456")));
        Request req = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("BinaryTypeActions.update").setArgument((Object)new UpdateBinaryTypeArgument().setCoordinate(this.rsrcController.coordinate(this.rsrcId))).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assertions.assertEquals((int)-32002, (int)r.getError().getCode());
            return true;
        });
    }

    @Test
    public void remove_AuthorizeError() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("server", "123456")));
        Request req = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("BinaryTypeActions.remove").setArgument((Object)new BinaryTypeArgument().setTypeId(123)).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assertions.assertEquals((int)-32002, (int)r.getError().getCode());
            return true;
        });
    }

    private void createBinaryCache() {
        this.cluster.ignite().getOrCreateCache("testCache").withKeepBinary().put((Object)1, (Object)this.cluster.ignite().binary().builder("Person").setField("id", (Object)1, Integer.TYPE).setField("name", (Object)"Joe", String.class).setField("age", (Object)30, Integer.class).build());
    }

    private void putTypeToResource(Integer typeId, UUID rsrcId) throws IgniteCheckedException {
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        BinaryMetadata meta = ((CacheObjectBinaryProcessorImpl)ctx.cacheObjects()).binaryMetadata(typeId.intValue());
        byte[] marshalled = U.marshal((GridKernalContext)ctx, (Object)meta);
        this.rsrcController.put(rsrcId, (Resource)new ByteArrayResource(marshalled));
    }
}

