/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithAuthenticationTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.junit.Test;

public class ActionControllerWithAuthenticationBaseTest
extends AbstractActionControllerWithAuthenticationTest {
    @Test
    public void shouldExecuteActionWithAuthentication() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("ignite", "ignite")));
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.numberAction").setArgument((Object)10).setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
    }

    @Test
    public void shouldSendErrorResponseOnExecutingSecuredActionWithoutAuthentication() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.numberAction").setArgument((Object)10);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }

    @Test
    public void shouldSendErrorResponseOnExecutingSecuredActionWithInvalidSessionId() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.numberAction").setArgument((Object)10).setSessionId(UUID.randomUUID());
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }
}

