/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.resource.DependencyResolver;
import org.apache.ignite.internal.util.GridJavaProcess;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.assertj.core.util.Sets;
import org.awaitility.core.ConditionTimeoutException;
import org.gridgain.control.agent.StartNode;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.commandline.AbstractManagementCommandTest;
import org.gridgain.control.agent.commandline.ManagementCommandHandler;
import org.gridgain.control.agent.config.TestChannelInterceptor;
import org.gridgain.control.agent.config.TestWebsocketDecoratedFactory;
import org.gridgain.control.agent.config.WebSocketConfig;
import org.gridgain.control.agent.test.TestLogger;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.core.env.Environment;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={WebSocketConfig.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext(classMode=DirtiesContext.ClassMode.BEFORE_EACH_TEST_METHOD)
public abstract class AgentCommonAbstractTest
extends AbstractManagementCommandTest {
    private static final Set<String> SKIP_THREAD_NAMES = new HashSet<String>(Arrays.asList("cca-ws-selector", "cca-ws-worker", "cca-compute-tasks-exporter-"));
    protected static final String CONNECTION_ESTABLISHED_MSG = "Established websocket connection with Control Center";
    protected static final String WITHOUT_AGENT_CONFIGURATION_PATH = "src/test/resources/ignite-cfg-without-agent.xml";
    @Autowired
    protected SimpMessagingTemplate template;
    @Autowired
    @Qualifier(value="testInboundInterceptor")
    protected TestChannelInterceptor inInterceptor;
    @Autowired
    @Qualifier(value="testOutboundInterceptor")
    protected TestChannelInterceptor outInterceptor;
    @Autowired
    protected TestWebsocketDecoratedFactory websocketDecoratedFactory;
    @LocalServerPort
    protected int port;
    @Autowired
    private Environment environment;

    @Before
    public void setup() throws Exception {
        this.cleanup();
    }

    @After
    public void teardown() {
        this.cleanup();
    }

    protected void cleanup() {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected List<String> agentThreads() {
        return Thread.getAllStackTraces().keySet().stream().filter(thread -> thread.getName().startsWith("cca-")).map(thread -> thread.getName() + "_" + thread.getId() + "_" + (Object)((Object)thread.getState())).collect(Collectors.toList());
    }

    protected void checkThreads(boolean noThreads) {
        try {
            TestUtils.assertWithPoll(500L, 1000L, 40000L, () -> this.agentThreads().isEmpty() == noThreads);
        }
        catch (ConditionTimeoutException e) {
            String msg = String.join((CharSequence)", ", this.agentThreads());
            throw new ConditionTimeoutException("Running threads: " + msg, (Throwable)e);
        }
    }

    protected void changeAgentConfiguration(IgniteEx ignite) {
        this.changeAgentConfiguration(ignite, true);
    }

    protected void changeAgentConfiguration(IgniteEx ignite, boolean isAssertNeeded) {
        this.changeAgentConfiguration(ignite, isAssertNeeded, false, false, false);
    }

    protected String resourcePath(String name) {
        return this.getClass().getClassLoader().getResource(name).getPath();
    }

    protected void changeAgentConfiguration(IgniteEx ignite, boolean isAssertNeeded, boolean withTrustStore, boolean withKeyStore, boolean withProxy) {
        String trustStore = withTrustStore ? this.resourcePath("ssl/ca.p12") : null;
        String trustStorePwd = withTrustStore ? "123456" : null;
        String keyStore = withKeyStore ? this.resourcePath("ssl/client.p12") : null;
        String keyStorePwd = withKeyStore ? "123456" : null;
        boolean isHttps = !F.isEmpty((String)this.environment.getProperty("server.ssl.key-store"));
        this.changeAgentConfiguration(ignite, isAssertNeeded, this.buildControlCenterUri(isHttps, withProxy), trustStore, trustStorePwd, keyStore, keyStorePwd);
    }

    protected void changeAgentConfiguration(IgniteEx ignite, boolean isAssertNeeded, String uri, String trustStore, String trustStorePwd, String keyStore, String keyStorePwd) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("--uri", uri));
        if (!F.isEmpty((String)trustStore)) {
            args.addAll(Arrays.asList("--management-truststore", trustStore));
        }
        if (!F.isEmpty((String)trustStorePwd)) {
            args.addAll(Arrays.asList("--management-truststore-password", trustStorePwd));
        }
        if (!F.isEmpty((String)keyStore)) {
            args.addAll(Arrays.asList("--management-keystore", keyStore));
        }
        if (!F.isEmpty((String)keyStorePwd)) {
            args.addAll(Arrays.asList("--management-keystore-password", keyStorePwd));
        }
        this.management(ignite, args);
        if (isAssertNeeded) {
            TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildActionRequestTopic((UUID)ignite.context().cluster().get().id())));
        }
    }

    protected void changeClusterId(IgniteEx ignite, UUID clusterId) {
        CommandHandler cmd = new CommandHandler(CommandHandler.initLogger(null));
        Assert.assertNotNull((Object)cmd);
        ArrayList<String> rawArgs = new ArrayList<String>();
        this.addCommonCliArguments(rawArgs, ignite);
        rawArgs.addAll(Arrays.asList("--change-id", clusterId.toString(), "--yes"));
        Assert.assertEquals((long)0L, (long)cmd.execute(rawArgs));
    }

    protected void management(IgniteEx ignite, List<String> args) {
        ManagementCommandHandler cmd = (ManagementCommandHandler)this.createCmdHandler().getKey();
        Assert.assertNotNull((Object)cmd);
        ArrayList<String> rawArgs = new ArrayList<String>();
        this.addCommonCliArguments(rawArgs, ignite);
        rawArgs.addAll(args);
        Assert.assertEquals((long)0L, (long)cmd.execute(rawArgs));
    }

    protected void changeClusterSecret(IgniteEx ignite, UUID clusterSecret) {
        CommandHandler cmd = new CommandHandler(CommandHandler.initLogger(null));
        Assert.assertNotNull((Object)cmd);
        ArrayList<String> rawArgs = new ArrayList<String>();
        this.addCommonCliArguments(rawArgs, ignite);
        rawArgs.addAll(Arrays.asList("--property", "set", "--name", "control-center-agent-cluster-secret", "--val", clusterSecret.toString()));
        Assert.assertEquals((long)0L, (long)cmd.execute(rawArgs));
    }

    private void addCommonCliArguments(List<String> rawArgs, IgniteEx ignite) {
        rawArgs.addAll(Arrays.asList("--port", ignite.localNode().attribute("org.apache.ignite.rest.tcp.port").toString()));
        GridGainConfiguration ggCfg = null;
        try {
            ggCfg = GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)ignite.configuration());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ggCfg != null && ggCfg.getSecurityCredentialsProvider() != null) {
            try {
                SecurityCredentials cred = ggCfg.getSecurityCredentialsProvider().credentials();
                rawArgs.addAll(Arrays.asList("--user", cred.getLogin().toString(), "--password", cred.getPassword().toString()));
            }
            catch (Throwable throwable) {}
        } else if (ignite.configuration().isAuthenticationEnabled()) {
            rawArgs.addAll(Arrays.asList("--user", "ignite", "--password", "ignite"));
        }
    }

    protected String buildControlCenterUri(boolean isHttps, boolean withProxy) {
        String proto = isHttps ? "https" : "http";
        String addr = "localhost";
        if (withProxy) {
            addr = AgentCommonAbstractTest.isWindows() || AgentCommonAbstractTest.isMac() ? "host.docker.internal" : "host.testcontainers.internal";
        }
        return proto + "://" + addr + ":" + this.port;
    }

    protected void attachCluster(IgniteClusterEx cluster, boolean attached) {
        String dest = StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id());
        this.template.convertAndSend((Object)dest, (Object)attached);
    }

    protected void attachCluster(IgniteClusterEx cluster) {
        this.attachCluster(cluster, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startNodeAsSeparatedProcess(String cp, Consumer<TestLogger> op) throws Exception {
        GridJavaProcess node = null;
        try {
            TestLogger log = new TestLogger();
            CountDownLatch readyLatch = new CountDownLatch(1);
            node = GridJavaProcess.exec((String)StartNode.class.getName(), (String)WITHOUT_AGENT_CONFIGURATION_PATH, (IgniteLogger)log, (IgniteInClosure)(CI1 & Serializable)s -> {
                log.info((String)s);
                if (s.contains("Topology snapshot")) {
                    readyLatch.countDown();
                }
            }, null, null, Arrays.asList("-ea", "-DIGNITE_QUIET=false", "-DlicenseUrl=" + this.getDefaultLicensePath(), "-cp", cp), null);
            Assert.assertTrue((boolean)readyLatch.await(60L, TimeUnit.SECONDS));
            op.accept(log);
        }
        finally {
            if (node != null) {
                node.kill();
            }
        }
    }

    protected String getDefaultLicensePath() {
        return GridPluginUtils.home() + "/testlicenses/gridgain-license-v21.xml";
    }

    protected void startNodeWithTestLoggerAndNoAgent(Consumer<TestLogger> op) throws Exception {
        this.startNodeAsSeparatedProcess(AgentCommonAbstractTest.withoutInClassPath(Sets.set((Object[])new String[]{"control-center-agent"})), op);
    }

    protected static String withoutInClassPath(Set<String> excluded) {
        String cp = System.getProperty("java.class.path");
        String sep = System.getProperty("path.separator");
        String cp1 = System.getProperty("surefire.test.class.path");
        if (cp1 != null) {
            cp = cp + sep + cp1;
        }
        String[] paths = cp.split(sep);
        return Arrays.stream(paths).filter(path -> {
            if (path.contains("test-classes")) return true;
            if (!excluded.stream().noneMatch(path::contains)) return false;
            return true;
        }).collect(Collectors.joining(sep));
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    protected IgniteEx startNodeWithTestLogger(TestLogger log, String instanceName) {
        IgniteConfiguration cfg = this.getConfiguration(instanceName);
        cfg.setGridLogger(log.wrap(cfg.getGridLogger()));
        return this.startGrid(cfg);
    }

    protected void setDistributedProperty(IgniteEx ignite, String propName, String propVal) throws IgniteCheckedException {
        DistributedChangeableProperty prop = ignite.context().distributedConfiguration().property(propName);
        prop.propagate(prop.parse(propVal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IgniteEx startGrid(int idx, DependencyResolver rslvr) {
        IgnitionEx.dependencyResolver((DependencyResolver)rslvr);
        try {
            IgniteEx igniteEx = this.startGrid(idx);
            return igniteEx;
        }
        finally {
            IgnitionEx.dependencyResolver(null);
        }
    }

    @Override
    protected IgniteEx startGrid(IgniteConfiguration cfg) {
        IgniteEx ignite = super.startGrid(cfg);
        if (IgnitionEx.allGrids().size() == 1) {
            this.changeClusterId(ignite, UUID.randomUUID());
        }
        return ignite;
    }
}

