/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.processors.resource.DependencyResolver;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.control.agent.configuration.AgentFeatures;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public abstract class AbstractSelfTest {
    public static final String DEFAULT_CACHE_NAME = "DEFAULT_CACHE_NAME";
    private static final ThreadFactory THREAD_FACTORY = new CustomizableThreadFactory("test-node-starter-");
    protected static final String DFLT_CONFIGURATION_PATH = "src/test/resources/ignite-cfg.xml";

    @Before
    public void initialize() throws Exception {
        System.setProperty("control.center.agent.uris", "http://localhost:3000");
    }

    @After
    public void clean() {
        System.clearProperty("control.center.agent.uris");
    }

    protected IgniteEx startGrid(IgniteConfiguration cfg) {
        try {
            return (IgniteEx)IgnitionEx.start((IgniteConfiguration)cfg, (boolean)true);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    protected IgniteEx startGrid() {
        return this.startGrid(this.getConfiguration("default"));
    }

    protected IgniteEx startClient() {
        return this.startGrid(this.getConfiguration("default").setClientMode(true));
    }

    protected IgniteEx startGrid(DependencyResolver rslvr) {
        try {
            IgnitionEx.dependencyResolver((DependencyResolver)rslvr);
            IgniteEx igniteEx = this.startGrid();
            return igniteEx;
        }
        finally {
            IgnitionEx.dependencyResolver(null);
        }
    }

    protected String instanceName(int idx) {
        return "node-" + idx;
    }

    protected IgniteEx startGrid(int idx) {
        return this.startGrid(this.getConfiguration(this.instanceName(idx)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IgniteEx startGrid(int idx, AgentFeatures feature) {
        Assert.assertTrue((boolean)AgentFeatures.featuresAsString().contains(feature.name()));
        try {
            System.setProperty(feature.name(), "false");
            IgniteEx igniteEx = this.startGrid(this.getConfiguration(this.instanceName(idx)));
            return igniteEx;
        }
        finally {
            System.clearProperty(feature.name());
        }
    }

    protected IgniteEx startGrids(int cnt) {
        IgniteEx ignite = this.startGrid(0);
        if (cnt > 1) {
            AtomicInteger idx = new AtomicInteger(1);
            CountDownLatch latch = new CountDownLatch(cnt - 1);
            DependencyResolver rslvr = IgnitionEx.dependencyResolver();
            for (int i = 1; i < cnt; ++i) {
                Thread t = THREAD_FACTORY.newThread(() -> {
                    IgnitionEx.dependencyResolver((DependencyResolver)rslvr);
                    this.startGrid(idx.getAndIncrement());
                    latch.countDown();
                });
                t.start();
            }
            try {
                latch.await(1L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ignite;
    }

    protected IgniteEx ignite(int idx) {
        return IgnitionEx.gridx((String)this.instanceName(idx));
    }

    protected void stopAllGrids() {
        IgnitionEx.stopAll((boolean)true, (ShutdownPolicy)ShutdownPolicy.IMMEDIATE);
    }

    protected void stopGrid(String instanceName) {
        IgnitionEx.stop((String)instanceName, (boolean)true, (ShutdownPolicy)ShutdownPolicy.IMMEDIATE, (boolean)true);
    }

    protected void stopGrid(int idx) {
        this.stopGrid(this.instanceName(idx));
    }

    protected void deleteDirectory(String path) {
        try {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)path, (boolean)false));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    protected void cleanPersistenceDir() {
        this.deleteDirectory("cp");
        this.deleteDirectory("db");
    }

    protected IgniteConfiguration getConfiguration(String instanceName) {
        return this.getConfiguration(DFLT_CONFIGURATION_PATH, instanceName);
    }

    protected IgniteConfiguration getConfiguration(String cfgUrl, String instanceName) {
        try {
            IgniteBiTuple cfgMap = IgnitionEx.loadConfigurations((String)cfgUrl);
            IgniteConfiguration cfg = (IgniteConfiguration)F.first((Iterable)((Iterable)cfgMap.get1()));
            cfg.setIgniteInstanceName(instanceName);
            return cfg;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    protected <K, V> CacheConfiguration<K, V> cacheConfiguration(String cacheName) {
        return new CacheConfiguration(cacheName).setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(32));
    }

    protected <K, V> IgniteCache<K, V> createCache(Ignite ignite, String cacheName) {
        return ignite.getOrCreateCache(this.cacheConfiguration(cacheName));
    }
}

