/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.aws.encryption.spi;

import com.google.common.primitives.Bytes;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.aws.encryption.spi.AwsKmsEncryptionSpi;
import org.gridgain.aws.encryption.spi.AwsKmsEncryptionSpiMocked;
import org.gridgain.control.agent.AbstractSelfTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.KeyMetadata;

public class AwsKmsEncryptionSpiTest
extends AbstractSelfTest {
    static final String MASTER_KEY_NAME = "arn:aws:kms:eu-central-1:313272427743:key/1234abcd-12ab-34cd-56ef-1234567890a1";
    static final String MASTER_KEY_NAME_2 = "arn:aws:kms:eu-central-1:313272427743:key/1234abcd-12ab-34cd-56ef-1234567890a2";
    static final String ROLE_ARN = "arn:aws:iam::313272747743:role/cmk-access-role";
    static final String EXTERNAL_ID = "766d9557-27d9-473f-a7c6-508b8f5968f3";
    final Map<SdkBytes, SdkBytes> decryptMap = new ConcurrentHashMap<SdkBytes, SdkBytes>();
    IgniteClusterEx cluster;
    KmsClient kmsClient;
    AwsKmsEncryptionSpi encSpi;

    @Before
    public void setup() throws Exception {
        this.cleanup();
        this.kmsClient = this.kmsClient();
        this.encSpi = this.spi();
    }

    @After
    public void teardown() {
        this.cleanup();
        this.decryptMap.clear();
    }

    @Test
    public void loadMasterKeyFromMetastore() {
        this.startupCluster();
        ((KmsClient)Mockito.verify((Object)this.kmsClient, (VerificationMode)Mockito.atLeastOnce())).describeKey((DescribeKeyRequest)ArgumentMatchers.argThat(req -> req.keyId().equals(MASTER_KEY_NAME)));
        this.cluster.ignite().encryption().changeMasterKey(MASTER_KEY_NAME_2).get(3L, TimeUnit.SECONDS);
        ((KmsClient)Mockito.verify((Object)this.kmsClient, (VerificationMode)Mockito.atLeastOnce())).describeKey((DescribeKeyRequest)ArgumentMatchers.argThat(req -> req.keyId().equals(MASTER_KEY_NAME_2)));
        this.stopAllGrids();
        this.kmsClient = this.kmsClient();
        this.encSpi = this.spi();
        this.startupCluster();
        ((KmsClient)Mockito.verify((Object)this.kmsClient, (VerificationMode)Mockito.never())).describeKey((DescribeKeyRequest)ArgumentMatchers.argThat(req -> req.keyId().equals(MASTER_KEY_NAME)));
        ((KmsClient)Mockito.verify((Object)this.kmsClient, (VerificationMode)Mockito.atLeastOnce())).describeKey((DescribeKeyRequest)ArgumentMatchers.argThat(req -> req.keyId().equals(MASTER_KEY_NAME_2)));
    }

    @Test
    public void startupFailedWithInvalidMasterKey() {
        ((KmsClient)Mockito.doReturn((Object)DescribeKeyResponse.builder().keyMetadata((KeyMetadata)KeyMetadata.builder().enabled(Boolean.valueOf(false)).encryptionAlgorithms(new EncryptionAlgorithmSpec[]{EncryptionAlgorithmSpec.SYMMETRIC_DEFAULT}).build()).build()).when((Object)this.kmsClient)).describeKey((DescribeKeyRequest)ArgumentMatchers.argThat(req -> req.keyId().equals(MASTER_KEY_NAME)));
        Assert.assertThrows(IgniteException.class, this::startupCluster);
    }

    @Test
    public void changeMasterKeyFailedWithInvalidKey() {
        ((KmsClient)Mockito.doReturn((Object)DescribeKeyResponse.builder().keyMetadata((KeyMetadata)KeyMetadata.builder().enabled(Boolean.valueOf(false)).encryptionAlgorithms(new EncryptionAlgorithmSpec[]{EncryptionAlgorithmSpec.SYMMETRIC_DEFAULT}).build()).build()).when((Object)this.kmsClient)).describeKey((DescribeKeyRequest)ArgumentMatchers.argThat(req -> req.keyId().equals(MASTER_KEY_NAME_2)));
        this.startupCluster();
        Assert.assertEquals((Object)MASTER_KEY_NAME, (Object)this.cluster.ignite().encryption().getMasterKeyName());
        IgniteFuture changeMasterKeyFut = this.cluster.ignite().encryption().changeMasterKey(MASTER_KEY_NAME_2);
        Assert.assertThrows(IgniteException.class, () -> {
            Void cfr_ignored_0 = (Void)changeMasterKeyFut.get(3L, TimeUnit.SECONDS);
        });
        ((KmsClient)Mockito.verify((Object)this.kmsClient, (VerificationMode)Mockito.atLeastOnce())).describeKey((DescribeKeyRequest)ArgumentMatchers.argThat(req -> req.keyId().equals(MASTER_KEY_NAME_2)));
        Assert.assertEquals((Object)MASTER_KEY_NAME, (Object)this.cluster.ignite().encryption().getMasterKeyName());
    }

    protected void cleanup() {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    private KmsClient kmsClient() {
        KmsClient kmsClient = (KmsClient)Mockito.mock(KmsClient.class);
        ((KmsClient)Mockito.doReturn((Object)DescribeKeyResponse.builder().keyMetadata((KeyMetadata)KeyMetadata.builder().enabled(Boolean.valueOf(true)).encryptionAlgorithms(new EncryptionAlgorithmSpec[]{EncryptionAlgorithmSpec.SYMMETRIC_DEFAULT}).build()).build()).when((Object)kmsClient)).describeKey((DescribeKeyRequest)ArgumentMatchers.any(DescribeKeyRequest.class));
        Mockito.when((Object)kmsClient.encrypt((EncryptRequest)ArgumentMatchers.any(EncryptRequest.class))).thenAnswer(mock -> {
            EncryptRequest req = (EncryptRequest)mock.getArgument(0, EncryptRequest.class);
            return EncryptResponse.builder().ciphertextBlob(this.encrypt(req.plaintext())).build();
        });
        Mockito.when((Object)kmsClient.decrypt((DecryptRequest)ArgumentMatchers.any(DecryptRequest.class))).thenAnswer(mock -> {
            DecryptRequest req = (DecryptRequest)mock.getArgument(0, DecryptRequest.class);
            return DecryptResponse.builder().plaintext(this.decrypt(req.ciphertextBlob())).build();
        });
        return kmsClient;
    }

    private void startupCluster() {
        IgniteConfiguration configuration = this.getConfiguration("default").setEncryptionSpi((EncryptionSpi)this.encSpi).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("encrypted-cache").setEncryptionEnabled(true)});
        IgniteEx ignite = this.startGrid(configuration);
        this.cluster = ignite.cluster();
        this.cluster.state(ClusterState.ACTIVE);
    }

    private AwsKmsEncryptionSpi spi() {
        AwsKmsEncryptionSpiMocked encSpi = new AwsKmsEncryptionSpiMocked(this.kmsClient);
        encSpi.setMasterKeyName(MASTER_KEY_NAME);
        encSpi.setRoleArn(ROLE_ARN);
        encSpi.setExternalId(EXTERNAL_ID);
        return encSpi;
    }

    private SdkBytes encrypt(SdkBytes bytes) {
        byte[] encryptedBytes = bytes.asByteArray();
        Bytes.reverse((byte[])encryptedBytes);
        SdkBytes encrypted = SdkBytes.fromByteArray((byte[])encryptedBytes);
        this.decryptMap.put(encrypted, bytes);
        return encrypted;
    }

    private SdkBytes decrypt(SdkBytes bytes) {
        return this.decryptMap.get(bytes);
    }
}

