/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

class SpringCache
implements Cache {
    private static final Object NULL = new NullValue();
    private final IgniteCache<Object, Object> cache;

    SpringCache(IgniteCache<Object, Object> cache) {
        assert (cache != null);
        this.cache = cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Object getNativeCache() {
        return this.cache;
    }

    public Cache.ValueWrapper get(Object key) {
        Object val = this.cache.get(key);
        return val != null ? SpringCache.fromValue(val) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        Object val = this.cache.get(key);
        if (NULL.equals(val)) {
            val = null;
        }
        if (val != null && type != null && !type.isInstance(val)) {
            throw new IllegalStateException("Cached value is not of required type [cacheName=" + this.cache.getName() + ", key=" + key + ", val=" + val + ", requiredType=" + type + ']');
        }
        return (T)val;
    }

    public void put(Object key, Object val) {
        if (val == null) {
            this.cache.withSkipStore().put(key, NULL);
        } else {
            this.cache.put(key, val);
        }
    }

    public <T> T get(Object key, Callable<T> valLdr) {
        throw new UnsupportedOperationException();
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object val) {
        Object old = val == null ? this.cache.withSkipStore().getAndPutIfAbsent(key, NULL) : this.cache.getAndPutIfAbsent(key, val);
        return old != null ? SpringCache.fromValue(old) : null;
    }

    public void evict(Object key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.removeAll();
    }

    private static Cache.ValueWrapper fromValue(Object val) {
        assert (val != null);
        return new SimpleValueWrapper(NULL.equals(val) ? null : val);
    }

    private static class NullValue
    implements Serializable {
        private NullValue() {
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }
    }
}

