/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.spring;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContextImpl;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class IgniteSpringHelperImpl
implements IgniteSpringHelper {
    public static final String IGNITE_XML_PATH = "META-INF/ignite.xml";
    private static final AtomicReference<String> SYS_LDR_VER = new AtomicReference<Object>(null);

    public IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(URL cfgUrl, String ... excludedProps) throws IgniteCheckedException {
        return this.loadConfigurations(cfgUrl, IgniteConfiguration.class, excludedProps);
    }

    public <T> IgniteBiTuple<Collection<T>, ? extends GridSpringResourceContext> loadConfigurations(URL cfgUrl, Class<T> cls, String ... excludedProps) throws IgniteCheckedException {
        Map cfgMap;
        ApplicationContext springCtx = IgniteSpringHelperImpl.applicationContext(cfgUrl, excludedProps);
        try {
            cfgMap = springCtx.getBeansOfType(cls);
        }
        catch (BeansException e) {
            throw new IgniteCheckedException("Failed to instantiate bean [type=" + cls + ", err=" + e.getMessage() + ']', (Throwable)e);
        }
        if (cfgMap == null || cfgMap.isEmpty()) {
            throw new IgniteCheckedException("Failed to find configuration in: " + cfgUrl);
        }
        return F.t(cfgMap.values(), (Object)new GridSpringResourceContextImpl(springCtx));
    }

    public IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(InputStream cfgStream, String ... excludedProps) throws IgniteCheckedException {
        return this.loadConfigurations(cfgStream, IgniteConfiguration.class, excludedProps);
    }

    public <T> IgniteBiTuple<Collection<T>, ? extends GridSpringResourceContext> loadConfigurations(InputStream cfgStream, Class<T> cls, String ... excludedProps) throws IgniteCheckedException {
        Map cfgMap;
        ApplicationContext springCtx = IgniteSpringHelperImpl.applicationContext(cfgStream, excludedProps);
        try {
            cfgMap = springCtx.getBeansOfType(cls);
        }
        catch (BeansException e) {
            throw new IgniteCheckedException("Failed to instantiate bean [type=" + cls + ", err=" + e.getMessage() + ']', (Throwable)e);
        }
        if (cfgMap == null || cfgMap.isEmpty()) {
            throw new IgniteCheckedException("Failed to find configuration in: " + cfgStream);
        }
        return F.t(cfgMap.values(), (Object)new GridSpringResourceContextImpl(springCtx));
    }

    public Map<Class<?>, Object> loadBeans(URL cfgUrl, Class<?> ... beanClasses) throws IgniteCheckedException {
        assert (beanClasses.length > 0);
        ApplicationContext springCtx = this.initContext(cfgUrl);
        HashMap beans = new HashMap();
        for (Class<?> cls : beanClasses) {
            beans.put(cls, IgniteSpringHelperImpl.bean((ListableBeanFactory)springCtx, cls));
        }
        return beans;
    }

    public <T> T loadBean(URL url, String beanName) throws IgniteCheckedException {
        ApplicationContext springCtx = this.initContext(url);
        try {
            return (T)springCtx.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IgniteCheckedException("Spring bean with provided name doesn't exist [url=" + url + ", beanName=" + beanName + ']');
        }
        catch (BeansException e) {
            throw new IgniteCheckedException("Failed to load Spring bean with provided name [url=" + url + ", beanName=" + beanName + ']', (Throwable)e);
        }
    }

    public Map<Class<?>, Object> loadBeans(InputStream cfgStream, Class<?> ... beanClasses) throws IgniteCheckedException {
        assert (beanClasses.length > 0);
        ApplicationContext springCtx = this.initContext(cfgStream);
        HashMap beans = new HashMap();
        for (Class<?> cls : beanClasses) {
            beans.put(cls, IgniteSpringHelperImpl.bean((ListableBeanFactory)springCtx, cls));
        }
        return beans;
    }

    public <T> T loadBean(InputStream cfgStream, String beanName) throws IgniteCheckedException {
        ApplicationContext springCtx = this.initContext(cfgStream);
        try {
            return (T)springCtx.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IgniteCheckedException("Spring bean with provided name doesn't exist , beanName=" + beanName + ']');
        }
        catch (BeansException e) {
            throw new IgniteCheckedException("Failed to load Spring bean with provided name , beanName=" + beanName + ']', (Throwable)e);
        }
    }

    public <T> T loadBeanFromAppContext(Object appContext, String beanName) throws IgniteCheckedException {
        ApplicationContext springCtx = (ApplicationContext)appContext;
        try {
            return (T)springCtx.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IgniteCheckedException("Spring bean with provided name doesn't exist , beanName=" + beanName + ']');
        }
        catch (BeansException e) {
            throw new IgniteCheckedException("Failed to load Spring bean with provided name , beanName=" + beanName + ']', (Throwable)e);
        }
    }

    private ApplicationContext initContext(InputStream stream) throws IgniteCheckedException {
        GenericApplicationContext springCtx;
        try {
            springCtx = new GenericApplicationContext();
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx);
            reader.setValidationMode(3);
            reader.loadBeanDefinitions((Resource)new InputStreamResource(stream));
            springCtx.refresh();
        }
        catch (BeansException e) {
            if (X.hasCause((Throwable)e, (Class[])new Class[]{ClassNotFoundException.class})) {
                throw new IgniteCheckedException("Failed to instantiate Spring XML application context (make sure all classes used in Spring configuration are present at CLASSPATH) ", (Throwable)e);
            }
            throw new IgniteCheckedException("Failed to instantiate Spring XML application context, err=" + e.getMessage() + ']', (Throwable)e);
        }
        return springCtx;
    }

    private ApplicationContext initContext(URL url) throws IgniteCheckedException {
        GenericApplicationContext springCtx;
        try {
            springCtx = new GenericApplicationContext();
            new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx).loadBeanDefinitions((Resource)new UrlResource(url));
            springCtx.refresh();
        }
        catch (BeansException e) {
            if (X.hasCause((Throwable)e, (Class[])new Class[]{ClassNotFoundException.class})) {
                throw new IgniteCheckedException("Failed to instantiate Spring XML application context (make sure all classes used in Spring configuration are present at CLASSPATH) [springUrl=" + url + ']', (Throwable)e);
            }
            throw new IgniteCheckedException("Failed to instantiate Spring XML application context [springUrl=" + url + ", err=" + e.getMessage() + ']', (Throwable)e);
        }
        return springCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String userVersion(ClassLoader ldr, IgniteLogger log) {
        assert (ldr != null);
        assert (log != null);
        if (ldr == U.gridClassLoader() && SYS_LDR_VER.get() != null) {
            return SYS_LDR_VER.get();
        }
        String usrVer = "0";
        InputStream in = ldr.getResourceAsStream(IGNITE_XML_PATH);
        if (in != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                U.copy((InputStream)in, (OutputStream)out);
                DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
                XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)factory);
                reader.loadBeanDefinitions((Resource)new ByteArrayResource(out.toByteArray()));
                usrVer = (String)factory.getBean("userVersion");
                usrVer = usrVer == null ? "0" : usrVer.trim();
            }
            catch (NoSuchBeanDefinitionException ignored) {
                if (log.isInfoEnabled()) {
                    log.info("User version is not explicitly defined (will use default version) [file=META-INF/ignite.xml, clsLdr=" + ldr + ']');
                }
                usrVer = "0";
            }
            catch (BeansException e) {
                U.error((IgniteLogger)log, (Object)("Failed to parse Spring XML file (will use default user version) [file=META-INF/ignite.xml, clsLdr=" + ldr + ']'), (Throwable)e);
                usrVer = "0";
            }
            catch (IOException e) {
                U.error((IgniteLogger)log, (Object)("Failed to read Spring XML file (will use default user version) [file=META-INF/ignite.xml, clsLdr=" + ldr + ']'), (Throwable)e);
                usrVer = "0";
            }
            finally {
                U.close((AutoCloseable)out, (IgniteLogger)log);
            }
        }
        if (ldr == U.gridClassLoader()) {
            SYS_LDR_VER.compareAndSet(null, usrVer);
        }
        return usrVer;
    }

    @Nullable
    private static <T> T bean(ListableBeanFactory ctx, Class<T> beanCls) {
        Map.Entry entry = F.firstEntry((Map)ctx.getBeansOfType(beanCls));
        return entry == null ? null : (T)entry.getValue();
    }

    public static ApplicationContext applicationContext(URL cfgUrl, String ... excludedProps) throws IgniteCheckedException {
        try {
            GenericApplicationContext springCtx = IgniteSpringHelperImpl.prepareSpringContext(excludedProps);
            new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx).loadBeanDefinitions((Resource)new UrlResource(cfgUrl));
            springCtx.refresh();
            return springCtx;
        }
        catch (BeansException e) {
            if (X.hasCause((Throwable)e, (Class[])new Class[]{ClassNotFoundException.class})) {
                throw new IgniteCheckedException("Failed to instantiate Spring XML application context (make sure all classes used in Spring configuration are present at CLASSPATH) [springUrl=" + cfgUrl + ']', (Throwable)e);
            }
            throw new IgniteCheckedException("Failed to instantiate Spring XML application context [springUrl=" + cfgUrl + ", err=" + e.getMessage() + ']', (Throwable)e);
        }
    }

    public static ApplicationContext applicationContext(InputStream cfgStream, String ... excludedProps) throws IgniteCheckedException {
        try {
            GenericApplicationContext springCtx = IgniteSpringHelperImpl.prepareSpringContext(excludedProps);
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx);
            reader.setValidationMode(3);
            reader.loadBeanDefinitions((Resource)new InputStreamResource(cfgStream));
            springCtx.refresh();
            return springCtx;
        }
        catch (BeansException e) {
            if (X.hasCause((Throwable)e, (Class[])new Class[]{ClassNotFoundException.class})) {
                throw new IgniteCheckedException("Failed to instantiate Spring XML application context (make sure all classes used in Spring configuration are present at CLASSPATH) ", (Throwable)e);
            }
            throw new IgniteCheckedException("Failed to instantiate Spring XML application context [err=" + e.getMessage() + ']', (Throwable)e);
        }
    }

    private static GenericApplicationContext prepareSpringContext(String ... excludedProps) {
        GenericApplicationContext springCtx = new GenericApplicationContext();
        if (excludedProps.length > 0) {
            final List<String> excludedPropsList = Arrays.asList(excludedProps);
            BeanFactoryPostProcessor postProc = new BeanFactoryPostProcessor(){

                private void processNested(BeanDefinition def) throws BeansException {
                    Iterator iterVals = def.getPropertyValues().getPropertyValueList().iterator();
                    while (iterVals.hasNext()) {
                        PropertyValue val = (PropertyValue)iterVals.next();
                        if (excludedPropsList.contains(val.getName())) {
                            iterVals.remove();
                            continue;
                        }
                        if (!(val.getValue() instanceof Iterable)) continue;
                        Iterator iterNested = ((Iterable)val.getValue()).iterator();
                        while (iterNested.hasNext()) {
                            Object item = iterNested.next();
                            if (!(item instanceof BeanDefinitionHolder)) continue;
                            BeanDefinitionHolder h = (BeanDefinitionHolder)item;
                            try {
                                if (h.getBeanDefinition().getBeanClassName() != null) {
                                    Class.forName(h.getBeanDefinition().getBeanClassName());
                                }
                                this.processNested(h.getBeanDefinition());
                            }
                            catch (ClassNotFoundException ignored) {
                                iterNested.remove();
                            }
                        }
                    }
                }

                public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                    for (String beanName : beanFactory.getBeanDefinitionNames()) {
                        try {
                            BeanDefinition def = beanFactory.getBeanDefinition(beanName);
                            if (def.getBeanClassName() != null) {
                                Class.forName(def.getBeanClassName());
                            }
                            this.processNested(def);
                        }
                        catch (ClassNotFoundException ignored) {
                            ((BeanDefinitionRegistry)beanFactory).removeBeanDefinition(beanName);
                        }
                    }
                }
            };
            springCtx.addBeanFactoryPostProcessor(postProc);
        }
        return springCtx;
    }

    static {
        Class<?> logFactoryCls = null;
        try {
            logFactoryCls = Class.forName("org.apache.commons.logging.LogFactory");
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        if (logFactoryCls != null) {
            try {
                Object factory = logFactoryCls.getMethod("getFactory", new Class[0]).invoke(null, new Object[0]);
                factory.getClass().getMethod("setAttribute", String.class, Object.class).invoke(factory, "org.apache.commons.logging.Log", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

