/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class SqlSystemViewNodes
extends SqlAbstractLocalSystemView {
    public SqlSystemViewNodes(GridKernalContext ctx) {
        super("NODES", "Topology nodes", ctx, "ID", SqlSystemViewNodes.newColumn("ID", 20), SqlSystemViewNodes.newColumn("CONSISTENT_ID"), SqlSystemViewNodes.newColumn("VERSION"), SqlSystemViewNodes.newColumn("IS_CLIENT", 1), SqlSystemViewNodes.newColumn("IS_DAEMON", 1), SqlSystemViewNodes.newColumn("NODE_ORDER", 4), SqlSystemViewNodes.newColumn("ADDRESSES"), SqlSystemViewNodes.newColumn("HOSTNAMES"));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        UUID nodeId;
        ArrayList<Row> rows = new ArrayList<Row>();
        SqlSystemViewColumnCondition idCond = this.conditionForColumn("ID", first, last);
        Collection<Object> nodes = idCond.isEquality() ? ((nodeId = SqlSystemViewNodes.uuidFromValue(idCond.valueForEquality())) == null ? Collections.emptySet() : Collections.singleton(this.ctx.discovery().node(nodeId))) : F.concat((boolean)false, (Collection)this.ctx.discovery().allNodes(), (Collection)this.ctx.discovery().daemonNodes());
        for (ClusterNode node : nodes) {
            if (node == null) continue;
            rows.add(this.createRow(ses, rows.size(), node.id(), node.consistentId(), node.version(), node.isClient(), node.isDaemon(), node.order(), node.addresses(), node.hostNames()));
        }
        return rows.iterator();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.ctx.discovery().allNodes().size() + this.ctx.discovery().daemonNodes().size();
    }
}

