/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionAware;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.database.H2RowFactory;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOnheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SearchRow;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public abstract class H2Tree
extends BPlusTree<GridH2SearchRow, GridH2Row> {
    private final H2RowFactory rowStore;
    private final int inlineSize;
    private final List<InlineIndexHelper> inlineIdxs;
    private final IndexColumn[] cols;
    private final int[] columnIds;
    private final boolean mvccEnabled;
    private final boolean pk;
    private final boolean affinityKey;
    private final String cacheName;
    private final String tblName;
    private final String idxName;
    private final Comparator<Value> comp = new Comparator<Value>(){

        @Override
        public int compare(Value o1, Value o2) {
            return H2Tree.this.compareValues(o1, o2);
        }
    };
    private final H2RowCache rowCache;
    private static final int THROTTLE_INLINE_SIZE_CALCULATION = 1000;
    private final ThreadLocal<Long> inlineSizeCalculationCntr = ThreadLocal.withInitial(() -> 0L);
    private final AtomicInteger maxCalculatedInlineSize;
    private final IgniteLogger log;
    private final boolean created;

    protected H2Tree(String name, String idxName, String cacheName, String tblName, ReuseList reuseList, int grpId, PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, H2RowFactory rowStore, long metaPageId, boolean initNew, IndexColumn[] cols, List<InlineIndexHelper> inlineIdxs, int inlineSize, AtomicInteger maxCalculatedInlineSize, boolean pk, boolean affinityKey, boolean mvccEnabled, @Nullable H2RowCache rowCache, @Nullable FailureProcessor failureProcessor, IgniteLogger log) throws IgniteCheckedException {
        super(name, grpId, pageMem, wal, globalRmvId, metaPageId, reuseList, failureProcessor);
        if (!initNew) {
            inlineSize = this.getMetaInlineSize();
        }
        this.idxName = idxName;
        this.cacheName = cacheName;
        this.tblName = tblName;
        this.inlineSize = inlineSize;
        this.maxCalculatedInlineSize = maxCalculatedInlineSize;
        this.pk = pk;
        this.affinityKey = affinityKey;
        this.mvccEnabled = mvccEnabled;
        assert (rowStore != null);
        this.rowStore = rowStore;
        this.inlineIdxs = inlineIdxs;
        this.cols = cols;
        this.columnIds = new int[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            this.columnIds[i] = cols[i].column.getColumnId();
        }
        this.setIos(H2ExtrasInnerIO.getVersions(inlineSize, mvccEnabled), H2ExtrasLeafIO.getVersions(inlineSize, mvccEnabled));
        this.rowCache = rowCache;
        this.log = log;
        this.initTree(initNew, inlineSize);
        this.created = initNew;
    }

    public GridH2Row createRowFromLink(long link) throws IgniteCheckedException {
        if (this.rowCache != null) {
            GridH2Row row = this.rowCache.get(link);
            if (row == null && (row = this.rowStore.getRow(link)) instanceof GridH2KeyValueRowOnheap) {
                this.rowCache.put((GridH2KeyValueRowOnheap)row);
            }
            return row;
        }
        return this.rowStore.getRow(link);
    }

    public GridH2Row createRowFromLink(long link, long mvccCrdVer, long mvccCntr, int mvccOpCntr) throws IgniteCheckedException {
        if (this.rowCache != null) {
            GridH2Row row = this.rowCache.get(link);
            if (row == null && (row = this.rowStore.getMvccRow(link, mvccCrdVer, mvccCntr, mvccOpCntr)) instanceof GridH2KeyValueRowOnheap) {
                this.rowCache.put((GridH2KeyValueRowOnheap)row);
            }
            return row;
        }
        return this.rowStore.getMvccRow(link, mvccCrdVer, mvccCntr, mvccOpCntr);
    }

    public GridH2Row getRow(BPlusIO<GridH2SearchRow> io, long pageAddr, int idx, Object ignore) throws IgniteCheckedException {
        return (GridH2Row)io.getLookupRow((BPlusTree)this, pageAddr, idx);
    }

    private int inlineSize() {
        return this.inlineSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMetaInlineSize() throws IgniteCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            int n;
            long pageAddr = this.readLock(this.metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong((long)this.metaPageId) + ']';
            try {
                BPlusMetaIO io = (BPlusMetaIO)BPlusMetaIO.VERSIONS.forPage(pageAddr);
                n = io.getInlineSize(pageAddr);
            }
            catch (Throwable throwable) {
                this.readUnlock(this.metaPageId, metaPage, pageAddr);
                throw throwable;
            }
            this.readUnlock(this.metaPageId, metaPage, pageAddr);
            return n;
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    protected int compare(BPlusIO<GridH2SearchRow> io, long pageAddr, int idx, GridH2SearchRow row) throws IgniteCheckedException {
        if (this.inlineSize() == 0) {
            return this.compareRows((GridH2SearchRow)this.getRow(io, pageAddr, idx), row);
        }
        int off = io.offset(idx);
        int fieldOff = 0;
        int lastIdxUsed = 0;
        for (int i = 0; i < this.inlineIdxs.size(); ++i) {
            InlineIndexHelper inlineIdx = this.inlineIdxs.get(i);
            Value v2 = row.getValue(inlineIdx.columnIndex());
            if (v2 == null) {
                return 0;
            }
            int c = inlineIdx.compare(pageAddr, off + fieldOff, this.inlineSize() - fieldOff, v2, this.comp);
            if (c == -2) break;
            ++lastIdxUsed;
            if (c != 0) {
                return c;
            }
            if ((fieldOff += inlineIdx.fullSize(pageAddr, off + fieldOff)) > this.inlineSize()) break;
        }
        if (lastIdxUsed == this.cols.length) {
            return this.mvccCompare((H2RowLinkIO)io, pageAddr, idx, row);
        }
        this.inlineSizeRecomendation((SearchRow)row);
        SearchRow rowData = (SearchRow)this.getRow(io, pageAddr, idx);
        int len = this.cols.length;
        for (int i = lastIdxUsed; i < len; ++i) {
            IndexColumn col = this.cols[i];
            int idx0 = col.column.getColumnId();
            Value v2 = row.getValue(idx0);
            if (v2 == null) {
                return this.mvccCompare((H2RowLinkIO)io, pageAddr, idx, row);
            }
            Value v1 = rowData.getValue(idx0);
            int c = this.compareValues(v1, v2);
            if (c == 0) continue;
            return InlineIndexHelper.fixSort(c, col.sortType);
        }
        return this.mvccCompare((H2RowLinkIO)io, pageAddr, idx, row);
    }

    public int compareRows(GridH2SearchRow r1, GridH2SearchRow r2) {
        assert (!this.mvccEnabled || r2.indexSearchRow() || MvccUtils.mvccVersionIsValid((long)r2.mvccCoordinatorVersion(), (long)r2.mvccCounter())) : r2;
        if (r1 == r2) {
            return 0;
        }
        int len = this.cols.length;
        for (int i = 0; i < len; ++i) {
            int idx = this.columnIds[i];
            Value v1 = r1.getValue(idx);
            Value v2 = r2.getValue(idx);
            if (v1 == null || v2 == null) {
                return this.mvccCompare(r1, r2);
            }
            int c = this.compareValues(v1, v2);
            if (c == 0) continue;
            return InlineIndexHelper.fixSort(c, this.cols[i].sortType);
        }
        return this.mvccCompare(r1, r2);
    }

    private int mvccCompare(H2RowLinkIO io, long pageAddr, int idx, GridH2SearchRow r2) {
        if (!this.mvccEnabled || r2.indexSearchRow()) {
            return 0;
        }
        long crd = io.getMvccCoordinatorVersion(pageAddr, idx);
        long cntr = io.getMvccCounter(pageAddr, idx);
        int opCntr = io.getMvccOperationCounter(pageAddr, idx);
        assert (MvccUtils.mvccVersionIsValid((long)crd, (long)cntr, (int)opCntr));
        return -MvccUtils.compare((long)crd, (long)cntr, (int)opCntr, (MvccVersionAware)r2);
    }

    private int mvccCompare(GridH2SearchRow r1, GridH2SearchRow r2) {
        long crdVer2;
        if (!this.mvccEnabled || r2.indexSearchRow()) {
            return 0;
        }
        long crdVer1 = r1.mvccCoordinatorVersion();
        int c = -Long.compare(crdVer1, crdVer2 = r2.mvccCoordinatorVersion());
        if (c != 0) {
            return c;
        }
        return -Long.compare(r1.mvccCounter(), r2.mvccCounter());
    }

    private void inlineSizeRecomendation(SearchRow row) {
        boolean throttle;
        if (!(row instanceof GridH2KeyValueRowOnheap)) {
            return;
        }
        Long invokeCnt = this.inlineSizeCalculationCntr.get();
        invokeCnt = invokeCnt + 1L;
        this.inlineSizeCalculationCntr.set(invokeCnt);
        boolean bl = throttle = invokeCnt % 1000L != 0L;
        if (throttle) {
            return;
        }
        int newSize = 0;
        ArrayList<String> colNames = new ArrayList<String>();
        Iterator<InlineIndexHelper> iterator = this.inlineIdxs.iterator();
        while (iterator.hasNext()) {
            InlineIndexHelper index;
            InlineIndexHelper idx = index = iterator.next();
            newSize += idx.inlineSizeOf(row.getValue(idx.columnIndex()));
            colNames.add(index.colName());
        }
        if (newSize > this.inlineSize()) {
            int oldSize;
            do {
                if ((oldSize = this.maxCalculatedInlineSize.get()) < newSize) continue;
                return;
            } while (!this.maxCalculatedInlineSize.compareAndSet(oldSize, newSize));
            String cols = colNames.stream().collect(Collectors.joining(", ", "(", ")"));
            String idxType = this.pk ? "PRIMARY KEY" : (this.affinityKey ? "AFFINITY KEY (implicit)" : "SECONDARY");
            String recommendation = this.pk || this.affinityKey ? "set system property IGNITE_MAX_INDEX_PAYLOAD_SIZE with recommended size (be aware it will be used by default for all indexes without explicit inline size)" : "use INLINE_SIZE option for CREATE INDEX command, QuerySqlField.inlineSize for annotated classes, or QueryIndex.inlineSize for explicit QueryEntity configuration";
            String warn = "Indexed columns of a row cannot be fully inlined into index what may lead to slowdown due to additional data page reads, increase index inline size if needed (" + recommendation + ") [cacheName=" + this.cacheName + ", tableName=" + this.tblName + ", idxName=" + this.idxName + ", idxCols=" + cols + ", idxType=" + idxType + ", curSize=" + this.inlineSize() + ", recommendedInlineSize=" + newSize + "]";
            U.warn((IgniteLogger)this.log, (Object)warn);
        }
    }

    public abstract int compareValues(Value var1, Value var2);

    public boolean created() {
        return this.created;
    }

    public String toString() {
        return S.toString(H2Tree.class, (Object)((Object)this), (String)"super", (Object)super.toString());
    }
}

