/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.tree.SearchRow;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.util.GridCommandHandlerTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GridCommandHandlerIndexingTest
extends GridCommandHandlerTest {
    private static final String CACHE_NAME = "persons-cache-vi";

    @Test
    public void testValidateIndexesNoErrors() throws Exception {
        this.prepareGridForTest();
        this.injectTestSystemOut();
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute(new String[]{"--cache", "validate_indexes", CACHE_NAME}));
        GridCommandHandlerIndexingTest.assertTrue((boolean)this.testOut.toString().contains("no issues found"));
    }

    @Test
    public void testBrokenCacheDataTreeShouldFailValidation() throws Exception {
        Ignite ignite = this.prepareGridForTest();
        this.breakCacheDataTree(ignite, CACHE_NAME, 1);
        this.injectTestSystemOut();
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute(new String[]{"--cache", "validate_indexes", CACHE_NAME, "--check-first", "10000", "--check-through", "10"}));
        GridCommandHandlerIndexingTest.assertTrue((boolean)this.testOut.toString().contains("issues found (listed above)"));
        GridCommandHandlerIndexingTest.assertTrue((boolean)this.testOut.toString().contains("Key is present in SQL index, but is missing in corresponding data page."));
    }

    @Test
    public void testBrokenSqlIndexShouldFailValidation() throws Exception {
        Ignite ignite = this.prepareGridForTest();
        this.breakSqlIndex(ignite, CACHE_NAME);
        this.injectTestSystemOut();
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute(new String[]{"--cache", "validate_indexes", CACHE_NAME}));
        GridCommandHandlerIndexingTest.assertTrue((boolean)this.testOut.toString().contains("issues found (listed above)"));
    }

    @Test
    public void testCorruptedIndexPartitionShouldFailValidation() throws Exception {
        Ignite ignite = this.prepareGridForTest();
        this.forceCheckpoint();
        File idxPath = this.indexPartition(ignite, CACHE_NAME);
        this.stopAllGrids();
        this.corruptIndexPartition(idxPath);
        this.startGrids(2);
        this.awaitPartitionMapExchange();
        this.injectTestSystemOut();
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute(new String[]{"--cache", "validate_indexes", CACHE_NAME}));
        GridCommandHandlerIndexingTest.assertTrue((boolean)this.testOut.toString().contains("issues found (listed above)"));
    }

    private Ignite prepareGridForTest() throws Exception {
        Ignite ignite = this.startGrids(2);
        ignite.cluster().active(true);
        IgniteEx client = this.startGrid("client");
        String cacheName = CACHE_NAME;
        client.getOrCreateCache(new CacheConfiguration().setName(cacheName).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setQueryEntities((Collection)F.asList((Object)this.personEntity(true, true))).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        try (IgniteDataStreamer streamer = client.dataStreamer(CACHE_NAME);){
            for (int i = 0; i < 10000; ++i) {
                streamer.addData((Object)i, (Object)new Person(rand.nextInt(), String.valueOf(rand.nextLong())));
            }
        }
        return ignite;
    }

    private File indexPartition(Ignite ig, String cacheName) {
        IgniteEx ig0 = (IgniteEx)ig;
        FilePageStoreManager pageStoreManager = (FilePageStoreManager)ig0.context().cache().context().pageStore();
        return new File(pageStoreManager.cacheWorkDir(false, cacheName), "index.bin");
    }

    private void corruptIndexPartition(File path) throws IOException {
        GridCommandHandlerIndexingTest.assertTrue((boolean)path.exists());
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        try (RandomAccessFile idx = new RandomAccessFile(path, "rw");){
            byte[] trash = new byte[1024];
            rand.nextBytes(trash);
            idx.seek(4096L);
            idx.write(trash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void breakCacheDataTree(Ignite ig, String cacheName, int partId) {
        IgniteEx ig0 = (IgniteEx)ig;
        int cacheId = CU.cacheId((String)cacheName);
        ScanQuery scanQry = new ScanQuery(partId);
        GridCacheContext ctx = ig0.context().cache().context().cacheContext(cacheId);
        String grpName = ig0.context().cache().context().cacheContext(cacheId).config().getGroupName();
        int cacheGrpId = grpName == null ? cacheName.hashCode() : grpName.hashCode();
        GridDhtLocalPartition locPart = ctx.dht().topology().localPartition(partId);
        IgniteCacheOffheapManager.CacheDataStore dataStore = ig0.context().cache().context().cache().cacheGroup(cacheGrpId).offheap().dataStore(locPart);
        Iterator it = ig.cache(cacheName).withKeepBinary().query((Query)scanQry).iterator();
        for (int i = 0; i < 5000; ++i) {
            if (it.hasNext()) {
                Cache.Entry entry = (Cache.Entry)it.next();
                if (i % 5 != 0) continue;
                GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)ig0.context().cache().context().database();
                db.checkpointReadLock();
                try {
                    IgniteCacheOffheapManager.CacheDataStore innerStore = (IgniteCacheOffheapManager.CacheDataStore)U.field((Object)dataStore, (String)"delegate");
                    Object rowStore = U.field((Object)innerStore, (String)"rowStore");
                    Object dataTree = U.field((Object)innerStore, (String)"dataTree");
                    CacheDataRow oldRow = (CacheDataRow)U.invoke(dataTree.getClass(), (Object)dataTree, (String)"remove", (Object[])new Object[]{new SearchRow(cacheId, ctx.toCacheKeyObject(entry.getKey()))});
                    if (oldRow == null) continue;
                    U.invoke(rowStore.getClass(), (Object)rowStore, (String)"removeRow", (Object[])new Object[]{oldRow.link()});
                    continue;
                }
                catch (IgniteCheckedException e) {
                    System.out.println("Failed to remove key skipping indexes: " + entry);
                    e.printStackTrace();
                    continue;
                }
                finally {
                    db.checkpointReadUnlock();
                }
            }
            System.out.println("Early exit for index corruption, keys processed: " + i);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void breakSqlIndex(Ignite ig, String cacheName) throws Exception {
        GridQueryProcessor qry = ((IgniteEx)ig).context().query();
        GridCacheContext ctx = ((IgniteEx)ig).cachex(cacheName).context();
        GridDhtLocalPartition locPart = (GridDhtLocalPartition)ctx.topology().localPartitions().get(0);
        GridIterator it = ctx.group().offheap().partitionIterator(locPart.id());
        for (int i = 0; i < 500; ++i) {
            if (!it.hasNextX()) {
                System.out.println("Early exit for index corruption, keys processed: " + i);
                break;
            }
            CacheDataRow row = (CacheDataRow)it.nextX();
            ctx.shared().database().checkpointReadLock();
            try {
                qry.remove(ctx, row);
                continue;
            }
            finally {
                ctx.shared().database().checkpointReadUnlock();
            }
        }
    }

    private QueryEntity personEntity(boolean idxName, boolean idxOrgId) {
        QueryIndex idx;
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("orgId", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>();
        if (idxName) {
            idx = new QueryIndex("name");
            idxs.add(idx);
        }
        if (idxOrgId) {
            idx = new QueryIndex("orgId");
            idxs.add(idx);
        }
        entity.setIndexes(idxs);
        return entity;
    }

    private static class Person
    implements Serializable {
        int orgId;
        String name;

        public Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }
    }
}

