/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sqltests;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.sqltests.BaseSqlTest;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReplicatedSqlTest
extends BaseSqlTest {
    private String DEP_PART_TAB = "DepartmentPart";

    @Override
    protected void setupData() {
        this.createTables("template=replicated");
        this.fillCommonData();
        this.createDepartmentTable("DepartmentPart", "template=partitioned");
        this.fillDepartmentTable("DepartmentPart");
    }

    @Test
    public void testInnerDistributedJoinReplicatedReplicated() {
        this.checkInnerDistJoinWithReplicated(this.DEP_TAB);
    }

    @Test
    public void testInnerDistJoinPartitionedReplicated() {
        this.checkInnerDistJoinWithReplicated(this.DEP_PART_TAB);
    }

    private void checkInnerDistJoinWithReplicated(String depTab) {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM " + depTab + " d INNER JOIN Address a ON d.%s = a.%s";
            BaseSqlTest.Result actIdxOnOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOnOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depIdNoidx"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depIdNoidx"), (Ignite)node);
            List exp = ReplicatedSqlTest.doInnerJoin(node.cache(ReplicatedSqlTest.cacheName(depTab)), node.cache("SQL_PUBLIC_ADDRESS"), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(dep, addr) -> ReplicatedSqlTest.sqlEq(dep.get("ID"), addr.get("DEPID")), (IgniteBiClosure & Serializable)(dep, addr) -> Arrays.asList(dep.get("ID"), dep.get("NAME"), addr.get("ADDRESS")));
            this.assertContainsEq("Distributed join on 'idx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOn.values(), exp);
            this.assertContainsEq("Distributed join on 'idx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOff.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOn.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOff.values(), exp);
        }));
    }

    @Test
    public void testMixedInnerDistJoinReplicatedPartitioned() {
        this.checkInnerDistJoinReplicatedWith(this.DEP_PART_TAB);
    }

    private void checkInnerDistJoinReplicatedWith(String depTab) {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM Address a INNER JOIN " + depTab + " d ON d.%s = a.%s";
            BaseSqlTest.Result actIdxOnOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOnOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depIdNoidx"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depIdNoidx"), (Ignite)node);
            List exp = ReplicatedSqlTest.doInnerJoin(node.cache(ReplicatedSqlTest.cacheName(depTab)), node.cache("SQL_PUBLIC_ADDRESS"), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(dep, addr) -> ReplicatedSqlTest.sqlEq(dep.get("ID"), addr.get("DEPID")), (IgniteBiClosure & Serializable)(dep, addr) -> Arrays.asList(dep.get("ID"), dep.get("NAME"), addr.get("ADDRESS")));
            this.assertContainsEq("Distributed join on 'idx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOn.values(), exp);
            this.assertContainsEq("Distributed join on 'idx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOff.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOn.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOff.values(), exp);
        }));
    }

    @Test
    public void testLeftDistributedJoinReplicatedReplicated() {
        this.checkLeftDistributedJoinWithReplicated(this.DEP_TAB);
    }

    @Test
    public void testLeftDistributedJoinPartitionedReplicated() {
        ReplicatedSqlTest.setExplain(true);
        this.checkLeftDistributedJoinWithReplicated(this.DEP_PART_TAB);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-8732")
    @Test
    public void testLeftDistributedJoinReplicatedPartitioned() {
        this.checkLeftDistributedJoinReplicatedWith(this.DEP_PART_TAB);
    }

    private void checkLeftDistributedJoinWithReplicated(String depTab) {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM " + depTab + " d LEFT JOIN Address a ON d.%s = a.%s";
            BaseSqlTest.Result actIdxOnOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOnOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depIdNoidx"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depIdNoidx"), (Ignite)node);
            List exp = ReplicatedSqlTest.doLeftJoin(node.cache(ReplicatedSqlTest.cacheName(depTab)), node.cache("SQL_PUBLIC_ADDRESS"), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(dep, addr) -> ReplicatedSqlTest.sqlEq(dep.get("ID"), addr.get("DEPID")), (IgniteBiClosure & Serializable)(dep, addr) -> Arrays.asList(dep.get("ID"), dep.get("NAME"), addr.get("ADDRESS")));
            this.assertContainsEq("Distributed join on 'idx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOn.values(), exp);
            this.assertContainsEq("Distributed join on 'idx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOff.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOn.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOff.values(), exp);
        }));
    }

    private void checkLeftDistributedJoinReplicatedWith(String depTab) {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM Address a LEFT JOIN " + depTab + " d ON d.%s = a.%s";
            BaseSqlTest.Result actIdxOnOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOnOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depIdNoidx"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depIdNoidx"), (Ignite)node);
            List exp = ReplicatedSqlTest.doLeftJoin(node.cache("SQL_PUBLIC_ADDRESS"), node.cache(ReplicatedSqlTest.cacheName(depTab)), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(addr, dep) -> ReplicatedSqlTest.sqlEq(dep.get("ID"), addr.get("DEPID")), (IgniteBiClosure & Serializable)(addr, dep) -> Arrays.asList(dep.get("ID"), dep.get("NAME"), addr.get("ADDRESS")));
            this.assertContainsEq("Distributed join on 'idx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOn.values(), exp);
            this.assertContainsEq("Distributed join on 'idx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOff.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOn.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOff.values(), exp);
        }));
    }

    @Test
    public void testRightDistributedJoinReplicatedReplicated() {
        this.checkRightDistributedJoinWithReplicated(this.DEP_TAB);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-8732")
    @Test
    public void testRightDistributedJoinPartitionedReplicated() {
        this.checkRightDistributedJoinWithReplicated(this.DEP_PART_TAB);
    }

    @Test
    public void testRightDistributedJoinReplicatedPartitioned() {
        ReplicatedSqlTest.setExplain(true);
        this.checkRightDistributedJoinReplicatedWith(this.DEP_PART_TAB);
    }

    public void checkRightDistributedJoinWithReplicated(String depTab) {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM " + depTab + " d RIGHT JOIN Address a ON d.%s = a.%s";
            BaseSqlTest.Result actIdxOnOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOnOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depIdNoidx"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depIdNoidx"), (Ignite)node);
            List exp = ReplicatedSqlTest.doRightJoin(node.cache(ReplicatedSqlTest.cacheName(depTab)), node.cache("SQL_PUBLIC_ADDRESS"), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(dep, addr) -> ReplicatedSqlTest.sqlEq(dep.get("ID"), addr.get("DEPID")), (IgniteBiClosure & Serializable)(dep, addr) -> Arrays.asList(dep.get("ID"), dep.get("NAME"), addr.get("ADDRESS")));
            this.assertContainsEq("Distributed join on 'idx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOn.values(), exp);
            this.assertContainsEq("Distributed join on 'idx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOff.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOn.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOff.values(), exp);
        }));
    }

    public void checkRightDistributedJoinReplicatedWith(String depTab) {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM Address a RIGHT JOIN " + depTab + " d ON d.%s = a.%s";
            BaseSqlTest.Result actIdxOnOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOnOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depIdNoidx"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOn = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOff = this.executeFrom(ReplicatedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depIdNoidx"), (Ignite)node);
            List exp = ReplicatedSqlTest.doRightJoin(node.cache("SQL_PUBLIC_ADDRESS"), node.cache(ReplicatedSqlTest.cacheName(depTab)), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(addr, dep) -> ReplicatedSqlTest.sqlEq(dep.get("ID"), addr.get("DEPID")), (IgniteBiClosure & Serializable)(addr, dep) -> Arrays.asList(dep.get("ID"), dep.get("NAME"), addr.get("ADDRESS")));
            this.assertContainsEq("Distributed join on 'idx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOn.values(), exp);
            this.assertContainsEq("Distributed join on 'idx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOff.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOn.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOff.values(), exp);
        }));
    }

    @Test
    public void testInnerJoinReplicatedPartitioned() {
        this.checkInnerJoinEmployeeDepartment(this.DEP_PART_TAB);
    }

    @Test
    public void testInnerJoinPartitionedReplicated() {
        this.checkInnerJoinDepartmentEmployee(this.DEP_PART_TAB);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-8732")
    @Test
    public void testLeftJoinReplicatedPartitioned() {
        this.checkLeftJoinEmployeeDepartment(this.DEP_PART_TAB);
    }

    @Test
    public void testLeftJoinPartitionedReplicated() {
        this.checkLeftJoinDepartmentEmployee(this.DEP_PART_TAB);
    }

    @Test
    public void testRightJoinReplicatedPartitioned() {
        this.checkRightJoinEmployeeDepartment(this.DEP_PART_TAB);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-8732")
    @Test
    public void testRightJoinPartitionedReplicated() {
        this.checkRightJoinDepartmentEmployee(this.DEP_PART_TAB);
    }
}

