/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.compute.ComputeTaskSessionFullSupport;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridJobExecuteResponse;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryResponse;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GridOrderedMessageCancelSelfTest
extends GridCommonAbstractTest {
    private static CountDownLatch cancelLatch;
    private static CountDownLatch resLatch;
    private static CountDownLatch finishLatch;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = GridOrderedMessageCancelSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setRebalanceMode(CacheRebalanceMode.NONE);
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setCommunicationSpi((org.apache.ignite.spi.communication.CommunicationSpi)new CommunicationSpi());
        return cfg;
    }

    protected void beforeTest() throws Exception {
        cancelLatch = new CountDownLatch(1);
        resLatch = new CountDownLatch(1);
        finishLatch = new CountDownLatch(1);
        this.startGridsMultiThreaded(2);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testTask() throws Exception {
        Map map = (Map)U.field((Object)((IgniteKernal)this.grid(0)).context().io(), (String)"msgSetMap");
        int initSize = map.size();
        ComputeTaskFuture fut = this.executeAsync(this.compute(this.grid(0).cluster().forRemotes()), Task.class, null);
        this.testMessageSet((IgniteFuture<?>)fut, initSize, map);
    }

    @Test
    public void testTaskException() throws Exception {
        Map map = (Map)U.field((Object)((IgniteKernal)this.grid(0)).context().io(), (String)"msgSetMap");
        int initSize = map.size();
        ComputeTaskFuture fut = this.executeAsync(this.compute(this.grid(0).cluster().forRemotes()), FailTask.class, null);
        this.testMessageSet((IgniteFuture<?>)fut, initSize, map);
    }

    private void testMessageSet(IgniteFuture<?> fut, int initSize, Map map) throws Exception {
        cancelLatch.await();
        GridOrderedMessageCancelSelfTest.assertTrue((boolean)fut.cancel());
        resLatch.countDown();
        GridOrderedMessageCancelSelfTest.assertTrue((boolean)U.await((CountDownLatch)finishLatch, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS));
        this.info("Map: " + map);
        GridOrderedMessageCancelSelfTest.assertEquals((int)map.size(), (int)initSize);
    }

    private void testMessageSet(IgniteInternalFuture<?> fut) throws Exception {
        cancelLatch.await();
        GridOrderedMessageCancelSelfTest.assertTrue((boolean)fut.cancel());
        resLatch.countDown();
        GridOrderedMessageCancelSelfTest.assertTrue((boolean)U.await((CountDownLatch)finishLatch, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS));
        Map map = (Map)U.field((Object)((IgniteKernal)this.grid(0)).context().io(), (String)"msgSetMap");
        this.info("Map: " + map);
        GridOrderedMessageCancelSelfTest.assertTrue((boolean)map.isEmpty());
    }

    @ComputeTaskSessionFullSupport
    private static class FailTask
    extends ComputeTaskSplitAdapter<Void, Void> {
        private FailTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, Void arg) {
            return Collections.singleton(new ComputeJobAdapter(){

                @Nullable
                public Object execute() {
                    throw new IgniteException("Task failed.");
                }
            });
        }

        @Nullable
        public Void reduce(List<ComputeJobResult> results) {
            return null;
        }
    }

    @ComputeTaskSessionFullSupport
    private static class Task
    extends ComputeTaskSplitAdapter<Void, Void> {
        private Task() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, Void arg) {
            return Collections.singleton(new ComputeJobAdapter(){

                @Nullable
                public Object execute() {
                    return null;
                }
            });
        }

        @Nullable
        public Void reduce(List<ComputeJobResult> results) {
            return null;
        }
    }

    private static class CommunicationSpi
    extends TcpCommunicationSpi {
        private CommunicationSpi() {
        }

        protected void notifyListener(UUID sndId, Message msg, IgniteRunnable msgC) {
            try {
                boolean wait;
                GridIoMessage ioMsg = (GridIoMessage)msg;
                boolean bl = wait = ioMsg.message() instanceof GridCacheQueryResponse || ioMsg.message() instanceof GridJobExecuteResponse;
                if (wait) {
                    cancelLatch.countDown();
                    Assert.assertTrue((boolean)U.await((CountDownLatch)resLatch, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS));
                }
                super.notifyListener(sndId, msg, msgC);
                if (wait) {
                    finishLatch.countDown();
                }
            }
            catch (Exception e) {
                Assert.fail((String)("Unexpected error: " + e));
            }
        }
    }
}

