/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConnectorConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlConnectorConfigurationValidationSelfTest
extends GridCommonAbstractTest {
    private static final AtomicInteger NODE_IDX_GEN = new AtomicInteger();
    private static final String CACHE_NAME = "CACHE";

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testDefault() throws Exception {
        this.check(new SqlConnectorConfiguration(), true);
        this.assertJdbc(null, 10800);
    }

    @Test
    public void testHost() throws Exception {
        this.check(new SqlConnectorConfiguration().setHost("126.0.0.1"), false);
        this.check(new SqlConnectorConfiguration().setHost("127.0.0.1"), true);
        this.assertJdbc("127.0.0.1", 10800);
        this.check(new SqlConnectorConfiguration().setHost("0.0.0.0"), true);
        this.assertJdbc("0.0.0.0", 10801);
    }

    @Test
    public void testPort() throws Exception {
        this.check(new SqlConnectorConfiguration().setPort(-1), false);
        this.check(new SqlConnectorConfiguration().setPort(0), false);
        this.check(new SqlConnectorConfiguration().setPort(512), false);
        this.check(new SqlConnectorConfiguration().setPort(65536), false);
        this.check(new SqlConnectorConfiguration().setPort(10800), true);
        this.assertJdbc(null, 10800);
        this.check(new SqlConnectorConfiguration().setPort(11000), true);
        this.assertJdbc(null, 11000);
    }

    @Test
    public void testPortRange() throws Exception {
        this.check(new SqlConnectorConfiguration().setPortRange(-1), false);
        this.check(new SqlConnectorConfiguration().setPortRange(0), true);
        this.assertJdbc(null, 10800);
        this.check(new SqlConnectorConfiguration().setPortRange(10), true);
        this.assertJdbc(null, 10801);
    }

    @Test
    public void testSocketBuffers() throws Exception {
        this.check(new SqlConnectorConfiguration().setSocketSendBufferSize(-4096), false);
        this.check(new SqlConnectorConfiguration().setSocketReceiveBufferSize(-4096), false);
        this.check(new SqlConnectorConfiguration().setSocketSendBufferSize(4096), true);
        this.assertJdbc(null, 10800);
        this.check(new SqlConnectorConfiguration().setSocketReceiveBufferSize(4096), true);
        this.assertJdbc(null, 10801);
    }

    @Test
    public void testMaxOpenCusrorsPerConnection() throws Exception {
        this.check(new SqlConnectorConfiguration().setMaxOpenCursorsPerConnection(-1), false);
        this.check(new SqlConnectorConfiguration().setMaxOpenCursorsPerConnection(0), true);
        this.assertJdbc(null, 10800);
        this.check(new SqlConnectorConfiguration().setMaxOpenCursorsPerConnection(100), true);
        this.assertJdbc(null, 10801);
    }

    @Test
    public void testThreadPoolSize() throws Exception {
        this.check(new SqlConnectorConfiguration().setThreadPoolSize(0), false);
        this.check(new SqlConnectorConfiguration().setThreadPoolSize(-1), false);
        this.check(new SqlConnectorConfiguration().setThreadPoolSize(4), true);
        this.assertJdbc(null, 10800);
    }

    private void check(SqlConnectorConfiguration sqlCfg, boolean success) throws Exception {
        final IgniteConfiguration cfg = super.getConfiguration();
        cfg.setIgniteInstanceName(SqlConnectorConfigurationValidationSelfTest.class.getName() + "-" + NODE_IDX_GEN.incrementAndGet());
        cfg.setLocalHost("127.0.0.1");
        cfg.setSqlConnectorConfiguration(sqlCfg);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        TcpDiscoverySpi spi = new TcpDiscoverySpi();
        spi.setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder(true));
        cfg.setDiscoverySpi((DiscoverySpi)spi);
        CacheConfiguration ccfg = new CacheConfiguration(CACHE_NAME).setIndexedTypes(new Class[]{SqlConnectorKey.class, SqlConnectorValue.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        if (success) {
            this.startGrid(cfg.getIgniteInstanceName(), cfg);
        } else {
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlConnectorConfigurationValidationSelfTest.this.startGrid(cfg.getIgniteInstanceName(), cfg);
                    return null;
                }
            }, IgniteException.class, null);
        }
    }

    private void assertJdbc(@Nullable String host, int port) throws Exception {
        if (host == null) {
            host = "127.0.0.1";
        }
        String connStr = "jdbc:ignite:thin://" + host + ":" + port;
        try (Connection conn = DriverManager.getConnection(connStr);){
            conn.setSchema(CACHE_NAME);
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery("SELECT 1");
                SqlConnectorConfigurationValidationSelfTest.assertTrue((boolean)rs.next());
                TestCase.assertEquals((int)1, (int)rs.getInt(1));
            }
        }
    }

    private static class SqlConnectorValue {
        @QuerySqlField
        public int val;

        private SqlConnectorValue() {
        }
    }

    private static class SqlConnectorKey {
        @QuerySqlField
        public int key;

        private SqlConnectorKey() {
        }
    }
}

