/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.JoinSqlTestHelper;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorker;
import org.apache.ignite.internal.processors.query.h2.twostep.MapReservationKey;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RetryCauseMessageSelfTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 2;
    private static final String ORG_SQL = "select * from Organization";
    private static final String ORG = "org";
    private IgniteCache<String, JoinSqlTestHelper.Person> personCache;
    private IgniteCache<String, JoinSqlTestHelper.Organization> orgCache;
    private IgniteH2Indexing h2Idx;

    protected long getTestTimeout() {
        return 600000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynthCacheWasNotFoundMessage() {
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(null){

            @Override
            public void onMessage(UUID nodeId, Object msg) {
                if (GridH2QueryRequest.class.isAssignableFrom(msg.getClass())) {
                    GridH2QueryRequest qryReq = (GridH2QueryRequest)msg;
                    qryReq.caches().add(Integer.MAX_VALUE);
                    this.startedExecutor.onMessage(nodeId, msg);
                    qryReq.caches().remove(qryReq.caches().size() - 1);
                } else {
                    this.startedExecutor.onMessage(nodeId, msg);
                }
            }
        }.insertRealExecutor(mapQryExec)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            this.personCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Failed to reserve partitions for query (cache is not found on local node) ["));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrpReservationFailureMessage() {
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        final ConcurrentMap reservations = (ConcurrentMap)GridTestUtils.getFieldValue((Object)mapQryExec, GridMapQueryExecutor.class, (String)"reservations");
        GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(null){

            @Override
            public void onMessage(UUID nodeId, Object msg) {
                if (GridH2QueryRequest.class.isAssignableFrom(msg.getClass())) {
                    MapReservationKey grpKey = new MapReservationKey(RetryCauseMessageSelfTest.ORG, null);
                    reservations.put(grpKey, new GridReservable(){

                        public boolean reserve() {
                            return false;
                        }

                        public void release() {
                        }
                    });
                }
                this.startedExecutor.onMessage(nodeId, msg);
            }
        }.insertRealExecutor(mapQryExec)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            this.personCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((boolean)e.getMessage().contains("Failed to reserve partitions for query (group reservation failed) ["));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-7039")
    @Test
    public void testReplicatedCacheReserveFailureMessage() {
        RetryCauseMessageSelfTest.fail((String)"https://issues.apache.org/jira/browse/IGNITE-7039");
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        final GridKernalContext ctx = (GridKernalContext)GridTestUtils.getFieldValue((Object)mapQryExec, GridMapQueryExecutor.class, (String)"ctx");
        GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(null){

            @Override
            public void onMessage(UUID nodeId, Object msg) {
                if (GridH2QueryRequest.class.isAssignableFrom(msg.getClass())) {
                    GridH2QueryRequest qryReq = (GridH2QueryRequest)msg;
                    GridCacheContext cctx = ctx.cache().context().cacheContext(((Integer)qryReq.caches().get(0)).intValue());
                    GridDhtLocalPartition part = cctx.topology().localPartition(0, AffinityTopologyVersion.NONE, false);
                    AtomicLong aState = (AtomicLong)GridTestUtils.getFieldValue((Object)part, GridDhtLocalPartition.class, (String)"state");
                    long stateVal = aState.getAndSet(2L);
                    this.startedExecutor.onMessage(nodeId, msg);
                    aState.getAndSet(stateVal);
                } else {
                    this.startedExecutor.onMessage(nodeId, msg);
                }
            }
        }.insertRealExecutor(mapQryExec)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Organization.class, ORG_SQL);
        qry.setDistributedJoins(true);
        try {
            this.orgCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((boolean)e.getMessage().contains("Failed to reserve partitions for query (partition of REPLICATED cache is not in OWNING state) ["));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionedCacheReserveFailureMessage() {
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        final GridKernalContext ctx = (GridKernalContext)GridTestUtils.getFieldValue((Object)mapQryExec, GridMapQueryExecutor.class, (String)"ctx");
        GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(null){

            @Override
            public void onMessage(UUID nodeId, Object msg) {
                if (GridH2QueryRequest.class.isAssignableFrom(msg.getClass())) {
                    GridH2QueryRequest qryReq = (GridH2QueryRequest)msg;
                    GridCacheContext cctx = ctx.cache().context().cacheContext(((Integer)qryReq.caches().get(0)).intValue());
                    GridDhtLocalPartition part = cctx.topology().localPartition(0, AffinityTopologyVersion.NONE, false);
                    AtomicLong aState = (AtomicLong)GridTestUtils.getFieldValue((Object)part, GridDhtLocalPartition.class, (String)"state");
                    long stateVal = aState.getAndSet(2L);
                    this.startedExecutor.onMessage(nodeId, msg);
                    aState.getAndSet(stateVal);
                } else {
                    this.startedExecutor.onMessage(nodeId, msg);
                }
            }
        }.insertRealExecutor(mapQryExec)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            this.personCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((boolean)e.getMessage().contains("Failed to reserve partitions for query (partition of PARTITIONED cache is not found or not in OWNING state) "));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonCollocatedFailureMessage() {
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        final ConcurrentMap reservations = (ConcurrentMap)GridTestUtils.getFieldValue((Object)mapQryExec, GridMapQueryExecutor.class, (String)"reservations");
        GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(null){

            @Override
            public void onMessage(UUID nodeId, Object msg) {
                if (GridH2QueryRequest.class.isAssignableFrom(msg.getClass())) {
                    MapReservationKey grpKey = new MapReservationKey(RetryCauseMessageSelfTest.ORG, null);
                    reservations.put(grpKey, new GridReservable(){

                        public boolean reserve() {
                            throw new GridH2RetryException("test retry exception");
                        }

                        public void release() {
                        }
                    });
                }
                this.startedExecutor.onMessage(nodeId, msg);
            }
        }.insertRealExecutor(mapQryExec)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            this.personCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((boolean)e.getMessage().contains("Failed to execute non-collocated query (will retry) ["));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi(){

            public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
                assert (msg != null);
                super.sendMessage(node, msg, ackC);
            }
        });
        return cfg;
    }

    protected void beforeTest() throws Exception {
        System.setProperty("IGNITE_SQL_RETRY_TIMEOUT", "5000");
        Ignite ignite = this.startGridsMultiThreaded(2, false);
        GridQueryProcessor qryProc = this.grid(ignite.name()).context().query();
        this.h2Idx = (IgniteH2Indexing)GridTestUtils.getFieldValue((Object)qryProc, GridQueryProcessor.class, (String)"idx");
        this.personCache = this.ignite(0).getOrCreateCache(new CacheConfiguration("pers").setIndexedTypes(new Class[]{String.class, JoinSqlTestHelper.Person.class}));
        this.orgCache = this.ignite(0).getOrCreateCache(new CacheConfiguration(ORG).setCacheMode(CacheMode.REPLICATED).setIndexedTypes(new Class[]{String.class, JoinSqlTestHelper.Organization.class}));
        this.awaitPartitionMapExchange();
        JoinSqlTestHelper.populateDataIntoOrg(this.orgCache);
        JoinSqlTestHelper.populateDataIntoPerson(this.personCache);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    private static abstract class MockGridMapQueryExecutor
    extends GridMapQueryExecutor {
        GridMapQueryExecutor startedExecutor;

        MockGridMapQueryExecutor insertRealExecutor(GridMapQueryExecutor realExecutor) {
            this.startedExecutor = realExecutor;
            return this;
        }

        MockGridMapQueryExecutor(GridSpinBusyLock busyLock) {
            super(busyLock);
        }

        public void onMessage(UUID nodeId, Object msg) {
            this.startedExecutor.onMessage(nodeId, msg);
        }

        public void cancelLazyWorkers() {
            this.startedExecutor.cancelLazyWorkers();
        }

        GridSpinBusyLock busyLock() {
            return this.startedExecutor.busyLock();
        }

        public void onCacheStop(String cacheName) {
            this.startedExecutor.onCacheStop(cacheName);
        }

        public void stopAndUnregisterCurrentLazyWorker() {
            this.startedExecutor.stopAndUnregisterCurrentLazyWorker();
        }

        public void unregisterLazyWorker(MapQueryLazyWorker worker) {
            this.startedExecutor.unregisterLazyWorker(worker);
        }

        public int registeredLazyWorkers() {
            return this.startedExecutor.registeredLazyWorkers();
        }
    }
}

