/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.List;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.JoinSqlTestHelper;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class NonCollocatedRetryMessageSelfTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 3;
    private static final String ORG = "org";
    private IgniteCache<String, JoinSqlTestHelper.Person> personCache;

    @Test
    public void testNonCollocatedRetryMessage() {
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            List prsns = this.personCache.query((Query)qry).getAll();
            NonCollocatedRetryMessageSelfTest.fail((String)("No CacheException emitted. Collection size=" + prsns.size()));
        }
        catch (CacheException e) {
            NonCollocatedRetryMessageSelfTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Failed to execute non-collocated query"));
        }
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi(){
            volatile long reqId = -1L;

            public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
                GridIoMessage gridMsg;
                assert (msg != null);
                if (GridIoMessage.class.isAssignableFrom(msg.getClass()) && GridH2QueryRequest.class.isAssignableFrom((gridMsg = (GridIoMessage)msg).message().getClass())) {
                    GridH2QueryRequest req = (GridH2QueryRequest)gridMsg.message();
                    if (this.reqId < 0L) {
                        this.reqId = req.requestId();
                        String shutName = NonCollocatedRetryMessageSelfTest.this.getTestIgniteInstanceName(1);
                        NonCollocatedRetryMessageSelfTest.this.stopGrid(shutName, true, false);
                    } else if (this.reqId != req.requestId()) {
                        try {
                            U.sleep((long)IgniteSystemProperties.getLong((String)"IGNITE_SQL_RETRY_TIMEOUT", (long)30000L));
                        }
                        catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                            // empty catch block
                        }
                    }
                }
                super.sendMessage(node, msg, ackC);
            }
        });
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi(){

            public long getNodesJoined() {
                return this.stats.joinedNodesCount();
            }
        });
        return cfg;
    }

    protected void beforeTest() throws Exception {
        System.setProperty("IGNITE_SQL_RETRY_TIMEOUT", "5000");
        this.startGridsMultiThreaded(3, false);
        this.personCache = this.ignite(0).getOrCreateCache(new CacheConfiguration("pers").setBackups(1).setIndexedTypes(new Class[]{String.class, JoinSqlTestHelper.Person.class}));
        IgniteCache orgCache = this.ignite(0).getOrCreateCache(new CacheConfiguration(ORG).setBackups(1).setIndexedTypes(new Class[]{String.class, JoinSqlTestHelper.Organization.class}));
        this.awaitPartitionMapExchange();
        JoinSqlTestHelper.populateDataIntoOrg((IgniteCache<String, JoinSqlTestHelper.Organization>)orgCache);
        JoinSqlTestHelper.populateDataIntoPerson(this.personCache);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }
}

