/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.annotations.QuerySqlField;

public class JoinSqlTestHelper {
    private static final int ORG_COUNT = 100;
    private static final int PERSON_PER_ORG_COUNT = 10;
    static final String JOIN_SQL = "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)";

    static void populateDataIntoOrg(IgniteCache<String, Organization> cache) {
        for (int i = 0; i < 100; ++i) {
            Organization org = new Organization();
            org.setId("org" + i);
            org.setName("Organization #" + i);
            cache.put((Object)org.getId(), (Object)org);
        }
    }

    static void populateDataIntoPerson(IgniteCache<String, Person> cache) {
        int personId = 0;
        for (int i = 0; i < 100; ++i) {
            Organization org = new Organization();
            org.setId("org" + i);
            org.setName("Organization #" + i);
            for (int j = 0; j < 10; ++j) {
                Person prsn = new Person();
                prsn.setId("pers" + personId);
                prsn.setOrgId(org.getId());
                prsn.setName("Person name #" + personId);
                cache.put((Object)prsn.getId(), (Object)prsn);
                ++personId;
            }
        }
    }

    public static class Organization {
        @QuerySqlField(index=true)
        private String id;
        @QuerySqlField(index=true)
        private String name;

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Person {
        @QuerySqlField(index=true)
        private String id;
        @QuerySqlField(index=true)
        private String orgId;
        @QuerySqlField(index=true)
        private String name;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getOrgId() {
            return this.orgId;
        }

        public void setOrgId(String orgId) {
            this.orgId = orgId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

