/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.JoinSqlTestHelper;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DisappearedCacheWasNotFoundMessageSelfTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 2;
    private static final String ORG = "org";
    private IgniteCache<String, JoinSqlTestHelper.Person> personCache;
    private IgniteCache<String, JoinSqlTestHelper.Organization> orgCache;

    @Test
    public void testDisappearedCacheWasNotFoundMessage() {
        block2: {
            SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
            qry.setDistributedJoins(true);
            try {
                this.personCache.query((Query)qry).getAll();
                DisappearedCacheWasNotFoundMessageSelfTest.fail((String)"No CacheException emitted.");
            }
            catch (CacheException e) {
                boolean exp = e.getMessage().contains("Cache not found on local node (was concurrently destroyed?)");
                if (exp) break block2;
                throw e;
            }
        }
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(LOCAL_IP_FINDER));
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi(){

            public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
                GridIoMessage gridMsg;
                assert (msg != null);
                if (GridIoMessage.class.isAssignableFrom(msg.getClass()) && GridH2QueryRequest.class.isAssignableFrom((gridMsg = (GridIoMessage)msg).message().getClass())) {
                    GridH2QueryRequest req = (GridH2QueryRequest)gridMsg.message();
                    req.requestId();
                    DisappearedCacheWasNotFoundMessageSelfTest.this.orgCache.destroy();
                }
                super.sendMessage(node, msg, ackC);
            }
        });
        return cfg;
    }

    protected void beforeTest() throws Exception {
        System.setProperty("IGNITE_SQL_RETRY_TIMEOUT", "5000");
        this.startGridsMultiThreaded(2, false);
        this.personCache = this.ignite(0).getOrCreateCache(new CacheConfiguration("pers").setIndexedTypes(new Class[]{String.class, JoinSqlTestHelper.Person.class}));
        this.orgCache = this.ignite(0).getOrCreateCache(new CacheConfiguration(ORG).setCacheMode(CacheMode.REPLICATED).setIndexedTypes(new Class[]{String.class, JoinSqlTestHelper.Organization.class}));
        this.awaitPartitionMapExchange();
        JoinSqlTestHelper.populateDataIntoOrg(this.orgCache);
        JoinSqlTestHelper.populateDataIntoPerson(this.personCache);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }
}

