/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractH2CompareQueryTest
extends GridCommonAbstractTest {
    protected static Ignite ignite;
    protected static final int SRVS = 4;
    protected static Connection conn;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        c.setMarshaller((Marshaller)new BinaryMarshaller());
        return c;
    }

    protected CacheConfiguration cacheConfiguration(String name, CacheMode mode, Class<?> clsK, Class<?> clsV) {
        CacheConfiguration cc = AbstractH2CompareQueryTest.defaultCacheConfiguration();
        cc.setName(name);
        cc.setCacheMode(mode);
        cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cc.setQueryEntities(Collections.singleton(new QueryEntity(clsK, clsV)));
        return cc;
    }

    protected abstract void createCaches();

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        ignite = this.startGrids(4);
        this.createCaches();
        this.awaitPartitionMapExchange();
        conn = this.openH2Connection(false);
        this.initializeH2Schema();
        this.initCacheAndDbData();
        this.checkAllDataEquals();
    }

    protected void afterTestsStopped() throws Exception {
        Statement st = conn.createStatement();
        st.execute("DROP ALL OBJECTS");
        conn.close();
        ignite = null;
    }

    protected abstract void initCacheAndDbData() throws Exception;

    protected abstract void checkAllDataEquals() throws Exception;

    protected Statement initializeH2Schema() throws SQLException {
        return conn.createStatement();
    }

    protected Connection openH2Connection(boolean autocommit) throws SQLException {
        System.setProperty("h2.serializeJavaObject", "false");
        String dbName = "test";
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:" + dbName + ";DB_CLOSE_DELAY=-1");
        conn.setAutoCommit(autocommit);
        return conn;
    }

    protected final List<List<?>> compareQueryRes0(IgniteCache cache, String sql, Object ... args) throws SQLException {
        return AbstractH2CompareQueryTest.compareQueryRes0(cache, sql, args, Ordering.RANDOM);
    }

    protected final List<List<?>> compareOrderedQueryRes0(IgniteCache cache, String sql, Object ... args) throws SQLException {
        return AbstractH2CompareQueryTest.compareQueryRes0(cache, sql, args, Ordering.ORDERED);
    }

    protected static List<List<?>> compareQueryRes0(IgniteCache cache, String sql, @Nullable Object[] args, Ordering ordering) throws SQLException {
        return AbstractH2CompareQueryTest.compareQueryRes0(cache, sql, false, args, ordering);
    }

    protected static List<List<?>> compareQueryRes0(IgniteCache cache, String sql, boolean distrib, @Nullable Object[] args, Ordering ordering) throws SQLException {
        return AbstractH2CompareQueryTest.compareQueryRes0(cache, sql, distrib, false, args, ordering);
    }

    protected static List<List<?>> compareQueryRes0(IgniteCache cache, String sql, boolean distrib, boolean enforceJoinOrder, @Nullable Object[] args, Ordering ordering) throws SQLException {
        if (args == null) {
            args = new Object[]{null};
        }
        List<List<?>> h2Res = AbstractH2CompareQueryTest.executeH2Query(sql, args);
        List cacheRes = cache.query(new SqlFieldsQuery(sql).setArgs(args).setDistributedJoins(distrib).setEnforceJoinOrder(enforceJoinOrder)).getAll();
        AbstractH2CompareQueryTest.assertRsEquals(h2Res, cacheRes, ordering);
        return h2Res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<List<?>> executeH2Query(String sql, Object[] args) throws SQLException {
        ArrayList res = new ArrayList();
        ResultSet rs = null;
        try (PreparedStatement st = conn.prepareStatement(sql);){
            for (int idx = 0; idx < args.length; ++idx) {
                st.setObject(idx + 1, args[idx]);
            }
            rs = st.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int colCnt = meta.getColumnCount();
            while (rs.next()) {
                ArrayList<Object> row = new ArrayList<Object>(colCnt);
                for (int i = 1; i <= colCnt; ++i) {
                    row.add(rs.getObject(i));
                }
                res.add(row);
            }
        }
        catch (Throwable throwable) {
            U.closeQuiet(rs);
            throw throwable;
        }
        U.closeQuiet((AutoCloseable)rs);
        return res;
    }

    private static void assertRsEquals(List<List<?>> rs1, List<List<?>> rs2, Ordering ordering) {
        AbstractH2CompareQueryTest.assertEquals((String)"Rows count has to be equal.", (int)rs1.size(), (int)rs2.size());
        block0 : switch (ordering) {
            case ORDERED: {
                for (int rowNum = 0; rowNum < rs1.size(); ++rowNum) {
                    List<?> row1 = rs1.get(rowNum);
                    List<?> row2 = rs2.get(rowNum);
                    AbstractH2CompareQueryTest.assertEquals((String)"Columns count have to be equal.", (int)row1.size(), (int)row2.size());
                    for (int colNum = 0; colNum < row1.size(); ++colNum) {
                        AbstractH2CompareQueryTest.assertEquals((String)("Row=" + rowNum + ", column=" + colNum), row1.get(colNum), row2.get(colNum));
                    }
                }
                break;
            }
            case RANDOM: {
                TreeMap<String, Integer> rowsWithCnt1 = AbstractH2CompareQueryTest.extractUniqueRowsWithCounts(rs1);
                TreeMap<String, Integer> rowsWithCnt2 = AbstractH2CompareQueryTest.extractUniqueRowsWithCounts(rs2);
                AbstractH2CompareQueryTest.assertEquals((String)"Unique rows count has to be equal.", (int)rowsWithCnt1.size(), (int)rowsWithCnt2.size());
                Iterator<Map.Entry<String, Integer>> iter1 = rowsWithCnt1.entrySet().iterator();
                Iterator<Map.Entry<String, Integer>> iter2 = rowsWithCnt2.entrySet().iterator();
                int uSize = rowsWithCnt1.size();
                int i = 0;
                while (true) {
                    if (!iter1.hasNext()) {
                        AbstractH2CompareQueryTest.assertFalse((boolean)iter2.hasNext());
                        break block0;
                    }
                    AbstractH2CompareQueryTest.assertTrue((boolean)iter2.hasNext());
                    Map.Entry<String, Integer> e1 = iter1.next();
                    Map.Entry<String, Integer> e2 = iter2.next();
                    AbstractH2CompareQueryTest.assertEquals((String)("Key " + i + " of " + uSize), (String)e1.getKey(), (String)e2.getKey());
                    AbstractH2CompareQueryTest.assertEquals((String)("Count " + i + " of " + uSize), (Object)e1.getValue(), (Object)e2.getValue());
                    ++i;
                }
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static TreeMap<String, Integer> extractUniqueRowsWithCounts(Iterable<List<?>> rs) {
        TreeMap<String, Integer> res = new TreeMap<String, Integer>();
        for (List<?> row : rs) {
            String rowStr = row.toString();
            Integer cnt = res.get(rowStr);
            if (cnt == null) {
                cnt = 0;
            }
            res.put(rowStr, cnt + 1);
        }
        return res;
    }

    protected static enum Ordering {
        RANDOM,
        ORDERED;

    }
}

