/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.io.Charsets;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.unsafe.UnsafeMemoryProvider;
import org.apache.ignite.internal.pagemem.impl.PageMemoryNoStoreImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.springframework.util.SerializationUtils;

@RunWith(value=JUnit4.class)
public class InlineIndexHelperTest
extends GridCommonAbstractTest {
    private static final int CACHE_ID = 42;
    private static final int PAGE_SIZE = 1024;
    private static final long MB = 1024L;
    private static final Comparator ALWAYS_FAILS_COMPARATOR = new AlwaysFailsComparator();

    @Test
    public void testConvert() {
        byte[] bytes = InlineIndexHelper.trimUTF8((byte[])"00\u20ac\u20ac".getBytes(Charsets.UTF_8), (int)7);
        InlineIndexHelperTest.assertEquals((int)5, (int)bytes.length);
        String s = new String(bytes);
        InlineIndexHelperTest.assertEquals((int)3, (int)s.length());
        bytes = InlineIndexHelper.trimUTF8((byte[])"aaaaaa".getBytes(Charsets.UTF_8), (int)4);
        InlineIndexHelperTest.assertEquals((int)4, (int)bytes.length);
    }

    @Test
    public void testCompare1bytes() throws Exception {
        int maxSize = 5;
        InlineIndexHelperTest.assertEquals((int)0, (int)this.putAndCompare("aa", "aa", maxSize));
        InlineIndexHelperTest.assertEquals((int)-1, (int)this.putAndCompare("aa", "bb", maxSize));
        InlineIndexHelperTest.assertEquals((int)-1, (int)this.putAndCompare("aaa", "bbb", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("bbb", "aaa", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("aaa", "aa", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("aaa", "a", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("aaa", "aaa", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("aaa", "aab", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("aab", "aaa", maxSize));
    }

    @Test
    public void testCompare2bytes() throws Exception {
        int maxSize = 7;
        InlineIndexHelperTest.assertEquals((int)0, (int)this.putAndCompare("\u00a1\u00a1", "\u00a1\u00a1", maxSize));
        InlineIndexHelperTest.assertEquals((int)-1, (int)this.putAndCompare("\u00a1\u00a1", "\u00a2\u00a2", maxSize));
        InlineIndexHelperTest.assertEquals((int)-1, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a2\u00a2\u00a2", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\u00a2\u00a2\u00a2", "\u00a1\u00a1\u00a1", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a1\u00a1", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a1", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a1\u00a1\u00a1", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a1\u00a1\u00a2", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\u00a1\u00a1\u00a2", "\u00a1\u00a1\u00a1", maxSize));
    }

    @Test
    public void testCompare3bytes() throws Exception {
        int maxSize = 9;
        InlineIndexHelperTest.assertEquals((int)0, (int)this.putAndCompare("\u0904\u0904", "\u0904\u0904", maxSize));
        InlineIndexHelperTest.assertEquals((int)-1, (int)this.putAndCompare("\u0904\u0904", "\u0905\u0905", maxSize));
        InlineIndexHelperTest.assertEquals((int)-1, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0905\u0905\u0905", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\u0905\u0905\u0905", "\u0904\u0904\u0904", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0904\u0904", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0904", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0904\u0904\u0904", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0904\u0904\u0905", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\u0904\u0904\u0905", "\u0904\u0904\u0904", maxSize));
    }

    @Test
    public void testCompare4bytes() throws Exception {
        int maxSize = 11;
        InlineIndexHelperTest.assertEquals((int)0, (int)this.putAndCompare("\ud802\udd20\ud802\udd20", "\ud802\udd20\ud802\udd20", maxSize));
        InlineIndexHelperTest.assertEquals((int)-1, (int)this.putAndCompare("\ud802\udd20\ud802\udd20", "\ud802\udd21\ud802\udd21", maxSize));
        InlineIndexHelperTest.assertEquals((int)-1, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd21\ud802\udd21\ud802\udd21", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\ud802\udd21\ud802\udd21\ud802\udd21", "\ud802\udd20\ud802\udd20\ud802\udd20", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd20\ud802\udd20", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd20", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd20\ud802\udd20\ud802\udd20", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd20\ud802\udd20\ud802\udd21", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd21", "\ud802\udd20\ud802\udd20\ud802\udd20", maxSize));
    }

    @Test
    public void testCompareMixed() throws Exception {
        int maxSize = 11;
        InlineIndexHelperTest.assertEquals((int)0, (int)this.putAndCompare("\ud802\udd20\u0904", "\ud802\udd20\u0904", maxSize));
        InlineIndexHelperTest.assertEquals((int)-1, (int)this.putAndCompare("\ud802\udd20\u0904", "\ud802\udd20\u0905", maxSize));
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("\u0905\ud802\udd20", "\u0904\ud802\udd20", maxSize));
        InlineIndexHelperTest.assertEquals((int)-2, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\u0905", "\ud802\udd20\ud802\udd20\u0904", maxSize));
    }

    @Test
    public void testCompareMixed2() throws Exception {
        int i;
        int strCnt = 1000;
        int symbCnt = 20;
        int inlineSize = symbCnt * 4 + 3;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        Object[] strings = new String[strCnt];
        for (i = 0; i < strings.length; ++i) {
            strings[i] = this.randomString(symbCnt);
        }
        Arrays.sort(strings);
        for (i = 0; i < 100; ++i) {
            int i1 = rnd.nextInt(strings.length);
            int i2 = rnd.nextInt(strings.length);
            InlineIndexHelperTest.assertEquals((int)Integer.compare(i1, i2), (int)this.putAndCompare((String)strings[i1], (String)strings[i2], inlineSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putAndCompare(String v1, String v2, int maxSize) throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(this.log, (DirectMemoryProvider)new UnsafeMemoryProvider(this.log), null, 1024, plcCfg, new DataRegionMetricsImpl(plcCfg), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexHelper ih = new InlineIndexHelper("", 13, 1, 0, CompareMode.getInstance(null, (int)0));
            ih.put(pageAddr, off, (Value)(v1 == null ? ValueNull.INSTANCE : ValueString.get((String)v1)), maxSize);
            int n = ih.compare(pageAddr, off, maxSize, (Value)(v2 == null ? ValueNull.INSTANCE : ValueString.get((String)v2)), ALWAYS_FAILS_COMPARATOR);
            return n;
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    @Test
    public void testStringCut() {
        byte[] bytes = InlineIndexHelper.trimUTF8((byte[])"\u20ac\u20ac".getBytes(Charsets.UTF_8), (int)2);
        InlineIndexHelperTest.assertNull((Object)bytes);
    }

    @Test
    public void testRelyOnCompare() {
        InlineIndexHelper ha = new InlineIndexHelper("", 13, 0, 0, CompareMode.getInstance(null, (int)0));
        InlineIndexHelperTest.assertFalse((boolean)this.getRes(ha, "aabb", "aabb"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, "aabb", "aac"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, "aabb", "aaa"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, "aabb", "aaaaaa"));
        InlineIndexHelperTest.assertFalse((boolean)this.getRes(ha, "aaa", "aaaaaa"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, "a", null));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, null, "a"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, null, null));
    }

    @Test
    public void testRelyOnCompareBytes() {
        InlineIndexHelper ha = new InlineIndexHelper("", 12, 0, 0, CompareMode.getInstance(null, (int)0));
        InlineIndexHelperTest.assertFalse((boolean)this.getResBytes(ha, new byte[]{1, 2, 3, 4}, new byte[]{1, 2, 3, 4}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, new byte[]{1, 2, 2, 2}, new byte[]{1, 1, 2}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, new byte[]{1, 1, 1, 2}, new byte[]{1, 1, 2}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, new byte[]{1, 2}, new byte[]{1, 1, 1}));
        InlineIndexHelperTest.assertFalse((boolean)this.getResBytes(ha, new byte[]{1, 1}, new byte[]{1, 1, 2}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, new byte[]{1, 2, 3, 4}, null));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, null, new byte[]{1, 2, 3, 4}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, null, null));
    }

    @Test
    public void testRelyOnCompareJavaObject() {
        InlineIndexHelper ha = new InlineIndexHelper("", 19, 0, 0, CompareMode.getInstance(null, (int)0));
        InlineIndexHelperTest.assertTrue((boolean)this.getResJavaObjects(ha, new String("1234"), new Integer(10)));
        InlineIndexHelperTest.assertTrue((boolean)this.getResJavaObjects(ha, new String("1234"), new String("123")));
        InlineIndexHelperTest.assertFalse((boolean)this.getResJavaObjects(ha, new String("1234"), new String("1234")));
        String key = "1";
        InlineIndexHelperTest.assertFalse((boolean)this.getResJavaObjects(ha, key, key));
        InlineIndexHelperTest.assertTrue((boolean)this.getResJavaObjects(ha, key, null));
        InlineIndexHelperTest.assertTrue((boolean)this.getResJavaObjects(ha, null, key));
        InlineIndexHelperTest.assertTrue((boolean)this.getResJavaObjects(ha, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStringTruncate() throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(this.log(), (DirectMemoryProvider)new UnsafeMemoryProvider(this.log()), null, 1024, plcCfg, new DataRegionMetricsImpl(plcCfg), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexHelper ih = new InlineIndexHelper("", 13, 1, 0, CompareMode.getInstance(null, (int)0));
            ih.put(pageAddr, off, ValueString.get((String)"aaaaaaa"), 8);
            InlineIndexHelperTest.assertFalse((boolean)ih.isValueFull(pageAddr, off));
            InlineIndexHelperTest.assertEquals((String)"aaaaa", (String)ih.get(pageAddr, off, 8).getString());
            ih.put(pageAddr, off, ValueString.get((String)"aaa"), 8);
            InlineIndexHelperTest.assertTrue((boolean)ih.isValueFull(pageAddr, off));
            InlineIndexHelperTest.assertEquals((String)"aaa", (String)ih.get(pageAddr, off, 8).getString());
            ih.put(pageAddr, off, ValueString.get((String)"\u20acaaa"), 5);
            InlineIndexHelperTest.assertNull((Object)ih.get(pageAddr, off, 5));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytes() throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(this.log(), (DirectMemoryProvider)new UnsafeMemoryProvider(this.log()), null, 1024, plcCfg, new DataRegionMetricsImpl(plcCfg), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexHelper ih = new InlineIndexHelper("", 12, 1, 0, CompareMode.getInstance(null, (int)0));
            int maxSize = 6;
            int savedBytesCnt = ih.put(pageAddr, off, (Value)ValueBytes.get((byte[])new byte[]{1, 2, 3, 4, 5}), maxSize);
            InlineIndexHelperTest.assertTrue((savedBytesCnt > 0 ? 1 : 0) != 0);
            InlineIndexHelperTest.assertTrue((savedBytesCnt <= maxSize ? 1 : 0) != 0);
            InlineIndexHelperTest.assertFalse((boolean)ih.isValueFull(pageAddr, off));
            maxSize = 8;
            InlineIndexHelperTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, ih.get(pageAddr, off, maxSize).getBytes()));
            savedBytesCnt = ih.put(pageAddr, off, (Value)ValueBytes.get((byte[])new byte[]{1, 2, 3, 4, 5}), maxSize);
            InlineIndexHelperTest.assertTrue((savedBytesCnt > 0 ? 1 : 0) != 0);
            InlineIndexHelperTest.assertTrue((savedBytesCnt <= maxSize ? 1 : 0) != 0);
            InlineIndexHelperTest.assertTrue((boolean)ih.isValueFull(pageAddr, off));
            InlineIndexHelperTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4, 5}, ih.get(pageAddr, off, maxSize).getBytes()));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaObject() throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(this.log(), (DirectMemoryProvider)new UnsafeMemoryProvider(this.log()), null, 1024, plcCfg, new DataRegionMetricsImpl(plcCfg), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexHelper ih = new InlineIndexHelper("", 19, 1, 0, CompareMode.getInstance(null, (int)0));
            int maxSize = 6;
            int savedBytesCnt = ih.put(pageAddr, off, (Value)ValueJavaObject.getNoCopy(null, (byte[])new byte[]{1, 2, 3, 4, 5}, null), maxSize);
            InlineIndexHelperTest.assertTrue((savedBytesCnt > 0 ? 1 : 0) != 0);
            InlineIndexHelperTest.assertTrue((savedBytesCnt <= maxSize ? 1 : 0) != 0);
            InlineIndexHelperTest.assertFalse((boolean)ih.isValueFull(pageAddr, off));
            maxSize = 8;
            InlineIndexHelperTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, ih.get(pageAddr, off, maxSize).getBytes()));
            savedBytesCnt = ih.put(pageAddr, off, (Value)ValueJavaObject.getNoCopy(null, (byte[])new byte[]{1, 2, 3, 4, 5}, null), maxSize);
            InlineIndexHelperTest.assertTrue((savedBytesCnt > 0 ? 1 : 0) != 0);
            InlineIndexHelperTest.assertTrue((savedBytesCnt <= maxSize ? 1 : 0) != 0);
            InlineIndexHelperTest.assertTrue((boolean)ih.isValueFull(pageAddr, off));
            InlineIndexHelperTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4, 5}, ih.get(pageAddr, off, maxSize).getBytes()));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    @Test
    public void testNull() throws Exception {
        this.testPutGet((Value)ValueInt.get((int)-1), (Value)ValueNull.INSTANCE, (Value)ValueInt.get((int)3));
        this.testPutGet((Value)ValueInt.get((int)-1), (Value)ValueNull.INSTANCE, (Value)ValueInt.get((int)3));
        int maxSize = 5;
        InlineIndexHelperTest.assertEquals((int)1, (int)this.putAndCompare("aa", null, maxSize));
    }

    @Test
    public void testBoolean() throws Exception {
        this.testPutGet((Value)ValueBoolean.get((boolean)true), (Value)ValueBoolean.get((boolean)false), (Value)ValueBoolean.get((boolean)true));
    }

    @Test
    public void testByte() throws Exception {
        this.testPutGet((Value)ValueByte.get((byte)-1), (Value)ValueByte.get((byte)2), (Value)ValueByte.get((byte)3));
    }

    @Test
    public void testShort() throws Exception {
        this.testPutGet((Value)ValueShort.get((short)-32000), (Value)ValueShort.get((short)2), (Value)ValueShort.get((short)3));
    }

    @Test
    public void testInt() throws Exception {
        this.testPutGet((Value)ValueInt.get((int)-1), (Value)ValueInt.get((int)2), (Value)ValueInt.get((int)3));
    }

    @Test
    public void testLong() throws Exception {
        this.testPutGet((Value)ValueLong.get((long)-1L), (Value)ValueLong.get((long)2L), (Value)ValueLong.get((long)3L));
    }

    @Test
    public void testFloat() throws Exception {
        this.testPutGet((Value)ValueFloat.get((float)1.1f), (Value)ValueFloat.get((float)2.2f), (Value)ValueFloat.get((float)1.1f));
    }

    @Test
    public void testDouble() throws Exception {
        this.testPutGet((Value)ValueDouble.get((double)1.1f), (Value)ValueDouble.get((double)2.2f), (Value)ValueDouble.get((double)1.1f));
    }

    @Test
    public void testDate() throws Exception {
        this.testPutGet((Value)ValueDate.get((Date)Date.valueOf("2017-02-20")), (Value)ValueDate.get((Date)Date.valueOf("2017-02-21")), (Value)ValueDate.get((Date)Date.valueOf("2017-02-19")));
    }

    @Test
    public void testTime() throws Exception {
        this.testPutGet((Value)ValueTime.get((Time)Time.valueOf("10:01:01")), (Value)ValueTime.get((Time)Time.valueOf("11:02:02")), (Value)ValueTime.get((Time)Time.valueOf("12:03:03")));
    }

    @Test
    public void testTimestamp() throws Exception {
        this.testPutGet((Value)ValueTimestamp.get((Timestamp)Timestamp.valueOf("2017-02-20 10:01:01")), (Value)ValueTimestamp.get((Timestamp)Timestamp.valueOf("2017-02-20 10:01:01")), (Value)ValueTimestamp.get((Timestamp)Timestamp.valueOf("2017-02-20 10:01:01")));
    }

    @Test
    public void testUUID() throws Exception {
        this.testPutGet((Value)ValueUuid.get((String)UUID.randomUUID().toString()), (Value)ValueUuid.get((String)UUID.randomUUID().toString()), (Value)ValueUuid.get((String)UUID.randomUUID().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutGet(Value v1, Value v2, Value v3) throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(this.log(), (DirectMemoryProvider)new UnsafeMemoryProvider(this.log()), null, 1024, plcCfg, new DataRegionMetricsImpl(plcCfg), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            int max = 255;
            InlineIndexHelper ih = new InlineIndexHelper("", v1.getType(), 1, 0, CompareMode.getInstance(null, (int)0));
            off += ih.put(pageAddr, off, v1, max - off);
            off += ih.put(pageAddr, off, v2, max - off);
            off += ih.put(pageAddr, off, v3, max - off);
            Value v11 = ih.get(pageAddr, 0, max);
            Value v22 = ih.get(pageAddr, ih.fullSize(pageAddr, 0), max);
            InlineIndexHelperTest.assertEquals((Object)v1.getObject(), (Object)v11.getObject());
            InlineIndexHelperTest.assertEquals((Object)v2.getObject(), (Object)v22.getObject());
            InlineIndexHelperTest.assertEquals((int)0, (int)ih.compare(pageAddr, 0, max, v1, ALWAYS_FAILS_COMPARATOR));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    private boolean getRes(InlineIndexHelper ha, String s1, String s2) {
        ValueNull v1 = s1 == null ? ValueNull.INSTANCE : ValueString.get((String)s1);
        ValueNull v2 = s2 == null ? ValueNull.INSTANCE : ValueString.get((String)s2);
        int c = v1.compareTypeSafe((Value)v2, CompareMode.getInstance(null, (int)0));
        return ha.canRelyOnCompare(c, (Value)v1, (Value)v2);
    }

    private boolean getResBytes(InlineIndexHelper ha, byte[] b1, byte[] b2) {
        ValueNull v1 = b1 == null ? ValueNull.INSTANCE : ValueBytes.get((byte[])b1);
        ValueNull v2 = b2 == null ? ValueNull.INSTANCE : ValueBytes.get((byte[])b2);
        int c = v1.compareTypeSafe((Value)v2, CompareMode.getInstance(null, (int)0));
        return ha.canRelyOnCompare(c, (Value)v1, (Value)v2);
    }

    private boolean getResJavaObjects(InlineIndexHelper ha, Object o1, Object o2) {
        ValueNull v1 = o1 == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(null, (byte[])SerializationUtils.serialize((Object)o1), null);
        ValueNull v2 = o2 == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(null, (byte[])SerializationUtils.serialize((Object)o2), null);
        int c = v1.compareTypeSafe((Value)v2, CompareMode.getInstance(null, (int)0));
        return ha.canRelyOnCompare(c, (Value)v1, (Value)v2);
    }

    private String randomString(int cnt) {
        char[] buffer = new char[cnt];
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        while (cnt-- != 0) {
            char ch = rnd.nextInt(100) > 3 ? (char)(rnd.nextInt(95) + 32) : (char)(rnd.nextInt(65407) + 127);
            if (ch >= '\udc00' && ch <= '\udfff') {
                if (cnt == 0) {
                    ++cnt;
                    continue;
                }
                buffer[cnt] = ch;
                buffer[--cnt] = (char)(55296 + rnd.nextInt(128));
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udb7f') {
                if (cnt == 0) {
                    ++cnt;
                    continue;
                }
                buffer[cnt] = (char)(56320 + rnd.nextInt(128));
                buffer[--cnt] = ch;
                continue;
            }
            if (ch >= '\udb80' && ch <= '\udbff') {
                ++cnt;
                continue;
            }
            buffer[cnt] = ch;
        }
        return new String(buffer);
    }

    private static class AlwaysFailsComparator
    implements Comparator<Value> {
        private AlwaysFailsComparator() {
        }

        @Override
        public int compare(Value o1, Value o2) {
            throw new AssertionError((Object)"Optimized algorithm should be used.");
        }
    }
}

