/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.processors.query.h2.ThreadLocalObjectPool;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ThreadLocalObjectPoolSelfTest
extends GridCommonAbstractTest {
    private ThreadLocalObjectPool<Obj> pool = new ThreadLocalObjectPool(() -> new Obj(), 1);

    @Test
    public void testObjectIsReusedAfterRecycling() throws Exception {
        ThreadLocalObjectPool.Reusable o1 = this.pool.borrow();
        o1.recycle();
        ThreadLocalObjectPool.Reusable o2 = this.pool.borrow();
        ThreadLocalObjectPoolSelfTest.assertSame((Object)o1.object(), (Object)o2.object());
        ThreadLocalObjectPoolSelfTest.assertFalse((boolean)((Obj)o1.object()).isClosed());
    }

    @Test
    public void testBorrowedObjectIsNotReturnedTwice() throws Exception {
        ThreadLocalObjectPool.Reusable o1 = this.pool.borrow();
        ThreadLocalObjectPool.Reusable o2 = this.pool.borrow();
        ThreadLocalObjectPoolSelfTest.assertNotSame((Object)o1.object(), (Object)o2.object());
    }

    @Test
    public void testObjectShouldBeClosedOnRecycleIfPoolIsFull() throws Exception {
        ThreadLocalObjectPool.Reusable o1 = this.pool.borrow();
        ThreadLocalObjectPool.Reusable o2 = this.pool.borrow();
        o1.recycle();
        o2.recycle();
        ThreadLocalObjectPoolSelfTest.assertTrue((boolean)((Obj)o2.object()).isClosed());
    }

    @Test
    public void testObjectShouldNotBeReturnedIfPoolIsFull() throws Exception {
        ThreadLocalObjectPool.Reusable o1 = this.pool.borrow();
        ThreadLocalObjectPool.Reusable o2 = this.pool.borrow();
        o1.recycle();
        ThreadLocalObjectPoolSelfTest.assertEquals((int)1, (int)this.pool.bagSize());
        o2.recycle();
        ThreadLocalObjectPoolSelfTest.assertEquals((int)1, (int)this.pool.bagSize());
    }

    @Test
    public void testObjectShouldReturnedToRecyclingThreadBag() throws Exception {
        ThreadLocalObjectPool.Reusable o1 = this.pool.borrow();
        CompletableFuture.runAsync(() -> {
            o1.recycle();
            ThreadLocalObjectPoolSelfTest.assertEquals((int)1, (int)this.pool.bagSize());
        }).join();
        ThreadLocalObjectPoolSelfTest.assertEquals((int)0, (int)this.pool.bagSize());
    }

    private static class Obj
    implements AutoCloseable {
        private boolean closed = false;

        private Obj() {
        }

        @Override
        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

