/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import org.apache.ignite.internal.processors.query.h2.H2CachedStatementKey;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.PreparedStatementExImpl;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class H2StatementCacheSelfTest
extends GridCommonAbstractTest {
    @Test
    public void testEviction() throws Exception {
        H2StatementCache stmtCache = new H2StatementCache(1);
        H2CachedStatementKey key1 = new H2CachedStatementKey("", "1");
        PreparedStatement stmt1 = H2StatementCacheSelfTest.stmt();
        stmtCache.put(key1, stmt1);
        H2StatementCacheSelfTest.assertSame((Object)stmt1, (Object)stmtCache.get(key1));
        stmtCache.put(new H2CachedStatementKey("mydb", "2"), H2StatementCacheSelfTest.stmt());
        H2StatementCacheSelfTest.assertNull((Object)stmtCache.get(key1));
    }

    @Test
    public void testLruEvictionInStoreOrder() throws Exception {
        H2StatementCache stmtCache = new H2StatementCache(2);
        H2CachedStatementKey key1 = new H2CachedStatementKey("", "1");
        H2CachedStatementKey key2 = new H2CachedStatementKey("", "2");
        stmtCache.put(key1, H2StatementCacheSelfTest.stmt());
        stmtCache.put(key2, H2StatementCacheSelfTest.stmt());
        stmtCache.put(new H2CachedStatementKey("", "3"), H2StatementCacheSelfTest.stmt());
        H2StatementCacheSelfTest.assertNull((Object)stmtCache.get(key1));
    }

    @Test
    public void testLruEvictionInAccessOrder() throws Exception {
        H2StatementCache stmtCache = new H2StatementCache(2);
        H2CachedStatementKey key1 = new H2CachedStatementKey("", "1");
        H2CachedStatementKey key2 = new H2CachedStatementKey("", "2");
        stmtCache.put(key1, H2StatementCacheSelfTest.stmt());
        stmtCache.put(key2, H2StatementCacheSelfTest.stmt());
        stmtCache.get(key1);
        stmtCache.put(new H2CachedStatementKey("", "3"), H2StatementCacheSelfTest.stmt());
        H2StatementCacheSelfTest.assertNull((Object)stmtCache.get(key2));
    }

    private static PreparedStatement stmt() {
        return new PreparedStatementExImpl(null);
    }
}

