/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.H2ResultSetIterator;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class H2ResultSetIteratorNullifyOnEndSelfTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 2;
    private static final int PERSON_COUNT = 20;
    private static final String SELECT_ALL_SQL = "SELECT p.* FROM Person p ORDER BY p.salary";
    private static final String SELECT_MAX_SAL_SQLF = "select max(salary) from Person";

    @Test
    public void testSqlQueryClose() {
        SqlQuery qry = new SqlQuery(Person.class, SELECT_ALL_SQL);
        QueryCursor qryCurs = this.cache().query((Query)qry);
        qryCurs.iterator();
        qryCurs.close();
        H2ResultSetIterator h2It = this.extractIteratorInnerGridIteratorInnerH2ResultSetIterator((QueryCursor<Cache.Entry<String, Person>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlQueryComplete() {
        SqlQuery qry = new SqlQuery(Person.class, SELECT_ALL_SQL);
        QueryCursor qryCurs = this.cache().query((Query)qry);
        qryCurs.getAll();
        H2ResultSetIterator h2It = this.extractIteratorInnerGridIteratorInnerH2ResultSetIterator((QueryCursor<Cache.Entry<String, Person>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlQueryLocalClose() {
        SqlQuery qry = new SqlQuery(Person.class, SELECT_ALL_SQL);
        qry.setLocal(true);
        QueryCursor qryCurs = this.cache().query((Query)qry);
        qryCurs.iterator();
        qryCurs.close();
        H2ResultSetIterator h2It = this.extractIterableInnerH2ResultSetIterator((QueryCursor<Cache.Entry<String, Person>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlQueryLocalComplete() {
        SqlQuery qry = new SqlQuery(Person.class, SELECT_ALL_SQL);
        qry.setLocal(true);
        QueryCursor qryCurs = this.cache().query((Query)qry);
        qryCurs.getAll();
        H2ResultSetIterator h2It = this.extractIterableInnerH2ResultSetIterator((QueryCursor<Cache.Entry<String, Person>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlFieldsQueryClose() {
        SqlFieldsQuery qry = new SqlFieldsQuery(SELECT_MAX_SAL_SQLF);
        FieldsQueryCursor qryCurs = this.cache().query(qry);
        qryCurs.iterator();
        qryCurs.close();
        H2ResultSetIterator h2It = this.extractGridIteratorInnerH2ResultSetIterator((QueryCursor<List<?>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlFieldsQueryComplete() {
        SqlFieldsQuery qry = new SqlFieldsQuery(SELECT_MAX_SAL_SQLF);
        FieldsQueryCursor qryCurs = this.cache().query(qry);
        qryCurs.getAll();
        H2ResultSetIterator h2It = this.extractGridIteratorInnerH2ResultSetIterator((QueryCursor<List<?>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlFieldsQueryLocalClose() {
        SqlFieldsQuery qry = new SqlFieldsQuery(SELECT_MAX_SAL_SQLF);
        qry.setLocal(true);
        FieldsQueryCursor qryCurs = this.cache().query(qry);
        qryCurs.iterator();
        qryCurs.close();
        H2ResultSetIterator h2It = this.extractGridIteratorInnerH2ResultSetIterator((QueryCursor<List<?>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlFieldsQueryLocalComplete() {
        SqlFieldsQuery qry = new SqlFieldsQuery(SELECT_MAX_SAL_SQLF);
        qry.setLocal(true);
        FieldsQueryCursor qryCurs = this.cache().query(qry);
        qryCurs.getAll();
        H2ResultSetIterator h2It = this.extractGridIteratorInnerH2ResultSetIterator((QueryCursor<List<?>>)qryCurs);
        this.checkIterator(h2It);
    }

    private void checkIterator(H2ResultSetIterator h2it) {
        if (Objects.nonNull(h2it)) {
            H2ResultSetIteratorNullifyOnEndSelfTest.assertNull((Object)GridTestUtils.getFieldValue((Object)h2it, H2ResultSetIterator.class, (String)"data"));
        } else {
            H2ResultSetIteratorNullifyOnEndSelfTest.fail();
        }
    }

    private H2ResultSetIterator extractIteratorInnerGridIteratorInnerH2ResultSetIterator(QueryCursor<Cache.Entry<String, Person>> qryCurs) {
        Iterator inner;
        GridQueryCacheObjectsIterator it;
        Iterator h2RsIt;
        if (QueryCursorImpl.class.isAssignableFrom(qryCurs.getClass()) && H2ResultSetIterator.class.isAssignableFrom((h2RsIt = (Iterator)GridTestUtils.getFieldValue((Object)(it = (GridQueryCacheObjectsIterator)GridTestUtils.getFieldValue((Object)(inner = (Iterator)GridTestUtils.getFieldValue(qryCurs, QueryCursorImpl.class, (String)"iter")), inner.getClass(), (String)"val$iter0")), GridQueryCacheObjectsIterator.class, (String)"iter")).getClass())) {
            return (H2ResultSetIterator)h2RsIt;
        }
        return null;
    }

    private H2ResultSetIterator extractIterableInnerH2ResultSetIterator(QueryCursor<Cache.Entry<String, Person>> qryCurs) {
        Iterable iterable;
        Iterator h2RsIt;
        if (QueryCursorImpl.class.isAssignableFrom(qryCurs.getClass()) && H2ResultSetIterator.class.isAssignableFrom((h2RsIt = (Iterator)GridTestUtils.getFieldValue((Object)(iterable = (Iterable)GridTestUtils.getFieldValue(qryCurs, QueryCursorImpl.class, (String)"iterExec")), iterable.getClass(), (String)"val$i")).getClass())) {
            return (H2ResultSetIterator)h2RsIt;
        }
        return null;
    }

    private H2ResultSetIterator extractGridIteratorInnerH2ResultSetIterator(QueryCursor<List<?>> qryCurs) {
        GridQueryCacheObjectsIterator it;
        Iterator h2RsIt;
        if (QueryCursorImpl.class.isAssignableFrom(qryCurs.getClass()) && H2ResultSetIterator.class.isAssignableFrom((h2RsIt = (Iterator)GridTestUtils.getFieldValue((Object)(it = (GridQueryCacheObjectsIterator)GridTestUtils.getFieldValue(qryCurs, QueryCursorImpl.class, (String)"iter")), GridQueryCacheObjectsIterator.class, (String)"iter")).getClass())) {
            return (H2ResultSetIterator)h2RsIt;
        }
        return null;
    }

    @Test
    public void testOnClose() {
        try {
            GridCloseableIterator it = this.indexing().queryLocalSql(this.indexing().schema(this.cache().getName()), this.cache().getName(), SELECT_ALL_SQL, null, Collections.emptySet(), "Person", null, null);
            if (H2ResultSetIterator.class.isAssignableFrom(it.getClass())) {
                H2ResultSetIterator h2it = (H2ResultSetIterator)it;
                h2it.onClose();
                H2ResultSetIteratorNullifyOnEndSelfTest.assertNull((Object)GridTestUtils.getFieldValue((Object)h2it, H2ResultSetIterator.class, (String)"data"));
            } else {
                H2ResultSetIteratorNullifyOnEndSelfTest.fail();
            }
        }
        catch (IgniteCheckedException e) {
            H2ResultSetIteratorNullifyOnEndSelfTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOnComplete() {
        try {
            GridCloseableIterator it = this.indexing().queryLocalSql(this.indexing().schema(this.cache().getName()), this.cache().getName(), SELECT_ALL_SQL, null, Collections.emptySet(), "Person", null, null);
            if (H2ResultSetIterator.class.isAssignableFrom(it.getClass())) {
                H2ResultSetIterator h2it = (H2ResultSetIterator)it;
                while (h2it.onHasNext()) {
                    h2it.onNext();
                }
                H2ResultSetIteratorNullifyOnEndSelfTest.assertNull((Object)GridTestUtils.getFieldValue((Object)h2it, H2ResultSetIterator.class, (String)"data"));
            } else {
                H2ResultSetIteratorNullifyOnEndSelfTest.fail();
            }
        }
        catch (IgniteCheckedException e) {
            H2ResultSetIteratorNullifyOnEndSelfTest.fail((String)e.getMessage());
        }
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(2);
        this.ignite(0).createCache(new CacheConfiguration("pers").setIndexedTypes(new Class[]{String.class, Person.class}));
        this.awaitPartitionMapExchange();
        this.populateDataIntoPerson();
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    private IgniteH2Indexing indexing() {
        GridQueryProcessor qryProcessor = this.grid(0).context().query();
        return (IgniteH2Indexing)GridTestUtils.getFieldValue((Object)qryProcessor, GridQueryProcessor.class, (String)"idx");
    }

    private IgniteCache<String, Person> cache() {
        return this.grid(0).cache("pers");
    }

    private void populateDataIntoPerson() {
        IgniteCache<String, Person> cache = this.cache();
        int personId = 0;
        for (int j = 0; j < 20; ++j) {
            Person prsn = new Person();
            prsn.setId("pers" + personId);
            prsn.setName("Person name #" + personId);
            cache.put((Object)prsn.getId(), (Object)prsn);
            ++personId;
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        private String id;
        @QuerySqlField(index=true)
        private String name;
        @QuerySqlField(index=true)
        private int salary;

        private Person() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getSalary() {
            return this.salary;
        }

        public void setSalary(int salary) {
            this.salary = salary;
        }
    }
}

