/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.GridStringLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GridIndexingSpiAbstractSelfTest
extends GridCommonAbstractTest {
    private static final LinkedHashMap<String, String> fieldsAA = new LinkedHashMap();
    private static final LinkedHashMap<String, String> fieldsAB = new LinkedHashMap();
    private IgniteEx ignite0;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.ignite0 = this.startGrid(0);
    }

    private CacheConfiguration cacheACfg() {
        CacheConfiguration cfg = new CacheConfiguration("default");
        cfg.setName("A");
        QueryEntity eA = new QueryEntity(Integer.class.getName(), "A");
        eA.setFields(fieldsAA);
        QueryEntity eB = new QueryEntity(Integer.class.getName(), "B");
        eB.setFields(fieldsAB);
        ArrayList<QueryEntity> list = new ArrayList<QueryEntity>(2);
        list.add(eA);
        list.add(eB);
        QueryIndex idx = new QueryIndex("txt");
        idx.setIndexType(QueryIndexType.FULLTEXT);
        eB.setIndexes(Collections.singleton(idx));
        cfg.setQueryEntities(list);
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    private IgniteH2Indexing getIndexing() {
        return (IgniteH2Indexing)U.field((Object)this.ignite0.context().query(), (String)"idx");
    }

    protected boolean offheap() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongQueries() throws Exception {
        IgniteH2Indexing spi = this.getIndexing();
        this.ignite0.createCache(this.cacheACfg());
        long longQryExecTime = 3000L;
        GridStringLogger log = new GridStringLogger(false, this.log);
        IgniteLogger oldLog = (IgniteLogger)GridTestUtils.getFieldValue((Object)spi, (String[])new String[]{"log"});
        try {
            String res;
            long now;
            GridTestUtils.setFieldValue((Object)spi, (String)"log", (Object)log);
            String sql = "select sum(x) FROM SYSTEM_RANGE(?, ?)";
            long time = now = U.currentTimeMillis();
            long range = 1000000L;
            while (now - time <= longQryExecTime * 3L / 2L) {
                time = now;
                res = spi.queryLocalSqlFields(spi.schema("A"), sql, Arrays.asList(1, range *= 3L), null, false, false, 0, null);
                assert (res.iterator().hasNext());
                now = U.currentTimeMillis();
            }
            res = log.toString();
            GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.contains("/* PUBLIC.RANGE_INDEX */"));
        }
        finally {
            GridTestUtils.setFieldValue((Object)spi, (String)"log", (Object)oldLog);
        }
    }

    static {
        fieldsAA.put("id", Long.class.getName());
        fieldsAA.put("name", String.class.getName());
        fieldsAA.put("age", Integer.class.getName());
        fieldsAB.putAll(fieldsAA);
        fieldsAB.put("txt", String.class.getName());
    }
}

