/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.File;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.query.h2.GridIndexRebuildSelfTest;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GridIndexRebuildWithMvccEnabledSelfTest
extends GridIndexRebuildSelfTest {
    @Override
    protected IgniteConfiguration serverConfiguration(int idx, boolean filter) throws Exception {
        return super.serverConfiguration(idx, filter).setMvccVacuumFrequency(Integer.MAX_VALUE);
    }

    @Override
    @Test
    public void testIndexRebuild() throws Exception {
        IgniteEx srv = this.startServer();
        this.execute((Ignite)srv, "CREATE TABLE T(k int primary key, v int) WITH \"cache_name=T,wrap_value=false,atomicity=transactional_snapshot\"");
        this.execute((Ignite)srv, "CREATE INDEX IDX ON T(v)");
        IgniteInternalCache cc = srv.cachex("T");
        GridIndexRebuildWithMvccEnabledSelfTest.assertNotNull((Object)cc);
        GridIndexRebuildWithMvccEnabledSelfTest.lockVersion(srv);
        this.putData((Ignite)srv, false);
        this.checkDataState(srv, false);
        File cacheWorkDir = ((FilePageStoreManager)cc.context().shared().pageStore()).cacheWorkDir(cc.configuration());
        File idxPath = cacheWorkDir.toPath().resolve("index.bin").toFile();
        this.stopAllGrids();
        GridIndexRebuildWithMvccEnabledSelfTest.assertTrue((boolean)U.delete((File)idxPath));
        srv = this.startServer();
        this.putData((Ignite)srv, true);
        this.checkDataState(srv, true);
    }

    private static void lockVersion(IgniteEx node) throws IgniteCheckedException {
        node.context().coordinators().requestSnapshotAsync((IgniteInternalTx)null).get();
    }

    @Override
    protected void checkDataState(IgniteEx srv, boolean afterRebuild) throws IgniteCheckedException {
        IgniteInternalCache icache = srv.cachex("T");
        GridIndexRebuildWithMvccEnabledSelfTest.assertNotNull((Object)icache);
        CacheObjectContext coCtx = icache.context().cacheObjectContext();
        for (IgniteCacheOffheapManager.CacheDataStore store : icache.context().offheap().cacheDataStores()) {
            GridCursor cur = store.cursor();
            while (cur.next()) {
                CacheDataRow row = (CacheDataRow)cur.get();
                int key = (Integer)row.key().value((CacheObjectValueContext)coCtx, false);
                List vers = store.mvccFindAllVersions(icache.context(), row.key());
                if (!afterRebuild || key <= 25) {
                    GridIndexRebuildWithMvccEnabledSelfTest.assertEquals((int)key, (int)vers.size());
                    continue;
                }
                GridIndexRebuildWithMvccEnabledSelfTest.assertEquals((int)2, (int)vers.size());
                Object val0 = ((CacheObject)((IgniteBiTuple)vers.get(0)).getKey()).value((CacheObjectValueContext)coCtx, false);
                Object val1 = ((CacheObject)((IgniteBiTuple)vers.get(1)).getKey()).value((CacheObjectValueContext)coCtx, false);
                GridIndexRebuildWithMvccEnabledSelfTest.assertEquals((Object)-1, (Object)val0);
                GridIndexRebuildWithMvccEnabledSelfTest.assertEquals((Object)key, (Object)val1);
            }
        }
    }
}

