/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.index.DynamicIndexAbstractSelfTest;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GridIndexRebuildSelfTest
extends DynamicIndexAbstractSelfTest {
    protected static final int AMOUNT = 50;
    protected static final String CACHE_NAME = "T";
    private static GridIndexRebuildSelfTest INSTANCE;
    private final CountDownLatch rebuildLatch = new CountDownLatch(1);

    @Override
    protected IgniteConfiguration commonConfiguration(int idx) throws Exception {
        IgniteConfiguration cfg = super.commonConfiguration(idx);
        cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().setMaxSize(314572800L).setPersistenceEnabled(true);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
        INSTANCE = this;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.cleanPersistenceDir();
    }

    @Test
    public void testIndexRebuild() throws Exception {
        IgniteEx srv = this.startServer();
        this.execute((Ignite)srv, "CREATE TABLE T(k int primary key, v int) WITH \"cache_name=T,wrap_value=false,atomicity=transactional\"");
        this.execute((Ignite)srv, "CREATE INDEX IDX ON T(v)");
        IgniteInternalCache cc = srv.cachex(CACHE_NAME);
        GridIndexRebuildSelfTest.assertNotNull((Object)cc);
        this.putData((Ignite)srv, false);
        this.checkDataState(srv, false);
        File cacheWorkDir = ((FilePageStoreManager)cc.context().shared().pageStore()).cacheWorkDir(cc.configuration());
        File idxPath = cacheWorkDir.toPath().resolve("index.bin").toFile();
        this.stopAllGrids();
        GridIndexRebuildSelfTest.assertTrue((boolean)U.delete((File)idxPath));
        srv = this.startServer();
        this.putData((Ignite)srv, true);
        this.checkDataState(srv, true);
    }

    protected void checkDataState(IgniteEx srv, boolean afterRebuild) throws IgniteCheckedException {
        IgniteInternalCache icache = srv.cachex(CACHE_NAME);
        IgniteCache cache = srv.cache(CACHE_NAME);
        GridIndexRebuildSelfTest.assertNotNull((Object)icache);
        for (IgniteCacheOffheapManager.CacheDataStore store : icache.context().offheap().cacheDataStores()) {
            GridCursor cur = store.cursor();
            while (cur.next()) {
                CacheDataRow row = (CacheDataRow)cur.get();
                int key = (Integer)row.key().value((CacheObjectValueContext)icache.context().cacheObjectContext(), false);
                if (!afterRebuild || key <= 25) {
                    GridIndexRebuildSelfTest.assertEquals((Object)key, (Object)cache.get((Object)key));
                    continue;
                }
                GridIndexRebuildSelfTest.assertEquals((Object)-1, (Object)cache.get((Object)key));
            }
        }
    }

    protected void putData(Ignite node, boolean forConcurrentPut) throws Exception {
        IgniteCache cache = node.cache(CACHE_NAME);
        GridIndexRebuildSelfTest.assertNotNull((Object)cache);
        for (int i = 1; i <= 50; ++i) {
            if (forConcurrentPut) {
                if (i <= 25) continue;
                cache.put((Object)i, (Object)-1);
                this.rebuildLatch.countDown();
                continue;
            }
            for (int j = 1; j <= i; ++j) {
                cache.put((Object)i, (Object)j);
            }
        }
    }

    protected IgniteEx startServer() throws Exception {
        GridQueryProcessor.idxCls = BlockingIndexing.class;
        IgniteConfiguration cfg = this.serverConfiguration(0);
        IgniteEx res = this.startGrid(cfg);
        res.active(true);
        return res;
    }

    private static class BlockingIndexing
    extends IgniteH2Indexing {
        private boolean firstRbld = true;

        private BlockingIndexing() {
        }

        protected void rebuildIndexesFromHash0(GridCacheContext cctx, SchemaIndexCacheVisitorClosure clo) throws IgniteCheckedException {
            if (!this.firstRbld) {
                U.await((CountDownLatch)INSTANCE.rebuildLatch);
            } else {
                this.firstRbld = false;
            }
            super.rebuildIndexesFromHash0(cctx, clo);
        }
    }
}

