/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.EvictionFilter;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.lang.GridNodePredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlSystemViewsSelfTest
extends GridCommonAbstractTest {
    private static final int METRICS_CHECK_ATTEMPTS = 10;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    private List<List<?>> execSql(Ignite ignite, String sql, Object ... args) {
        IgniteCache cache = ignite.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        if (args != null && args.length > 0) {
            qry.setArgs(args);
        }
        return cache.query(qry).getAll();
    }

    private List<List<?>> execSql(String sql, Object ... args) {
        return this.execSql((Ignite)this.grid(), sql, args);
    }

    private void assertSqlError(final String sql) {
        Throwable t = GridTestUtils.assertThrowsWithCause((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                SqlSystemViewsSelfTest.this.execSql(sql, new Object[0]);
                return null;
            }
        }, IgniteSQLException.class);
        IgniteSQLException sqlE = (IgniteSQLException)X.cause((Throwable)t, IgniteSQLException.class);
        assert (sqlE != null);
        SqlSystemViewsSelfTest.assertEquals((int)1002, (int)sqlE.statusCode());
    }

    @Test
    public void testModifications() throws Exception {
        this.startGrid(this.getConfiguration());
        this.assertSqlError("DROP TABLE IGNITE.NODES");
        this.assertSqlError("TRUNCATE TABLE IGNITE.NODES");
        this.assertSqlError("ALTER TABLE IGNITE.NODES RENAME TO IGNITE.N");
        this.assertSqlError("ALTER TABLE IGNITE.NODES ADD COLUMN C VARCHAR");
        this.assertSqlError("ALTER TABLE IGNITE.NODES DROP COLUMN ID");
        this.assertSqlError("ALTER TABLE IGNITE.NODES RENAME COLUMN ID TO C");
        this.assertSqlError("CREATE INDEX IDX ON IGNITE.NODES(ID)");
        this.assertSqlError("INSERT INTO IGNITE.NODES (ID) VALUES ('-')");
        this.assertSqlError("UPDATE IGNITE.NODES SET ID = '-'");
        this.assertSqlError("DELETE IGNITE.NODES");
    }

    @Test
    public void testQueryModes() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        this.startGrid(1);
        UUID nodeId = ignite.cluster().localNode().id();
        IgniteCache cache = ignite.getOrCreateCache("default");
        String sql = "SELECT ID FROM IGNITE.NODES WHERE NODE_ORDER = 1";
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setDistributedJoins(true);
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId, ((List)cache.query(qry).getAll().get(0)).get(0));
        qry = new SqlFieldsQuery(sql).setReplicatedOnly(true);
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId, ((List)cache.query(qry).getAll().get(0)).get(0));
        qry = new SqlFieldsQuery(sql).setLocal(true);
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId, ((List)cache.query(qry).getAll().get(0)).get(0));
    }

    @Test
    public void testCacheToViewJoin() throws Exception {
        Ignite ignite = this.startGrid();
        ignite.createCache(new CacheConfiguration().setName("default").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class.getName(), String.class.getName()))));
        this.assertSqlError("SELECT * FROM \"default\".String JOIN IGNITE.NODES ON 1=1");
    }

    private void assertColumnTypes(List<?> rowData, Class<?> ... colTypes) {
        for (int i = 0; i < colTypes.length; ++i) {
            if (rowData.get(i) == null) continue;
            SqlSystemViewsSelfTest.assertEquals((String)("Column " + i + " type"), colTypes[i], rowData.get(i).getClass());
        }
    }

    @Test
    public void testNodesViews() throws Exception {
        Ignite igniteSrv = this.startGrid(this.getTestIgniteInstanceName(), this.getConfiguration().setMetricsUpdateFrequency(500L));
        Ignite igniteCli = this.startGrid(this.getTestIgniteInstanceName(1), this.getConfiguration().setMetricsUpdateFrequency(500L).setClientMode(true));
        this.startGrid(this.getTestIgniteInstanceName(2), this.getConfiguration().setMetricsUpdateFrequency(500L).setDaemon(true));
        UUID nodeId0 = igniteSrv.cluster().localNode().id();
        this.awaitPartitionMapExchange();
        List<List<?>> resAll = this.execSql("SELECT ID, CONSISTENT_ID, VERSION, IS_CLIENT, IS_DAEMON, NODE_ORDER, ADDRESSES, HOSTNAMES FROM IGNITE.NODES", new Object[0]);
        this.assertColumnTypes(resAll.get(0), UUID.class, String.class, String.class, Boolean.class, Boolean.class, Integer.class, String.class, String.class);
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)resAll.size());
        List<List<?>> resSrv = this.execSql("SELECT ID, NODE_ORDER FROM IGNITE.NODES WHERE IS_CLIENT = FALSE AND IS_DAEMON = FALSE", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)resSrv.size());
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId0, resSrv.get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)1, resSrv.get(0).get(1));
        List<List<?>> resCli = this.execSql("SELECT ID, NODE_ORDER FROM IGNITE.NODES WHERE IS_CLIENT = TRUE", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)resCli.size());
        SqlSystemViewsSelfTest.assertEquals((Object)this.nodeId(1), resCli.get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)2, resCli.get(0).get(1));
        List<List<?>> resDaemon = this.execSql("SELECT ID, NODE_ORDER FROM IGNITE.NODES WHERE IS_DAEMON = TRUE", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)resDaemon.size());
        SqlSystemViewsSelfTest.assertEquals((Object)this.nodeId(2), resDaemon.get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)3, resDaemon.get(0).get(1));
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT ID FROM IGNITE.NODES WHERE ID = '-'", new Object[0]).size());
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT ID FROM IGNITE.NODES WHERE ID = ?", nodeId0).size());
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT ID FROM IGNITE.NODES WHERE ID = ?", this.nodeId(2)).size());
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)this.execSql("SELECT ID FROM IGNITE.NODES WHERE ID = ? OR node_order=1 OR node_order=2 OR node_order=3", nodeId0).size());
        SqlSystemViewsSelfTest.assertEquals((Object)3L, this.execSql("SELECT COUNT(*) FROM IGNITE.NODES", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId0, this.execSql("SELECT N1.ID FROM IGNITE.NODES N1 JOIN IGNITE.NODES N2 ON N1.NODE_ORDER = N2.NODE_ORDER JOIN IGNITE.NODES N3 ON N2.ID = N3.ID WHERE N3.NODE_ORDER = 1", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId0, this.execSql("SELECT N1.ID FROM IGNITE.NODES N1 WHERE NOT EXISTS (SELECT 1 FROM IGNITE.NODES N2 WHERE N2.ID = N1.ID AND N2.NODE_ORDER <> 1)", new Object[0]).get(0).get(0));
        String cliAttrName = "org.apache.ignite.cache.client";
        this.assertColumnTypes(this.execSql("SELECT NODE_ID, NAME, VALUE FROM IGNITE.NODE_ATTRIBUTES", new Object[0]).get(0), UUID.class, String.class, String.class);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT NODE_ID FROM IGNITE.NODE_ATTRIBUTES WHERE NAME = ? AND VALUE = 'true'", cliAttrName).size());
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)this.execSql("SELECT NODE_ID FROM IGNITE.NODE_ATTRIBUTES WHERE NAME = ?", cliAttrName).size());
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT NODE_ID FROM IGNITE.NODE_ATTRIBUTES WHERE NODE_ID = ? AND NAME = ? AND VALUE = 'true'", this.nodeId(1), cliAttrName).size());
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT NODE_ID FROM IGNITE.NODE_ATTRIBUTES WHERE NODE_ID = '-' AND NAME = ?", cliAttrName).size());
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT NODE_ID FROM IGNITE.NODE_ATTRIBUTES WHERE NODE_ID = ? AND NAME = '-'", this.nodeId(1)).size());
        String sqlAllMetrics = "SELECT NODE_ID, LAST_UPDATE_TIME, MAX_ACTIVE_JOBS, CUR_ACTIVE_JOBS, AVG_ACTIVE_JOBS, MAX_WAITING_JOBS, CUR_WAITING_JOBS, AVG_WAITING_JOBS, MAX_REJECTED_JOBS, CUR_REJECTED_JOBS, AVG_REJECTED_JOBS, TOTAL_REJECTED_JOBS, MAX_CANCELED_JOBS, CUR_CANCELED_JOBS, AVG_CANCELED_JOBS, TOTAL_CANCELED_JOBS, MAX_JOBS_WAIT_TIME, CUR_JOBS_WAIT_TIME, AVG_JOBS_WAIT_TIME, MAX_JOBS_EXECUTE_TIME, CUR_JOBS_EXECUTE_TIME, AVG_JOBS_EXECUTE_TIME, TOTAL_JOBS_EXECUTE_TIME, TOTAL_EXECUTED_JOBS, TOTAL_EXECUTED_TASKS, TOTAL_BUSY_TIME, TOTAL_IDLE_TIME, CUR_IDLE_TIME, BUSY_TIME_PERCENTAGE, IDLE_TIME_PERCENTAGE, TOTAL_CPU, CUR_CPU_LOAD, AVG_CPU_LOAD, CUR_GC_CPU_LOAD, HEAP_MEMORY_INIT, HEAP_MEMORY_USED, HEAP_MEMORY_COMMITED, HEAP_MEMORY_MAX, HEAP_MEMORY_TOTAL, NONHEAP_MEMORY_INIT, NONHEAP_MEMORY_USED, NONHEAP_MEMORY_COMMITED, NONHEAP_MEMORY_MAX, NONHEAP_MEMORY_TOTAL, UPTIME, JVM_START_TIME, NODE_START_TIME, LAST_DATA_VERSION, CUR_THREAD_COUNT, MAX_THREAD_COUNT, TOTAL_THREAD_COUNT, CUR_DAEMON_THREAD_COUNT, SENT_MESSAGES_COUNT, SENT_BYTES_COUNT, RECEIVED_MESSAGES_COUNT, RECEIVED_BYTES_COUNT, OUTBOUND_MESSAGES_QUEUE FROM IGNITE.NODE_METRICS";
        List<List<?>> resMetrics = this.execSql(sqlAllMetrics, new Object[0]);
        this.assertColumnTypes(resMetrics.get(0), UUID.class, Timestamp.class, Integer.class, Integer.class, Float.class, Integer.class, Integer.class, Float.class, Integer.class, Integer.class, Float.class, Integer.class, Integer.class, Integer.class, Float.class, Integer.class, Time.class, Time.class, Time.class, Time.class, Time.class, Time.class, Time.class, Integer.class, Integer.class, Time.class, Time.class, Time.class, Float.class, Float.class, Integer.class, Double.class, Double.class, Double.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Time.class, Timestamp.class, Timestamp.class, Long.class, Integer.class, Integer.class, Long.class, Integer.class, Integer.class, Long.class, Integer.class, Long.class, Integer.class);
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)resAll.size());
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)this.execSql("SELECT NM.LAST_UPDATE_TIME FROM IGNITE.NODES N JOIN IGNITE.NODE_METRICS NM ON N.ID = NM.NODE_ID", new Object[0]).size());
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT LAST_UPDATE_TIME FROM IGNITE.NODE_METRICS WHERE NODE_ID = ?", this.nodeId(1)).size());
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT LAST_UPDATE_TIME FROM IGNITE.NODE_METRICS WHERE NODE_ID = ?", "-").size());
        SqlSystemViewsSelfTest.assertEquals((Object)3L, this.execSql("SELECT COUNT(*) FROM IGNITE.NODE_METRICS", new Object[0]).get(0).get(0));
        for (int i = 0; i < 100; ++i) {
            IgniteFuture fut = igniteSrv.compute(igniteSrv.cluster().forNodeId(nodeId0, new UUID[]{this.nodeId(1)})).broadcastAsync(new IgniteRunnable(){

                public void run() {
                    Random rnd = new Random();
                    try {
                        GridAbstractTest.doSleep((long)rnd.nextInt(100));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            if (i % 10 != 0) continue;
            fut.cancel();
        }
        SqlSystemViewsSelfTest.doSleep((long)(igniteSrv.configuration().getMetricsUpdateFrequency() * 3L));
        block1: for (Ignite grid : G.allGrids()) {
            UUID nodeId = grid.cluster().localNode().id();
            Ignite ignite = F.eq((Object)nodeId, (Object)nodeId0) ? igniteCli : igniteSrv;
            for (int i = 0; i < 10; ++i) {
                ClusterMetrics metrics = ignite.cluster().node(nodeId).metrics();
                SqlSystemViewsSelfTest.assertTrue((boolean)(metrics instanceof ClusterMetricsSnapshot));
                resMetrics = this.execSql(ignite, sqlAllMetrics + " WHERE NODE_ID = ?", nodeId);
                this.log.info("Check metrics for node " + grid.name() + ", attempt " + (i + 1));
                if (metrics.getLastUpdateTime() == ((Timestamp)resMetrics.get(0).get(1)).getTime()) {
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumActiveJobs(), resMetrics.get(0).get(2));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentActiveJobs(), resMetrics.get(0).get(3));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getAverageActiveJobs()), resMetrics.get(0).get(4));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumWaitingJobs(), resMetrics.get(0).get(5));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentWaitingJobs(), resMetrics.get(0).get(6));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getAverageWaitingJobs()), resMetrics.get(0).get(7));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumRejectedJobs(), resMetrics.get(0).get(8));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentRejectedJobs(), resMetrics.get(0).get(9));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getAverageRejectedJobs()), resMetrics.get(0).get(10));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalRejectedJobs(), resMetrics.get(0).get(11));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumCancelledJobs(), resMetrics.get(0).get(12));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentCancelledJobs(), resMetrics.get(0).get(13));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getAverageCancelledJobs()), resMetrics.get(0).get(14));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalCancelledJobs(), resMetrics.get(0).get(15));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getMaximumJobWaitTime(), (long)this.convertToMilliseconds(resMetrics.get(0).get(16)));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getCurrentJobWaitTime(), (long)this.convertToMilliseconds(resMetrics.get(0).get(17)));
                    SqlSystemViewsSelfTest.assertEquals((long)((long)metrics.getAverageJobWaitTime()), (long)this.convertToMilliseconds(resMetrics.get(0).get(18)));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getMaximumJobExecuteTime(), (long)this.convertToMilliseconds(resMetrics.get(0).get(19)));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getCurrentJobExecuteTime(), (long)this.convertToMilliseconds(resMetrics.get(0).get(20)));
                    SqlSystemViewsSelfTest.assertEquals((long)((long)metrics.getAverageJobExecuteTime()), (long)this.convertToMilliseconds(resMetrics.get(0).get(21)));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getTotalJobsExecutionTime(), (long)this.convertToMilliseconds(resMetrics.get(0).get(22)));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalExecutedJobs(), resMetrics.get(0).get(23));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalExecutedTasks(), resMetrics.get(0).get(24));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getTotalBusyTime(), (long)this.convertToMilliseconds(resMetrics.get(0).get(25)));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getTotalIdleTime(), (long)this.convertToMilliseconds(resMetrics.get(0).get(26)));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getCurrentIdleTime(), (long)this.convertToMilliseconds(resMetrics.get(0).get(27)));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getBusyTimePercentage()), resMetrics.get(0).get(28));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getIdleTimePercentage()), resMetrics.get(0).get(29));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalCpus(), resMetrics.get(0).get(30));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentCpuLoad(), resMetrics.get(0).get(31));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getAverageCpuLoad(), resMetrics.get(0).get(32));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentGcCpuLoad(), resMetrics.get(0).get(33));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryInitialized(), resMetrics.get(0).get(34));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryUsed(), resMetrics.get(0).get(35));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryCommitted(), resMetrics.get(0).get(36));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryMaximum(), resMetrics.get(0).get(37));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryTotal(), resMetrics.get(0).get(38));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryInitialized(), resMetrics.get(0).get(39));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryUsed(), resMetrics.get(0).get(40));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryCommitted(), resMetrics.get(0).get(41));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryMaximum(), resMetrics.get(0).get(42));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryTotal(), resMetrics.get(0).get(43));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getUpTime(), (long)this.convertToMilliseconds(resMetrics.get(0).get(44)));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getStartTime(), (long)((Timestamp)resMetrics.get(0).get(45)).getTime());
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getNodeStartTime(), (long)((Timestamp)resMetrics.get(0).get(46)).getTime());
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getLastDataVersion(), resMetrics.get(0).get(47));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentThreadCount(), resMetrics.get(0).get(48));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumThreadCount(), resMetrics.get(0).get(49));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalStartedThreadCount(), resMetrics.get(0).get(50));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentDaemonThreadCount(), resMetrics.get(0).get(51));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getSentMessagesCount(), resMetrics.get(0).get(52));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getSentBytesCount(), resMetrics.get(0).get(53));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getReceivedMessagesCount(), resMetrics.get(0).get(54));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getReceivedBytesCount(), resMetrics.get(0).get(55));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getOutboundMessagesQueueSize(), resMetrics.get(0).get(56));
                    continue block1;
                }
                this.log.info("Metrics was updated in background, will retry check");
                if (i != 9) continue;
                SqlSystemViewsSelfTest.fail((String)"Failed to check metrics, attempts limit reached (10)");
            }
        }
    }

    @Test
    public void testBaselineViews() throws Exception {
        this.cleanPersistenceDir();
        Ignite ignite = this.startGrid(this.getTestIgniteInstanceName(), this.getPdsConfiguration("node0"));
        this.startGrid(this.getTestIgniteInstanceName(1), this.getPdsConfiguration("node1"));
        ignite.cluster().active(true);
        List<List<?>> res = this.execSql("SELECT CONSISTENT_ID, ONLINE FROM IGNITE.BASELINE_NODES ORDER BY CONSISTENT_ID", new Object[0]);
        this.assertColumnTypes(res.get(0), String.class, Boolean.class);
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"node0", res.get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"node1", res.get(1).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)true, res.get(0).get(1));
        SqlSystemViewsSelfTest.assertEquals((Object)true, res.get(1).get(1));
        this.stopGrid(this.getTestIgniteInstanceName(1));
        res = this.execSql("SELECT CONSISTENT_ID FROM IGNITE.BASELINE_NODES WHERE ONLINE = false", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"node1", res.get(0).get(0));
        Ignite ignite2 = this.startGrid(this.getTestIgniteInstanceName(2), this.getPdsConfiguration("node2"));
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)this.execSql(ignite2, "SELECT CONSISTENT_ID FROM IGNITE.BASELINE_NODES", new Object[0]).size());
        res = this.execSql("SELECT CONSISTENT_ID FROM IGNITE.NODES N WHERE NOT EXISTS (SELECT 1 FROM IGNITE.BASELINE_NODES B WHERE B.CONSISTENT_ID = N.CONSISTENT_ID)", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"node2", res.get(0).get(0));
    }

    protected IgniteConfiguration getConfiguration() throws Exception {
        return super.getConfiguration().setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("default")});
    }

    @Test
    public void testCachesViews() throws Exception {
        DataStorageConfiguration dsCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setName("def").setPersistenceEnabled(true)).setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setName("dr1"), new DataRegionConfiguration().setName("dr2")});
        IgniteEx ignite0 = this.startGrid(this.getConfiguration().setDataStorageConfiguration(dsCfg));
        IgniteEx ignite1 = this.startGrid(this.getConfiguration().setDataStorageConfiguration(dsCfg).setIgniteInstanceName("node1"));
        ignite0.cluster().active(true);
        IgniteEx ignite2 = this.startGrid(this.getConfiguration().setDataStorageConfiguration(dsCfg).setIgniteInstanceName("node2"));
        IgniteEx ignite3 = this.startGrid(this.getConfiguration().setDataStorageConfiguration(dsCfg).setIgniteInstanceName("node3").setClientMode(true));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_atomic_part").setAtomicityMode(CacheAtomicityMode.ATOMIC).setCacheMode(CacheMode.PARTITIONED).setGroupName("cache_grp").setNodeFilter((IgnitePredicate)new TestNodeFilter(ignite0.cluster().localNode())));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_atomic_repl").setAtomicityMode(CacheAtomicityMode.ATOMIC).setCacheMode(CacheMode.REPLICATED).setDataRegionName("dr1").setTopologyValidator((TopologyValidator)new TestTopologyValidator()));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_tx_part").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.PARTITIONED).setGroupName("cache_grp").setNodeFilter((IgnitePredicate)new TestNodeFilter(ignite0.cluster().localNode())));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_tx_repl").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED).setDataRegionName("dr2").setEvictionFilter((EvictionFilter)new TestEvictionFilter()).setEvictionPolicyFactory((Factory)new TestEvictionPolicyFactory()).setOnheapCacheEnabled(true));
        this.execSql("CREATE TABLE cache_sql (ID INT PRIMARY KEY, VAL VARCHAR) WITH \"cache_name=cache_sql,template=partitioned,atomicity=atomic\"", new Object[0]);
        this.awaitPartitionMapExchange();
        List<List<?>> resAll = this.execSql("SELECT NAME, CACHE_ID, CACHE_TYPE, GROUP_ID, GROUP_NAME, CACHE_MODE, ATOMICITY_MODE, IS_ONHEAP_CACHE_ENABLED, IS_COPY_ON_READ, IS_LOAD_PREVIOUS_VALUE, IS_READ_FROM_BACKUP, PARTITION_LOSS_POLICY, NODE_FILTER, TOPOLOGY_VALIDATOR, IS_EAGER_TTL, WRITE_SYNCHRONIZATION_MODE, IS_INVALIDATE, IS_EVENTS_DISABLED, IS_STATISTICS_ENABLED, IS_MANAGEMENT_ENABLED, BACKUPS, AFFINITY, AFFINITY_MAPPER, REBALANCE_MODE, REBALANCE_BATCH_SIZE, REBALANCE_TIMEOUT, REBALANCE_DELAY, REBALANCE_THROTTLE, REBALANCE_BATCHES_PREFETCH_COUNT, REBALANCE_ORDER, EVICTION_FILTER, EVICTION_POLICY_FACTORY, IS_NEAR_CACHE_ENABLED, NEAR_CACHE_EVICTION_POLICY_FACTORY, NEAR_CACHE_START_SIZE, DEFAULT_LOCK_TIMEOUT, CACHE_INTERCEPTOR, CACHE_STORE_FACTORY, IS_STORE_KEEP_BINARY, IS_READ_THROUGH, IS_WRITE_THROUGH, IS_WRITE_BEHIND_ENABLED, WRITE_BEHIND_COALESCING, WRITE_BEHIND_FLUSH_SIZE, WRITE_BEHIND_FLUSH_FREQUENCY, WRITE_BEHIND_FLUSH_THREAD_COUNT, WRITE_BEHIND_FLUSH_BATCH_SIZE, MAX_CONCURRENT_ASYNC_OPERATIONS, CACHE_LOADER_FACTORY, CACHE_WRITER_FACTORY, EXPIRY_POLICY_FACTORY, IS_SQL_ESCAPE_ALL, SQL_SCHEMA, SQL_INDEX_MAX_INLINE_SIZE, IS_SQL_ONHEAP_CACHE_ENABLED, SQL_ONHEAP_CACHE_MAX_SIZE, QUERY_DETAILS_METRICS_SIZE, QUERY_PARALLELISM, MAX_QUERY_ITERATORS_COUNT, DATA_REGION_NAME FROM IGNITE.CACHES", new Object[0]);
        this.assertColumnTypes(resAll.get(0), String.class, Integer.class, String.class, Integer.class, String.class, String.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, String.class, String.class, String.class, Boolean.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Integer.class, String.class, String.class, String.class, Integer.class, Long.class, Long.class, Long.class, Long.class, Integer.class, String.class, String.class, Boolean.class, String.class, Integer.class, Long.class, String.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Integer.class, Long.class, Integer.class, Integer.class, Integer.class, String.class, String.class, String.class, Boolean.class, String.class, Integer.class, Boolean.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class);
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_tx_part", this.execSql("SELECT NAME FROM IGNITE.CACHES WHERE CACHE_MODE = 'PARTITIONED' AND ATOMICITY_MODE = 'TRANSACTIONAL' AND NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_atomic_repl", this.execSql("SELECT NAME FROM IGNITE.CACHES WHERE CACHE_MODE = 'REPLICATED' AND ATOMICITY_MODE = 'ATOMIC' AND NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)2L, this.execSql("SELECT COUNT(*) FROM IGNITE.CACHES WHERE GROUP_NAME = 'cache_grp'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_atomic_repl", this.execSql("SELECT NAME FROM IGNITE.CACHES WHERE DATA_REGION_NAME = 'dr1'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_tx_repl", this.execSql("SELECT NAME FROM IGNITE.CACHES WHERE DATA_REGION_NAME = 'dr2'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"PARTITIONED", this.execSql("SELECT CACHE_MODE FROM IGNITE.CACHES WHERE NAME = 'cache_atomic_part'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"USER", this.execSql("SELECT CACHE_TYPE FROM IGNITE.CACHES WHERE NAME = 'cache_sql'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)0L, this.execSql("SELECT COUNT(*) FROM IGNITE.CACHES WHERE NAME = 'no_such_cache'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)0L, this.execSql("SELECT COUNT(*) FROM IGNITE.CACHES WHERE NAME = 1", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"TestNodeFilter", this.execSql("SELECT NODE_FILTER FROM IGNITE.CACHES WHERE NAME = 'cache_atomic_part'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"TestEvictionFilter", this.execSql("SELECT EVICTION_FILTER FROM IGNITE.CACHES WHERE NAME = 'cache_tx_repl'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"TestEvictionPolicyFactory", this.execSql("SELECT EVICTION_POLICY_FACTORY FROM IGNITE.CACHES WHERE NAME = 'cache_tx_repl'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"TestTopologyValidator", this.execSql("SELECT TOPOLOGY_VALIDATOR FROM IGNITE.CACHES WHERE NAME = 'cache_atomic_repl'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals(this.execSql("SELECT COUNT(*) FROM IGNITE.CACHES", new Object[0]).get(0).get(0), this.execSql("SELECT COUNT(*) FROM IGNITE.CACHES WHERE CACHE_ID <> CACHE_ID + 1", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)5L, this.execSql("SELECT COUNT(*) FROM IGNITE.CACHES WHERE NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)5L, this.execSql((Ignite)ignite1, "SELECT COUNT(*) FROM IGNITE.CACHES WHERE NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)5L, this.execSql((Ignite)ignite2, "SELECT COUNT(*) FROM IGNITE.CACHES WHERE NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)5L, this.execSql((Ignite)ignite3, "SELECT COUNT(*) FROM IGNITE.CACHES WHERE NAME like 'cache%'", new Object[0]).get(0).get(0));
        resAll = this.execSql("SELECT ID, GROUP_NAME, IS_SHARED, CACHE_COUNT, CACHE_MODE, ATOMICITY_MODE, AFFINITY, PARTITIONS_COUNT, NODE_FILTER, DATA_REGION_NAME, TOPOLOGY_VALIDATOR, PARTITION_LOSS_POLICY, REBALANCE_MODE, REBALANCE_DELAY, REBALANCE_ORDER, BACKUPS FROM IGNITE.CACHE_GROUPS", new Object[0]);
        this.assertColumnTypes(resAll.get(0), Integer.class, String.class, Boolean.class, Integer.class, String.class, String.class, String.class, Integer.class, String.class, String.class, String.class, String.class, String.class, Long.class, Integer.class, Integer.class);
        SqlSystemViewsSelfTest.assertEquals((Object)2, this.execSql("SELECT CACHE_COUNT FROM IGNITE.CACHE_GROUPS WHERE GROUP_NAME = 'cache_grp'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_grp", this.execSql("SELECT GROUP_NAME FROM IGNITE.CACHE_GROUPS WHERE IS_SHARED = true AND GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_tx_repl", this.execSql("SELECT GROUP_NAME FROM IGNITE.CACHE_GROUPS WHERE ID = ?", ignite0.cachex("cache_tx_repl").context().groupId()).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT ID FROM IGNITE.CACHE_GROUPS WHERE ID = 0", new Object[0]).size());
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_tx_repl", this.execSql("SELECT CG.GROUP_NAME FROM IGNITE.CACHES C JOIN IGNITE.CACHE_GROUPS CG ON C.GROUP_ID = CG.ID WHERE C.NAME = 'cache_tx_repl'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_grp", this.execSql("SELECT CG.GROUP_NAME FROM IGNITE.CACHES C JOIN IGNITE.CACHE_GROUPS CG ON C.GROUP_NAME = CG.GROUP_NAME WHERE C.NAME = 'cache_tx_part'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)3L, this.execSql("SELECT COUNT(*) FROM IGNITE.CACHES C JOIN IGNITE.CACHE_GROUPS CG ON C.NAME = CG.GROUP_NAME WHERE C.NAME like 'cache%' AND C.CACHE_MODE = CG.CACHE_MODE AND C.ATOMICITY_MODE = CG.ATOMICITY_MODE AND COALESCE(C.AFFINITY, '-') = COALESCE(CG.AFFINITY, '-') AND COALESCE(C.NODE_FILTER, '-') = COALESCE(CG.NODE_FILTER, '-') AND COALESCE(C.DATA_REGION_NAME, '-') = COALESCE(CG.DATA_REGION_NAME, '-') AND COALESCE(C.TOPOLOGY_VALIDATOR, '-') = COALESCE(CG.TOPOLOGY_VALIDATOR, '-') AND C.PARTITION_LOSS_POLICY = CG.PARTITION_LOSS_POLICY AND C.REBALANCE_MODE = CG.REBALANCE_MODE AND C.REBALANCE_DELAY = CG.REBALANCE_DELAY AND C.REBALANCE_ORDER = CG.REBALANCE_ORDER AND C.BACKUPS = CG.BACKUPS", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals(this.execSql("SELECT COUNT(*) FROM IGNITE.CACHE_GROUPS", new Object[0]).get(0).get(0), this.execSql("SELECT COUNT(*) FROM IGNITE.CACHE_GROUPS WHERE ID <> ID + 1", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)4L, this.execSql("SELECT COUNT(*) FROM IGNITE.CACHE_GROUPS WHERE GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)4L, this.execSql((Ignite)ignite1, "SELECT COUNT(*) FROM IGNITE.CACHE_GROUPS WHERE GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)4L, this.execSql((Ignite)ignite2, "SELECT COUNT(*) FROM IGNITE.CACHE_GROUPS WHERE GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)4L, this.execSql((Ignite)ignite3, "SELECT COUNT(*) FROM IGNITE.CACHE_GROUPS WHERE GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
    }

    private IgniteConfiguration getPdsConfiguration(String consistentId) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration();
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)));
        cfg.setConsistentId((Serializable)((Object)consistentId));
        return cfg;
    }

    private long convertToMilliseconds(Object sqlTime) {
        Time time0 = (Time)sqlTime;
        return time0.getTime() + (long)TimeZone.getDefault().getOffset(time0.getTime());
    }

    private static class TestTopologyValidator
    implements TopologyValidator {
        private TestTopologyValidator() {
        }

        public boolean validate(Collection<ClusterNode> nodes) {
            return true;
        }

        public String toString() {
            return "TestTopologyValidator";
        }
    }

    private static class TestEvictionPolicyFactory
    implements Factory<EvictionPolicy<Object, Object>> {
        private TestEvictionPolicyFactory() {
        }

        public EvictionPolicy<Object, Object> create() {
            return new EvictionPolicy<Object, Object>(){

                public void onEntryAccessed(boolean rmv, EvictableEntry<Object, Object> entry) {
                }
            };
        }

        public String toString() {
            return "TestEvictionPolicyFactory";
        }
    }

    private static class TestEvictionFilter
    implements EvictionFilter<Object, Object> {
        private TestEvictionFilter() {
        }

        public boolean evictAllowed(Cache.Entry<Object, Object> entry) {
            return false;
        }

        public String toString() {
            return "TestEvictionFilter";
        }
    }

    private static class TestNodeFilter
    extends GridNodePredicate {
        public TestNodeFilter(ClusterNode node) {
            super(new ClusterNode[]{node});
        }

        public String toString() {
            return "TestNodeFilter";
        }
    }
}

