/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlPushDownFunctionTest
extends GridCommonAbstractTest {
    private IgniteEx node;

    protected void beforeTest() throws Exception {
        this.node = (IgniteEx)this.startGrid();
        this.startGrid(2);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testPushDownFunction() {
        this.sql("CREATE TABLE Person(id INTEGER PRIMARY KEY, company_id INTEGER)");
        this.sql("CREATE TABLE Company(id INTEGER PRIMARY KEY, name VARCHAR)");
        this.sql("INSERT INTO Person(id,company_id) VALUES (1, 1), (2, 2), (3, 3)");
        this.sql("INSERT INTO Company(id,name) VALUES (1,'n1'), (2,'n2'), (3,'n3')");
        this.sql("SELECT p.id, sum(p.id) FROM person p LEFT JOIN (select distinct id from company) as c on c.id=p.company_id GROUP BY p.id");
        this.sql("SELECT count(1) FROM person p LEFT JOIN (select id from company union select id from company) as c on c.id=p.company_id");
        this.sql("SELECT count(1) FROM person p LEFT JOIN (select id from company union select id from company) as c on c.id=p.company_id");
        this.sql("SELECT 1, (select count(1)) FROM person p LEFT JOIN (select id from company union select id from company) as c on c.id=p.company_id");
    }

    private List<List<?>> sql(String sql) {
        GridQueryProcessor qryProc = this.node.context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setSchema("PUBLIC");
        return qryProc.querySqlFields(qry, true).getAll();
    }
}

